Option Explicit

' ***********************************************************************************************************
' * Scriptname:  download.vbs
' * Version:     1.1 (26.10.2004)
' * Requirement: - WSH 2.0 oder grer
' *              - BITSADMIN.EXE Version 1.5 oder grer (im gleichen Verzeichnis, wie dieses Script)
' *
' * Description: Script zum Download einer Datei ber den Windows-Dienst BITS.
' *
' * Autor:       Stefan Finkenzeller
' * Parameter:   keine
' ***********************************************************************************************************

Main()

'**************
'***  Main  ***
'**************
Sub Main

    Dim objFSO, strJobname, strRemoteurl, strFilename
    Set objFSO = CreateObject("Scripting.FileSystemObject")

    ' Jobname generieren
    strJobname = "ctjob" & CStr(Year(Now) & Month(Now) & Day(Now) & "-" & Hour(Now) & Minute(Now) & Second(Now))
    
    ' RemoteURL und Lokaler Dateiname vom Benutzer abfragen
    GetUrlAndName strRemoteurl, strFilename
 
    ' Zielverzeichnis anlegen, wenn es noch nicht existiert
    CreateFolder objFSO, objFSO.GetParentFolderName(strFilename)
      
    ' BITS-Job anlegen
    CreateJob  strJobname
  
    ' Zu bertragende Datei an den BITS-Auftrag anhngen
    AddFile strJobname, strRemoteurl, strFilename
  
    '  Notifikation setzen
    SetNotify strJobname, strFilename
  
    ' Job starten
    ResumeJob strJobname
    
    ' Meldung dem Benutzer ausgeben
    Wscript.echo "Auftrag wurde BITS bergeben." 

End Sub


'*******************
'***  CreateJob  ***  BITS-Job anlegen
'*******************
Sub CreateJob(strJobname)
  
    Dim strBitsadmin, oWshShell, intRet, strBefehl 
  
    ' Pfad von BITSADMIN.EXE zusammenbauen (liegt im gleichen Verzeichnis, wie dieses Script)
    strBitsadmin = GetScriptPath() & "bitsadmin.exe"

    ' Kommando ausfhren
    set oWshShell = Wscript.CreateObject("Wscript.Shell") 
    strBefehl = AddQuotes(strBitsadmin) & " /create " & strJobname
    intRet = oWshShell.Run(strBefehl, 0, TRUE) 

    ' Prfen, ob alles geklappt hat (Returncode)
    If intRet <> 0 Then
      	CallError "Job konnte nicht angelegt werden.", strBefehl, intRet
    End If
  
End Sub


'*****************
'***  AddFile  *** Zu bertragende Datei an den BITS-Auftrag anhngen
'*****************
Sub AddFile(strJobname, strRemoteurl, strFilename)
  
    Dim strBitsadmin, oWshShell, intRet, strBefehl 
  
    ' Pfad von BITSADMIN.EXE zusammenbauen (liegt im gleichen Verzeichnis, wie dieses Script)
    strBitsadmin = GetScriptPath() & "bitsadmin.exe"
  
    ' Kommando ausfhren
    set oWshShell = Wscript.CreateObject("Wscript.Shell") 
    strBefehl = AddQuotes(strBitsadmin) & " /addfile " & strJobname & " " & strRemoteurl & " " & AddQuotes(strFilename)
    intRet = oWshShell.Run(strBefehl, 0, TRUE) 

    ' Prfen, ob alles geklappt hat (Returncode)
    If intRet <> 0 Then
      	CallError "Datei konnte nicht an den Job angehngt werden.", strBefehl, intRet
    End If
  
End Sub



'*******************
'***  SetNotify  *** Notifikation setzen
'*******************
Sub SetNotify(strJobname, strFilename)
  
    Dim strBitsadmin, oWshShell, intRet, strBefehl 
  
    ' Pfad von BITSADMIN.EXE zusammenbauen (liegt im gleichen Verzeichnis, wie dieses Script)
    strBitsadmin = GetScriptPath() & "bitsadmin.exe"
  
    ' Kommando ausfhren
    set oWshShell = Wscript.CreateObject("Wscript.Shell") 
    ' Setzen der Notifikation: "<Benachrichtigungsprogramm>" "nix <scriptname> <jobname> <lokale datei>"
    ' Hinweis zur "lokalen Datei": Alle darin vorkommenden Leerzeichen werden in "@~@" ungewandelt, damit der Name im 
    '    complete.vbs-Script kompett ankommt. (Kleiner Hack ;-))
    ' z.B. bitsadmin /setnotifycmdline x "C:\windows\system32\wscript.exe" "wscript.exe c:\bitssdk\complete.vbs x c:\bitssdk\xx.pdf"
    strBefehl = AddQuotes(strBitsadmin) & " /setnotifycmdline " & strJobname & " " _
              & AddQuotes(GetSystemroot() & "system32\wscript.exe") & " " _
              & AddQuotes("wscript.exe \" & AddQuotes(GetScriptPath() & "complete.vbs\") & " " & strJobname & " " & Replace(strFilename, " ", "@~@"))
'              & AddQuotes("wscript.exe " & GetScriptPath() & "complete.vbs " & strJobname & " " & Replace(strFilename, " ", "@~@"))
    intRet = oWshShell.Run(strBefehl, 0, TRUE) 

    ' Prfen, ob alles geklappt hat (Returncode)
    If intRet <> 0 Then
      	CallError "Benachrichtigungskommando konnte nicht an den Job angefgt werden.", strBefehl, intRet
    End If
  
End Sub


'*******************
'***  ResumeJob  *** BITS-Job starten
'*******************
Sub ResumeJob(strJobname)
  
    Dim strBitsadmin, oWshShell, intRet, strBefehl 
  
    ' Pfad von BITSADMIN.EXE zusammenbauen (liegt im gleichen Verzeichnis, wie dieses Script)
    strBitsadmin = GetScriptPath() & "bitsadmin.exe"
  
    ' Kommando ausfhren
    set oWshShell = Wscript.CreateObject("Wscript.Shell") 
    strBefehl = AddQuotes(strBitsadmin) & " /resume " & strJobname
    intRet = oWshShell.Run(strBefehl, 0, TRUE) 

    ' Prfen, ob alles geklappt hat (Returncode)
    If intRet <> 0 Then
      	CallError "Job konnte nicht gestartet werden.", strBefehl, intRet
    End If
  
End Sub


'***********************
'***  GetUrlAndName  *** RemoteURL und Lokaler Dateiname vom Benutzer abfragen
'***********************
Sub GetUrlAndName(strRemoteurl, strFilename)
  
    Dim strDefault 
    
    ' Remote URL eingeben
    strRemoteurl = InputBox("Geben Sie die URL der zu bertragenden Datei an: (z.B. http://www.heise.de/xx.pdf)", "BITS Dateibertragung - Remote URL (1/2)", "http://")
    If Len(strRemoteurl) <= 0 Then 
    	  WScript.echo "Sie haben das Script abgebrochen."
    	  WScript.quit(9)
    End If

    ' Vorbelegung mit dem Quelldateinamen
    strDefault = "C:\" & Right(strRemoteurl, Len(strRemoteurl) - InStrRev(strRemoteurl, "/"))

    ' Lokaler Dateiname eingeben
    strFilename = InputBox("Geben Sie den lokalen Datennamen (absolute Pfadangabe!) fr die zu bertragende Datei an: (z.B. c:\download\xx.pdf)", "BITS Dateibertragung - Lokaler Dateiname (2/2)", strDefault)
    If Len(strFilename) <= 0 Then 
    	  WScript.echo "Sie haben das Script abgebrochen."
    	  WScript.quit(9)
    End If
  
End Sub


' ****************************************************************************************
' **************************   H I L F S F U N K T I O N E N   ***************************
' ****************************************************************************************


'***********************
'***  GetScriptPath  *** Liefert den Pfad des aktuellen Scriptes zurck
'***********************
Function GetScriptPath()

    GetScriptPath = Left(Wscript.Scriptfullname, InStrRev(WScript.ScriptFullname, "\"))

End Function


'***********************
'***  GetSystemroot  *** Liefert den Pfad auf SystemRoot zurck (z.B. 'C:\winnt\')
'***********************
Function GetSystemroot()

    Dim objWshShell, objWshSysEnv

    Set objWshShell = WScript.CreateObject("Wscript.Shell")
    Set objWshSysEnv = objWshShell.Environment("PROCESS")
    GetSystemroot = objWshSysEnv("SYSTEMROOT") & "\"
    Set objWshSysEnv = nothing
    Set objWshShell = nothing

End Function


'*******************
'***  AddQuotes  *** Fgt an den Anfang und an das Ende Hochkommas an
'*******************
Function AddQuotes(strString)

    AddQuotes = Chr(34) & strString & Chr(34)
    
End Function


'*******************
'***  CallError  *** Gibt einen Fehler aus und beendet das Script
'*******************
Sub CallError(strErrortext, strBefehl, intError)

    ' Fehlermeldung ausgeben
    WScript.echo "*** FEHLER: " & strErrortext & " ***" & vbCRLF & "Befehl: '" & strBefehl & "'" & vbCRLF & "Fehlercode: " & CStr(intError)

    ' Script abbrechen
    Wscript.Quit(2)
   
End Sub



'**********************
'***  CreateFolder  *** Legt ein Verzeichnis bzw. Verzeichnisbaum an
'**********************
Sub CreateFolder(objFSO, strFolder)

    On Error Resume Next
    
    ' Prfen, ob man sich im Rootverzeichnis befindet
    If Len(strFolder) > 2 Then
        ' Prfen, ob es das bergeordnete Verzeichnis gibt
        If objFSO.FolderExists(objFSO.GetParentFolderName(strFolder)) = False Then
           CreateFolder objFSO, objFSO.GetParentFolderName(strFolder)
        End If

        ' Verzeichnis anlegen, wenn es noch nicht existiert
        If objFSO.FolderExists(strFolder) = False Then
            objFSO.CreateFolder(strFolder)
        End If
    End If
    
    ' Prfen, ob ein Fehler aufgetreten ist
    If Err.Number > 0 Then
    	  CallError "Kann Verzeichnis '" & strFolder & "' nicht anlegen!", "Verzeichnis anlegen", CStr(Err.Number)
    End If
    
    On Error GoTo 0
    
End Sub
