#define Timer   // Fr Emulatorbetrieb, da Ausgabe zu langsam
using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using Microsoft.WindowsCE.Forms;
using System.Runtime.InteropServices;
using System.Sound; 

namespace SoundDemo
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.Button bStart;
		public System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.Button bOpen;
		private System.Windows.Forms.Timer timer1;
		WaveIn win;  
		public Form1()
		{
			InitializeComponent();
			mymw =new MyMessageWindow(new mm_mim_cb(WaveInCB)); 
		}

		protected override void Dispose( bool disposing )
		{
			if (win != null)
				win.Close(); 
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
			this.bOpen = new System.Windows.Forms.Button();
			this.bStart = new System.Windows.Forms.Button();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.timer1 = new System.Windows.Forms.Timer();
			// 
			// bOpen
			// 
			this.bOpen.Location = new System.Drawing.Point(8, 8);
			this.bOpen.Size = new System.Drawing.Size(104, 24);
			this.bOpen.Text = "Open";
			this.bOpen.Click += new System.EventHandler(this.bOpen_Click);
			// 
			// bStart
			// 
			this.bStart.Enabled = false;
			this.bStart.Location = new System.Drawing.Point(128, 8);
			this.bStart.Size = new System.Drawing.Size(96, 24);
			this.bStart.Text = "Start";
			this.bStart.Click += new System.EventHandler(this.bStart_Click);
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 254);
			this.statusBar1.Size = new System.Drawing.Size(240, 16);
			this.statusBar1.Text = "statusBar1";
			// 
			// timer1
			// 
			this.timer1.Enabled = true;
			this.timer1.Interval = 300;
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// Form1
			// 
			this.Controls.Add(this.statusBar1);
			this.Controls.Add(this.bStart);
			this.Controls.Add(this.bOpen);
			this.Paint += new System.Windows.Forms.PaintEventHandler(this.Form1_Paint);

		}
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		static void Main() 
		{
			Application.Run(new Form1());
		}

		MyMessageWindow mymw;  
		WaveHeader[] whdr; 
		const int BufCount = 3;  
		public int bufPointer = 0; 
		bool WaitingForClose; 

		private void bOpen_Click(object sender, System.EventArgs e)
		{
			if(bOpen.Text == "Open")
			{
				bOpen.Text = "Close"; 
				bStart.Enabled = false; 
				win = new WaveIn(WAVEFORMAT._1M16, this.mymw.Hwnd); 
				bStart.Enabled = true; 
			}
			else
			{
				bOpen.Enabled = false; 
				bStart.Enabled = false; 
				bOpen.Text = "Closing"; 
				WaitingForClose = true; 
				win.Reset();  // Puffer zurckfordern 
#if Timer
				timer1.Enabled=false; 
#endif
			}
		}

		private void bStart_Click(object sender, System.EventArgs e)
		{
			if(bStart.Text == "Start") 
			{
				bStart.Text = "Stop"; 
				win.Start(); 
#if Timer
				timer1.Enabled=true; 
#endif
			}
			else
			{
				bStart.Text = "Start"; 
				win.Stop(); 
#if Timer
				timer1.Enabled=false; 
#endif
			}
		}

		public short[] DrawBuffer; 
		private void Form1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			const short scaleX =300; 
			const short shiftY =180; 
			if (DrawBuffer != null && DrawBuffer.Length > 0)
			{
				Pen p = new Pen(Color.Black); 
				int w = 2*DrawBuffer.Length/ClientRectangle.Width; 
				int y0 = 0, y1 = 0; 
				y0 = DrawBuffer[0]/scaleX+shiftY; 
				for(int i = 0, j = 0; i<DrawBuffer.Length-w; i+=w, j+=2)
				{
					y1 = DrawBuffer[i+w]/scaleX+shiftY; 
					e.Graphics.DrawLine(p, j, y0, j+1, y1); 
					y0 = y1; 
				}
			}
		}

		int bufsProcessed; 
		int bufsAdded; 
		delegate void mm_mim_cb (MM_MIM msg); 
		// Rckruf von MessageWindow delegiert
		public void WaveInCB (MM_MIM msg)
		{
			switch (msg)
			{
				case MM_MIM.OPEN: 
					Text = "Device opened"; 
					// Puffer an Treiber 
					whdr = new WaveHeader[BufCount]; 
					for (int i = 0; i< BufCount; i++)
					{
						whdr[i] = new WaveHeader(4096); 
						win.PrepareHeader(whdr[i]);
						win.AddBuffer(whdr[i]); 
					}
					win.Stop();  // Das Ding luft bei CE gleich los!
					statusBar1.Text = "Device opened";  
					bufsProcessed = 0; 
					bufPointer = 0; 
					WaitingForClose = false; 
					bufsAdded = BufCount; 
					bStart.Enabled = true; 
					break; 
				case MM_MIM.CLOSE: 
					Text = "Device closed";  
					break; 
				case MM_MIM.DATA: 
					DrawBuffer = whdr[bufPointer].ToShortArray(); 
					if (WaitingForClose) // Geordneter Rckzug
					{
						// restliche Puffer einsammeln, dann Gert schlieen
						win.UnPrepareHeader(whdr[bufPointer]); 
						whdr[bufPointer].Dispose(); 
						if (--bufsAdded == 0)
						{
							win.Close(); 
							bOpen.Text = "Open"; 
							bStart.Text = "Start"; 
							bOpen.Enabled = true; 
						}
					}
					else
						if (win.IsOpen)  // 
						win.AddBuffer(whdr[bufPointer]); 
					statusBar1.Text = (bufsProcessed++).ToString() + " buffers processed"; 
					bufPointer = (bufPointer + 1) % BufCount;  
#if !Timer
					Refresh(); // Das macht sonst der Timer!
#endif
					break; 
			}
		}

		private void timer1_Tick(object sender, System.EventArgs e)
		{
#if Timer
			Refresh(); // Das macht sonst der MM_MIM.DATA-Rckruf
#endif
		}

		class MyMessageWindow : MessageWindow
		{
			mm_mim_cb cb2Form; 
			public MyMessageWindow(mm_mim_cb cb) 
			{
				cb2Form = cb; 
			}
			protected override void  WndProc(ref Message msg)
			{
				cb2Form((MM_MIM) msg.Msg); 
			}
		}
	}
}
