// SetPass.cpp : Definiert den Einsprungpunkt fr die Konsolenanwendung.
//

#include <windows.h>
#include <stdio.h>
#include <ntsecapi.h>


#define gle	GetLastError

class CLsa  
{
public:
	int LsaStoreData(char *pszKey, char *pszData);
	int LsaRetrieveData(char *key, char *data);
	CLsa();
	virtual ~CLsa();
	
	LSA_OBJECT_ATTRIBUTES m_lsaOA;
	LSA_HANDLE	m_PolicyHandle;
	
};

//////////////////////////////////////////////////////////////////////
//
//	InitLsaUnicodeString
//
//////////////////////////////////////////////////////////////////////
void InitLsaUnicodeString(LSA_UNICODE_STRING *us, char *str)
{
	if (us->Buffer)
		free(us->Buffer);
	
	us->Length = 0;
	
	us->MaximumLength = 512;
	
	us->Buffer = (wchar_t *)malloc(512);
	
	if (us->Buffer)
		us->Buffer[0] = L'\0';
	
	MultiByteToWideChar(CP_ACP, 0, str, -1, us->Buffer, us->MaximumLength * 2);
	
	if (str)
		us->Length = strlen(str) * 2;
	else
		us->Length = 0;
}

//////////////////////////////////////////////////////////////////////
//
//	LsaUnicodeString2String
//
//////////////////////////////////////////////////////////////////////
void LsaUnicodeString2String(LSA_UNICODE_STRING *us, char *str)
{
	int		n;
	
	n = WideCharToMultiByte(CP_ACP, 0, us->Buffer, us->Length / 2, str, us->Length + 2 / 1, NULL, NULL);
	str[n] = '\0';
}


//////////////////////////////////////////////////////////////////////
//
//		FreeLsaUnicodeString
//
//////////////////////////////////////////////////////////////////////
void FreeLsaUnicodeString(LSA_UNICODE_STRING *us)
{
	if (us->Buffer)
		free(us->Buffer);
	
	us->Length = 0;
}


CLsa::CLsa()
{
	memset(&m_lsaOA, 0, sizeof(m_lsaOA));
	m_lsaOA.Length = sizeof(LSA_OBJECT_ATTRIBUTES);
	m_PolicyHandle = NULL;
}

CLsa::~CLsa()
{
	if (m_PolicyHandle != NULL)
		LsaClose(m_PolicyHandle);
}


//////////////////////////////////////////////////////////////////////
// 
//	RetrieveData
// 
//////////////////////////////////////////////////////////////////////
int CLsa::LsaRetrieveData(char *key, char *data)
{
	
	NTSTATUS					ntstatus;
	LSA_UNICODE_STRING			Key;
	LSA_UNICODE_STRING			Value;
	LSA_UNICODE_STRING			*pValue;
	
	//	LSA_HANDLE					m_PolicyHandle = NULL;
	PLSA_REFERENCED_DOMAIN_LIST refDomList	= NULL;
	PLSA_TRANSLATED_SID			sidList		= NULL;
	
	char						*acctTypeString = NULL;
	
	__try {
		memset((void *)&Key,	0, sizeof(LSA_UNICODE_STRING));
		memset((void *)&Value,	0, sizeof(LSA_UNICODE_STRING));
		
		
		if (m_PolicyHandle == NULL) {
			ntstatus = LsaOpenPolicy(	NULL, 
										&m_lsaOA, 
										GENERIC_READ			|
										GENERIC_EXECUTE			|
										POLICY_GET_PRIVATE_INFORMATION,		
										&m_PolicyHandle
				);
			
			if (0 != ntstatus) {
				printf("%lu [%08lxh], gle = %lu\n", ntstatus, gle, LsaNtStatusToWinError(ntstatus));
				m_PolicyHandle = NULL;
				return 0;
			}
		}
		
		InitLsaUnicodeString(&Key, key);
		InitLsaUnicodeString(&Value, NULL);
		
		ntstatus = LsaRetrievePrivateData(m_PolicyHandle, &Key, &pValue);
		LsaUnicodeString2String(pValue, data);
		
		LsaFreeMemory(pValue);
		
		FreeLsaUnicodeString(&Key);
		FreeLsaUnicodeString(&Value);
		
		
		if (0 != ntstatus) {
			printf("%lu [%08lxh], gle = %lu\n", ntstatus, gle, LsaNtStatusToWinError(ntstatus));
			return 0;
		}
		return 1;
	}
	__except(1) {
		printf("Exception in LsaStoreData\n");
		return -1;
	}
	return 1;
}




//-------------------------------------------------------------------------------
//
//	main
//
//-------------------------------------------------------------------------------

void
main()
{
	int		i;
	CLsa	lsa;
	char	buff[512];

	i = lsa.LsaRetrieveData("DefaultPassword", buff);

	if (i == 1) {
		printf("LSA:\\DefaultPassword: --> <%s>\n", buff);
	}
	else
		printf("Some Error ociurred.\n");


}