/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: adc.c 
 * Info: Routinen zum Einlesen der Analogeingnge
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 24.06.04
*/

#include <io.h>
#include <delay.h>
#include "adc.h"
#include "led.h"
#include "tools.h"
#include "display.h"

//Zum Kalibrieren bentigen wir Zwei Sttzstellen. Den Rest macht der Precompiler fr uns :-)
//Bitte entsprechend eintragen 


//Sensor 0
#define pt100_0_messwert_1 614.00	//Messwert 2
#define pt100_0_realwert_1 26.50	//passende temperatur in hunderstel Grad

#define pt100_0_messwert_2 458.00	//Messwert 1
#define pt100_0_realwert_2 12.30	//passende temperatur in hunderstel Grad 

//Sensor 0
#define pt100_1_messwert_1 740.00	//Messwert 2
#define pt100_1_realwert_1 31.60	//passende temperatur in hunderstel Grad

#define pt100_1_messwert_2 771.00	//Messwert 1
#define pt100_1_realwert_2 35.70	//passende temperatur in hunderstel Grad 


// Nicht bearbeiten!!!
#define pt100_0_faktor ((pt100_0_realwert_1-pt100_0_realwert_2)/(pt100_0_messwert_1-pt100_0_messwert_2))
#define pt100_0_offset (pt100_0_realwert_1- (pt100_0_faktor*pt100_0_messwert_1))
#define pt100_1_faktor ((pt100_1_realwert_1-pt100_1_realwert_2)/(pt100_1_messwert_1-pt100_1_messwert_2))
#define pt100_1_offset (pt100_1_realwert_1- (pt100_1_faktor*pt100_1_messwert_1))

const float korr_faktor[] ={pt100_0_faktor,pt100_1_faktor};
const float korr_offset[] ={pt100_0_offset,pt100_1_offset};


//Liest einen analogen kanal aus
//Der Parameter ist die Nummer des Pins (0x00 fr PA0; 0x01 fr PA1, ..)
int read_adc(char channel){
	int result = 0x00;
	char old_DDRA= DDRA;// Alte Einstellungen sichern
	char old_PORTA= PORTA;
	

	DDRA = DDRA & ~(1<<channel);	// Pin als input
	PORTA = PORTA & ~ (1<<channel);	// Alle Pullups aus.

//	DDRA &= ~ (1<<channel);	// Pin als input
//	PORTA &= ~ (1<<channel);	// Alle Pullups aus.
		
	ADMUX=(1<<REFS1)+(1<<REFS0)+(0<<ADLAR);	// interne Refernzspannung, rechts Ausrichtung
	ADMUX = ADMUX | channel;		// Und jetzt Kanal whlen
	
	ADCSRA= (1<<ADPS2) + (1<<ADPS1)+	// prescale faktor = 64 ADC luft mit 14,7456MHz / 64 = 230,4 kHz 
		(1 << ADEN)+			// ADC an
		(1 << ADSC);			// Beginne mit der Konvertierung
			
	while ( (ADCSRA & (1<<ADSC)) != 0){} //Warten bis konvertierung beendet
	
	result= ADCL + (ADCH <<8);	// Ergebnis zusammenbauen
	
	DDRA= old_DDRA;		// wiederherstellen
	PORTA= old_PORTA;
	
	return result;
}

//Liefert die Temperatur der PT100 Sensoren in Hunderstel Grad Celsius zurck 
int pt100_read(char channel){
	float temp =(float)read_adc(channel);	// Wert auslesen
	temp =((korr_faktor[channel] * temp) + korr_offset[channel]);
	return floor(temp*100);
}
