<?

// the recording-constants - need to start with a value > 0 !
define ("RSS_CHANNEL",          "1");
define ("RSS_IMAGE",            "2");
define ("RSS_ITEM",             "3");

class RSSParser {

  // parser dependant variables
  var $objParser;
  var $intOnRecording;
  var $strLastParsingError;
  var $strLastData;

  // data dependent variables
  var $arrRSSChannel;
  var $arrRSSItems;
  var $inxRSSItems;



  // class constructor
  function RSSParser() {

    $this->strLastParsingError  = array();
    $this->arrRSSChannel        = array();
    $this->arrRSSItems          = array();
    $this->inxRSSItems          = 0;
    $this->strLastData          = "";
    $this->intOnRecording       = 0;
    $this->objParser            = xml_parser_create();

    // set the default handlers
    xml_set_object($this->objParser, $this);
    xml_set_element_handler($this->objParser, "openTag", "closeTag");
    xml_set_character_data_handler($this->objParser, "data");

  } // constructor



  function runRSSParsingProcess ($strXMLCode) {

    // parse the given XML-Code
    xml_parse($this->objParser, $strXMLCode);

  } // runRSSParsingProcess


  // parser dependent methods
  // ==================================================================

  function openTag($parser, $tag, $attr) {

    switch ($tag) {

      // set the recording flag
      case "CHANNEL":   $this->intOnRecording = RSS_CHANNEL;  break;
      case "IMAGE":     $this->intOnRecording = RSS_IMAGE;    break;
      case "ITEM":      $this->intOnRecording = RSS_ITEM;     break;

    } // switch

    // handle attributes of tags
    switch ($tag) {
      case "RSS":
        $this->arrRSSChannel["version"] = $attr["VERSION"]; break;
    }  // switch

  } // function openTag(..)




  function closeTag($parser, $tag) {

    if ($this->intOnRecording == RSS_CHANNEL) {

      switch ($tag) {
        case "TITLE":         $this->arrRSSChannel["title"]       = $this->strLastData;   break;
        case "LINK":          $this->arrRSSChannel["link"]        = $this->strLastData;   break;
        case "DESCRIPTION":   $this->arrRSSChannel["description"] = $this->strLastData;   break;
      } // switch

    } else if ($this->intOnRecording == RSS_IMAGE) {

      switch ($tag) {
        case "TITLE":         $this->arrRSSChannel["imageTitle"]  = $this->strLastData;   break;
        case "URL":           $this->arrRSSChannel["imageURL" ]   = $this->strLastData;   break;
        case "LINK":          $this->arrRSSChannel["imageLink" ]  = $this->strLastData;   break;
      } // switch

    } else if ($this->intOnRecording == RSS_ITEM) {

      switch ($tag) {
        case "ITEM":          $this->inxRSSItems++;                                                   break;
        case "TITLE":         $this->arrRSSItems[$this->inxRSSItems]["title"] = $this->strLastData;   break;
        case "LINK":          $this->arrRSSItems[$this->inxRSSItems]["link"] = $this->strLastData;    break;
      } // switch

    } // if..else (onRecording)

    $this->strLastData = "";

  } // function closeTag(..)



  function data($parser, $data) {

    if ($this->intOnRecording != 0) {
      $this->strLastData .= trim($data);
    } // if

  } // function data(..)




  // get methods
  // ==================================================================

  function getRSSChannel() {
    return $this->arrRSSChannel;
  } // getRSSChannel()

  function getRSSItems() {
    return $this->arrRSSItems;
  } // getRSSItems()


} // class rssParser

?>