# -*- coding: ISO-8859-1 -*-
"""Die Blog-Applikation"""
# Von Klassen verwendeter Deskriptor fr Implementierung von Interfaces
from zope.interface import implements

# Diese geerbte Klasse ermglicht Persistenz in der ZODB
from persistent import Persistent

# BTreeContainer ist eine gute existierende Containter-Implementierung
from zope.app.container.btree import BTreeContainer
from zope.app.container.contained import Contained

# Die Interfaces aus interfaces.py
from blog.interfaces import IBlog, IBlogEntry, IContainedInBlog

class Blog(BTreeContainer):
    """Eine Blog-Implementierung, die blog.interfaces.IBlog befriedigt"""

    implements(IBlog)

class BlogEntry(Persistent, Contained):
    """Blog-Eintrag-Implementierung, befriedigt blog.interfaces.IBlogEntry

    >>> eintrag = BlogEntry()
    """

    implements(IBlogEntry, IContainedInBlog)

    # Der Konstruktor
    def __init__(self, subject=u'', text=u'', topics=u'',
                 renderer=u'zope.source.rest'):

        self.subject = subject
        self.text = text
        self.topics = topics
        self.renderer = renderer

    def getTopics(self):
        return ', '.join(self._topics)

    def setTopics(self, topics):
        if topics:
            topics = topics.split(', ')
        else:
            topics = [] # leere Liste
        self._topics = topics

    # Als Property verwendet die Eigenschaft self.topics automatisch
    # die Setter und Getter, wenn man sie setzt oder abruft
    topics = property(getTopics, setTopics)

    # self.topics gibt einen String zurck und ist damit eine Methode,
    # alle Topics als Liste (Sequence) zu liefern
    def getTopicsAsSequence(self):
        return self._topics

# Adapter bereitstellen, um Greninformationen an das ZMI zu liefern
from zope.app.size.interfaces import ISized
from zope.app.size import byteDisplay

class BlogEntrySized(object):

    implements(ISized)
    __used_for__ = IBlogEntry

    def __init__(self, entry):
        self.entry = entry

    def sizeForSorting(self):
        return ('item', self.sizeForDisplay())

    def sizeForDisplay(self):
        return byteDisplay(len(self.entry.text))
