/* $Id: deep_shallow.cpp 95 2004-12-15 10:37:15Z olau $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __GNUG__
#include <unistd.h>
#endif

#include "bwt.h"
#include "ds.h"

/*
* deep-shallow sort; Manzini/Ferragina. added by towi.
* to work this has to be linked against the original 
* implementation of the demo code of deep-shallow-sort.
*/
int ds_overshoot; // bit of extra space at the end of text needed for the 'ds' algorithm

void BWT_encode_DeepShallow(const char *T, BWT *bwt) 
{
   int *sa, i;
   // ----- init ds suffix sort routine
   //overshoot=init_ds_ssort(500,2000);
   if (ds_overshoot <= 0)
   {        
      fprintf(stderr,"ds initialization failed!\n"); exit(-1);
   }
   // ----- allocate text and suffix array
   sa = (int *) malloc(Mlen * sizeof(int *)); 
   if (! sa || ! T)
   {
      fprintf(stderr, "out of memory\n");
      exit(-1);
   }
   // ----- read [towi: copy] text and build suffix array
   //DONE. memcpy(text, T, (Mlen+overshoot)*sizeof *text);
   unsigned char *text = (unsigned char*) T;
   // sort suffixes
   ds_ssort(text, sa, Mlen); 
   // L aus sa extrahieren
   bwt->L = (char *) malloc(Mlen+1);
   bwt->I = -1;
   for (i = 0; i < Mlen; i++)
   {
      if (sa[i] == 0)
      {
         bwt->I = i;
         bwt->L[i] = T[Mlen-1];
      } 
      else
      {
         bwt->L[i] = T[sa[i]-1];
      }
   }
   bwt->L[Mlen] = '\0';
   if (bwt->I == -1)
   {
      fprintf(stderr,"ERROR I\n");
      exit(-1);
   }
   free(sa);
}
