using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Security.Permissions; 
using System.Security.Policy; 

namespace StrongNamePermisson
{
	/// <summary>
	/// Zusammenfassung fr Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
    private System.Windows.Forms.Button button1;
    private System.Windows.Forms.Button button2;
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		private System.ComponentModel.Container components = null;
    private StrongNameIdentityPermission snip; 

		public Form1()
		{
			//
			// Erforderlich fr die Windows Form-Designeruntersttzung
			//
			InitializeComponent();
      Evidence ev = this.GetType().Assembly.Evidence; 
      StrongName sn = null; 
      foreach(object o in ev)
        if (o.GetType() == typeof(StrongName))
          sn = (StrongName) o; 
      snip = new StrongNameIdentityPermission(PermissionState.None); 
      snip.PublicKey = sn.PublicKey; 
      snip.Version = sn.Version; 
      snip.Name = sn.Name; 
    }

		/// <summary>
		/// Die verwendeten Ressourcen bereinigen.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Vom Windows Form-Designer generierter Code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung. 
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		private void InitializeComponent()
		{
      this.button1 = new System.Windows.Forms.Button();
      this.button2 = new System.Windows.Forms.Button();
      this.SuspendLayout();
      // 
      // button1
      // 
      this.button1.Location = new System.Drawing.Point(48, 48);
      this.button1.Name = "button1";
      this.button1.Size = new System.Drawing.Size(200, 23);
      this.button1.TabIndex = 0;
      this.button1.Text = "Rufe gleichsignierte Assembly";
      this.button1.Click += new System.EventHandler(this.Signed_Click);
      // 
      // button2
      // 
      this.button2.Location = new System.Drawing.Point(46, 124);
      this.button2.Name = "button2";
      this.button2.Size = new System.Drawing.Size(200, 23);
      this.button2.TabIndex = 1;
      this.button2.Text = "Rufe anders signierte Assembly";
      this.button2.Click += new System.EventHandler(this.Unsigned_Click);
      // 
      // Form1
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(292, 218);
      this.Controls.Add(this.button2);
      this.Controls.Add(this.button1);
      this.Name = "Form1";
      this.Text = "StrongNamePermission";
      this.ResumeLayout(false);

    }
		#endregion

		/// <summary>
		/// Der Haupteinstiegspunkt fr die Anwendung.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

    private void Signed_Click(object sender, System.EventArgs e)
    {
      snip.Assert(); 
      SameStrongName s = new SameStrongName(snip.Name, snip.Version); 
      MessageBox.Show(s.hello); 
    }
    private void Unsigned_Click(object sender, System.EventArgs e)
    {
      snip.Assert(); 
      OtherStrongName o = new OtherStrongName(snip.Name, snip.Version); 
      MessageBox.Show(o.hello); 
    }
  }
}
