#include "data.h"
#include "bitvalue.h"
#include "config.h"

#include <math.h>

//--------------------------------------------------------
uint32 pi(uint64 n, uint32 b) /*prime number function, pi(n,b) = ~ p(n^(1/b) */
{
	if(n < 10) {
		return 10;
	}

	double s =
		pow( (double)(n), 1.0 /b );

	return (uint32)(s / ( log(s) - 1.1 )) + 10;
}
//--------------------------------------------------------
uint32 getshift(uint64 n, uint32 i) //i = incr(gsize * 30)
{
	double k, l = (i / 6.0) * _EC_SHIFT_FACTOR;

	k = sqrt(sqrt( (double)(n) ) + i);

	if(k > l) {
		l = ceil(k);
	}

	return (uint32) (l);
}
//--------------------------------------------------------
uint32 product(uint32 n) /*prime product function, n# */
{
	uint32 p = 2*3*5;	//5#
	
	for(uint32 i = 0; bitv[i] <= n; i++) {

		p *= bitv[i];
	}

	return p;
}
//--------------------------------------------------------
uint32 listsize(uint64 n, uint32 d) //d = incr(gsize * 30)
{
	double l = 
		ceil((sqrt( (double)(n) ) * 6.0 + d) / d);

	return (1 << (uint32) ceil(log(l) / log(2)));
}
//--------------------------------------------------------
