// Der Ameisenkolonie mit Ameisen und Pheromonpfad
public class AntColony {
	//Steuerungsparameter
	public final double DECAY_FACTOR = 0.3; 			//Verwitterungs-Faktor
	private final double START_PHEROMON = 0.00005;//Startwert
	private final int COUNT_ANTS = 70;						//Anzahl Ameisen
	private final int ITERATIONS = 300;						//Anzahl Iterationen
	private double[][] pheromon = null;						//Pheromonmatrix
	private static ProblemInstance data = null;		//TSP-Daten
	private Ant[] ants = null;										//Array mit Ameisen

	public AntColony(){
		int count = data.getCountCities();
		pheromon = new double[count][count]; //Pheromon initialisieren
		for (int i=0; i<count; i++)
			for (int j=0; j<count; j++)
				pheromon[i][j] = START_PHEROMON;
		ants = new Ant[COUNT_ANTS]; //Ameisen initialisieren
		for (int i=0; i<COUNT_ANTS; i++)
			ants[i] = new Ant(data, this);
	}

	public static void main(java.lang.String[] args) {
		data = new ProblemInstance();

		for (int i=0; i<100; i++){
			AntColony a = new AntColony();
			a.solveTsp();						//Steuerungsroutine aufrufen
			System.out.println(a.toString()); //Ergebnis ausgeben
		}
	}

	public void addPheromon(int from, int to, double phero){
		pheromon[from-1][to-1] += phero;
	}

	public double getPheromon(int from, int to) {
			return pheromon[from-1][to-1];
	}

	public void doDecay(){	//Verwitterung
		int count = data.getCountCities();
		for (int i=0; i<count; i++)
			for (int j=0; j<count; j++)
				pheromon[i][j] *= (1.0 - DECAY_FACTOR);
	}

	private Ant getBestAnt() { //beste Ameise zurckgeben
		int best = 0;
		double min = Double.MAX_VALUE;
		for (int i=0; i<COUNT_ANTS; i++){
		    double act = ants[i].getObjectiveValue();
		    if (act < min){
			    min = act;
			    best = i;
		    }
		}
		return ants[best]; //Ameise mit bestem Zielfunktionswert
	}

	public void solveTsp() { //Steuerungsroutine
		int iteration = 0;
		while (iteration < ITERATIONS){
			iteration ++;
			for (int i=0; i<COUNT_ANTS; i++){ //alle Ameisen
				ants[i].newRound();	//Ameise vorbereiten
				ants[i].lookForWay(); //Ameise losschicken
			}
			doDecay(); //Verwitterung
			getBestAnt().layPheromon(); //Pheromonabgabe
		}	//nchste Iteration
	}

	public String toString() {
		return getBestAnt().toString();
	}
}