<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!-- Es wird zunächst XSL-FO erzeugt, dass dann zu PDF weiterverarbeitet wird -->	
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:variable name="styleDoc" select="document('./sxw/styles.xml')"/>
    <!-- Basis Template, dass für das Seitenlayout zuständig ist -->
    <xsl:template match="/office:document-content" xmlns:office="http://openoffice.org/2000/office"  xmlns:style="http://openoffice.org/2000/style"  
    		xmlns:text="http://openoffice.org/2000/text"  xmlns:table="http://openoffice.org/2000/table" xmlns:draw="http://openoffice.org/2000/drawing"  
    		xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	    <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
    			<xsl:variable name="pageMaster" select="$styleDoc/office:document-styles/office:automatic-styles/style:page-master[1]"/>
	    		<fo:layout-master-set>	<!-- XSL-FO funtioniert wie ein DTP-Programm, zuerst werden die Page Master definiert, anschließend kommen die Inhalte -->
        			<fo:simple-page-master master-name="{$pageMaster/@style:name}"
          			margin-top="{$pageMaster/style:properties/@fo:margin-top}"  margin-bottom="{$pageMaster/style:properties/@fo:margin-bottom}"
          			margin-left="{$pageMaster/style:properties/@fo:margin-left}"  margin-right="{$pageMaster/style:properties/@fo:margin-right}"
          			page-width="{$pageMaster/style:properties/@fo:page-width}" page-height="{$pageMaster/style:properties/@fo:page-height}">
          			<fo:region-body margin-bottom="0.5cm">
      					<xsl:variable name="cStyle"><xsl:value-of select="//style:style[@style:family='section' and style:properties/style:columns/@fo:column-count > 1]"/></xsl:variable>
          				<xsl:if test="$cStyle">
          					<xsl:attribute name="column-count">3</xsl:attribute>
          					<xsl:attribute name="column-gap">1.0cm</xsl:attribute>
          				</xsl:if>
          			</fo:region-body>
          			<fo:region-after extent="1cm" display-align="after"/>
        			</fo:simple-page-master>
      		</fo:layout-master-set>
		     <fo:page-sequence master-reference="{$pageMaster/@style:name}">	<!-- Den Page Master mit Inhalten fülle -->
		     	<xsl:variable name="footer" select="$styleDoc/office:document-styles/office:master-styles/style:master-page[1]"/>
		     	<xsl:if test="$footer/style:footer">
	     		<fo:static-content flow-name="xsl-region-after">	<!-- Die Fußzeile einfügen. Static content erscheint auf jeder Seite -->
	     			<fo:block>
	     				<xsl:variable name="sName" select="$footer/style:footer/text:p/@text:style-name"/>
		     			<xsl:variable name="fStyle" select="$styleDoc/office:document-styles/office:automatic-styles/style:style[@style:name=$sName]"/>
	     				<xsl:if test="$fStyle/style:properties/@fo:text-align">
	     					<xsl:attribute name="text-align"><xsl:value-of select="$fStyle/style:properties/@fo:text-align"/></xsl:attribute>
	     				</xsl:if>
	     				<xsl:value-of select="$footer/style:footer/text:p/text()"/>
		     			<xsl:if test="$footer/style:footer/text:p/text:page-number"><fo:page-number/></xsl:if>
		     		</fo:block>
				</fo:static-content>
	     		</xsl:if>
			<fo:flow flow-name="xsl-region-body">	<!-- Die übrigen Inhalte einfügen -->
					<xsl:for-each select="office:body/child::*">
						<fo:block-container>
							<xsl:apply-templates select="."/>
						</fo:block-container>
					</xsl:for-each>
				</fo:flow>
			</fo:page-sequence>
	    </fo:root>
	</xsl:template>	<!-- In jedem Template braucht man erneut alle verwendeten Namespaces -->
	<xsl:template match="text:p"  xmlns:text="http://openoffice.org/2000/text" xmlns:style="http://openoffice.org/2000/style" xmlns:draw="http://openoffice.org/2000/drawing"  xmlns:xlink="http://www.w3.org/1999/xlink" 
			xmlns:office="http://openoffice.org/2000/office"  xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:variable name="styleID" select="./@text:style-name"/>
		<xsl:variable name="pStyle" select="$styleDoc/office:document-styles/office:styles/style:style[@style:name=$styleID]"/>
		<xsl:if test="local-name(..)='body'"><xsl:attribute name="span">all</xsl:attribute></xsl:if>
		<xsl:if test="draw:image"><fo:block><fo:external-graphic src="url({translate(draw:image/@xlink:href, '#', '')})"/></fo:block></xsl:if>
		<fo:block>
			<xsl:choose>		<!-- Für jeden Absatz p einen Block einfügen und dann das Template anwenden, um die Fomatierungsattribute zu setzen -->
				<xsl:when test="$pStyle"><xsl:apply-templates select="$pStyle"/></xsl:when>
				<xsl:otherwise><xsl:apply-templates select="/office:document-content/office:automatic-styles/style:style[@style:name=$styleID]"/></xsl:otherwise>
			</xsl:choose>
			<xsl:if test="draw:text-box"><xsl:apply-templates select="draw:text-box"/></xsl:if>
			<xsl:if test="text:span"><xsl:value-of select="text:span"/></xsl:if>
			<xsl:for-each select="./text()">		<!-- Anschließend den Text einfügen, es können sich aber auch noch Tabulatoren und Span Elemente dazwischen befinden -->
				<xsl:value-of select="."/>
				<xsl:if test="following-sibling::*[1]/child::*[1] or following-sibling::*[1]/text() or name(following-sibling::*[1])='text:tab-stop'">
					<xsl:apply-templates select="following-sibling::*[1]"/>
				</xsl:if>		<!-- Ziemlich häßliche Konstruktion, eigentlich vermeidet man in XML das Mischen von text() und Unterelementen -->
			</xsl:for-each>
		</fo:block>
	</xsl:template>	<!-- Überschriften behandeln. Bis auf die Nummerierung identisch mit den Absätzen -->
	<xsl:template match="text:h"  xmlns:text="http://openoffice.org/2000/text" xmlns:style="http://openoffice.org/2000/style" 
			xmlns:office="http://openoffice.org/2000/office"  xmlns:fo="http://www.w3.org/1999/XSL/Format"  xmlns:draw="http://openoffice.org/2000/drawing">
		<xsl:variable name="styleID" select="./@text:style-name"/>
		<xsl:variable name="pStyle" select="$styleDoc/office:document-styles/office:styles/style:style[@style:name=$styleID]"/>
		<xsl:if test="local-name(..)='body'"><xsl:attribute name="span">all</xsl:attribute></xsl:if>
		<fo:block>
			<xsl:apply-templates select="$pStyle"/>
			<xsl:if test="$pStyle/style:properties/@text:number-lines='true'">	<!-- wenn nummeriert werden soll -->
				<xsl:if test="@text:level='1'">
					<xsl:number level="any" count="text:h[@text:level='1']"/><xsl:text> </xsl:text>	<!-- Überschriften erster Ordnung -->
				</xsl:if>
				<xsl:if test="@text:level='2'">		<!-- Überschriften zweiter Ordnung -->
					<xsl:number level="any" count="text:h[@text:level='1']"/>.<xsl:number level="any" count="text:h[@text:level='2']" from="text:h[@text:level='1']" />
					<xsl:text> </xsl:text>
				</xsl:if>
			</xsl:if>
			<xsl:if test="draw:text-box"><xsl:apply-templates select="draw:text-box"/></xsl:if>
			<xsl:for-each select="./text()">		<!-- der Text und die Tabs -->
				<xsl:value-of select="."/>
				<xsl:if test="following-sibling::*[1]/child::*[1] or following-sibling::*[1]/text() or name(following-sibling::*[1])='text:tab-stop'">
					<xsl:apply-templates select="following-sibling::*[1]"/>
				</xsl:if>
			</xsl:for-each>
		</fo:block>
	</xsl:template>		<!-- Bereiche -->
	<xsl:template match="text:section" xmlns:text="http://openoffice.org/2000/text" xmlns:style="http://openoffice.org/2000/style" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:if test="local-name(..)='body'"><xsl:attribute name="span">none</xsl:attribute></xsl:if>
		<xsl:apply-templates select="text:p"/>
	</xsl:template>		<!-- Inhaltsverzeichnis -->
	<xsl:template match="text:table-of-content" xmlns:text="http://openoffice.org/2000/text" xmlns:style="http://openoffice.org/2000/style" 
		xmlns:office="http://openoffice.org/2000/office" xmlns:fo="http://www.w3.org/1999/XSL/Format" >
		<xsl:if test="local-name(..)='body'"><xsl:attribute name="span">all</xsl:attribute></xsl:if>
		<fo:block>
			<xsl:variable name="hStyle" select="text:index-body/text:index-title/text:p/@text:style-name"/>
			<xsl:apply-templates select="$styleDoc/office:document-styles/office:styles/style:style[@style:name=$hStyle]"/>
			<xsl:value-of select="text:index-body/text:index-title/text:p"/>
		</fo:block>
		<xsl:for-each select="text:index-body/text:p">	<!-- erst die Nummer, dann Abstand, dann der Text, dann die Punkte und zuletzt die Seitenzahl -->
			<fo:block text-align-last="justify">
				<xsl:value-of select="./text()[1]"/>
				<fo:leader leader-length="0.3cm" leader-pattern="space"/>
				<xsl:value-of select="./text()[2]"/>
				<fo:leader leader-pattern="dots"/>
				<xsl:value-of select="./text()[3]"/>
			</fo:block>
		</xsl:for-each>
	</xsl:template>	
	<!-- das Tabellenverzeichnis funktioniert absolut analog zum Inhaltsverzeichnis, mit ein bisschen Aufwand kann man die beiden Templates zusammenführen -->
	<xsl:template match="text:table-index" xmlns:text="http://openoffice.org/2000/text" xmlns:style="http://openoffice.org/2000/style" 
		xmlns:office="http://openoffice.org/2000/office" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:if test="local-name(..)='body'"><xsl:attribute name="span">all</xsl:attribute></xsl:if>
		<fo:block>
			<xsl:variable name="hStyle" select="text:index-body/text:index-title/text:p/@text:style-name"/>
			<xsl:apply-templates select="$styleDoc/office:document-styles/office:styles/style:style[@style:name=$hStyle]"/>
			<xsl:value-of select="text:index-body/text:index-title/text:p"/>
		</fo:block>
		<xsl:for-each select="text:index-body/text:p">
			<fo:block text-align-last="justify">
				<xsl:value-of select="./text()[1]"/>
				<fo:leader leader-pattern="dots"/>
				<xsl:value-of select="./text()[2]"/>
			</fo:block>
		</xsl:for-each>
	</xsl:template>		<!-- Tabellen -->
	<xsl:template match="table:table" xmlns:text="http://openoffice.org/2000/text" xmlns:style="http://openoffice.org/2000/style" 
		xmlns:office="http://openoffice.org/2000/office"  xmlns:table="http://openoffice.org/2000/table" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:if test="local-name(..)='body'"><xsl:attribute name="span">all</xsl:attribute></xsl:if>
		<fo:table table-layout="fixed"  border="2pt solid black">
			<xsl:variable name="tblStyleName" select="table:table-column/@table:style-name"/>
			<xsl:variable name="tblStyle" select="/office:document-content/office:automatic-styles/style:style[@style:name=$tblStyleName]"/>
			<xsl:for-each select="table:table-header-rows/table:table-row/table:table-cell">	<!-- Das funktioniert nur für Tabellen mit gleichen Spaltenbreiten -->
				<fo:table-column column-width="{$tblStyle/style:properties/@style:column-width}"/>
			</xsl:for-each>
			<fo:table-header>	<!-- Der Header ist in OO explizit ausgewiesen -->
				<xsl:for-each select="table:table-header-rows/table:table-row">
					<fo:table-row>
						<xsl:for-each select="table:table-cell">
							<fo:table-cell  border="1pt solid black">
								<xsl:apply-templates select="text:p"/>
							</fo:table-cell>
						</xsl:for-each>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-header>
			<fo:table-body>
				<xsl:for-each select="table:table-row">	<!-- Die restlichen Zeilen, der Einfachheit halber mit festen Font und Abstandsgrößen -->
					<fo:table-row space-before.optimum="3pt">
						<xsl:for-each select="table:table-cell">
							<fo:table-cell   border="1pt solid black">
								<fo:block font-family="Times" font-size="12pt" margin-left="3pt" margin-right="3pt" margin-top="3pt" margin-bottom="3pt">
									<xsl:value-of select="text:p"/>
								</fo:block>
							</fo:table-cell>
						</xsl:for-each>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>	<!-- So würde es funktionieren, wenn das Float-Element unterstützt würde -->
	<xsl:template match="draw:text-box"  xmlns:draw="http://openoffice.org/2000/drawing"  xmlns:xlink="http://www.w3.org/1999/xlink" 
			  xmlns:text="http://openoffice.org/2000/text" xmlns:fo="http://www.w3.org/1999/XSL/Format">
			 <fo:float float="right">
				<xsl:apply-templates select="text:p"/>
			</fo:float>
	</xsl:template>	<!-- Die Formatierungen aus dem Stylesheet zusammensuchen -->
	<xsl:template match="style:style" xmlns:style="http://openoffice.org/2000/style"  xmlns:office="http://openoffice.org/2000/office"  	 xmlns:text="http://openoffice.org/2000/text" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:if test="@style:parent-style-name">
			<xsl:variable name="parent" select="@style:parent-style-name"/>	<!-- rekursiver Aufruf des Templates -->
			<xsl:apply-templates select="$styleDoc/office:document-styles/office:styles/style:style[@style:name=$parent]"/>
		</xsl:if>
		<xsl:if test="style:properties/@fo:font-size">
			<xsl:attribute name="font-size"><xsl:value-of select="style:properties/@fo:font-size"/></xsl:attribute>
			<xsl:attribute name="line-height"><xsl:value-of select="style:properties/@fo:font-size"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="style:properties/@fo:font-weight">
			<xsl:attribute name="font-weight"><xsl:value-of select="style:properties/@fo:font-weight"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="style:properties/@fo:text-align">
			<xsl:attribute name="text-align"><xsl:value-of select="style:properties/@fo:text-align"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="style:properties/@style:font-name">
			<xsl:attribute name="font-family"><xsl:value-of select="substring-before(style:properties/@style:font-name, ' ')"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="style:properties/@fo:margin-top">
			<xsl:attribute name="space-before"><xsl:value-of select="style:properties/@fo:margin-top"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="style:properties/@fo:margin-bottom">
			<xsl:attribute name="space-after"><xsl:value-of select="style:properties/@fo:margin-bottom"/></xsl:attribute>
		</xsl:if>
		<xsl:if test="style:properties/@style:text-underline='single'">
			<xsl:attribute name="text-decoration">underline</xsl:attribute>
		</xsl:if>
	</xsl:template>	<!-- Beschriftungen -->
	<xsl:template match="text:sequence" xmlns:text="http://openoffice.org/2000/text" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<xsl:value-of select="./text()"/>
	</xsl:template>	<!-- Tabulatoren -->
	<xsl:template match="text:tab-stop" xmlns:text="http://openoffice.org/2000/text" xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<fo:leader leader-pattern="space" leader-length="0.3cm"/>
	</xsl:template>	<!-- Inline-Formatierungen -->
	<xsl:template match="text:span" xmlns:text="http://openoffice.org/2000/text" xmlns:style="http://openoffice.org/2000/style" 
			xmlns:office="http://openoffice.org/2000/office"  xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<fo:inline>
			<xsl:variable name="styleName" select="@text:style-name"/>
			<xsl:variable name="tStyleProp" select="/office:document-content/office:automatic-styles/style:style[@style:name=$styleName]/style:properties"/>
			<xsl:if test="$tStyleProp/@fo:font-style"><xsl:attribute name="font-style"><xsl:value-of select="$tStyleProp/@fo:font-style"/></xsl:attribute></xsl:if>
			<xsl:if test="$tStyleProp/@fo:font-weight"><xsl:attribute name="font-weight"><xsl:value-of select="$tStyleProp/@fo:font-weight"/></xsl:attribute></xsl:if>
			<xsl:if test="$tStyleProp/@style:text-underline"><xsl:attribute name="text-decoration">underline</xsl:attribute></xsl:if>
			<xsl:value-of select="."/>
		</fo:inline>
	</xsl:template>
</xsl:stylesheet>
