/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdfparser.PDFObjectStreamParser;
import org.pdfbox.persistence.util.COSObjectKey;

public class COSDocument
extends COSBase {
    private float version;
    private List objects = new ArrayList();
    private Map objectPool = new HashMap();
    private COSDictionary trailer;
    private RandomAccessFile scratchFile = null;
    private File tmpFile = null;
    private String headerString = "%PDF-1.4";

    public COSDocument() throws IOException {
        this(new File(System.getProperty("java.io.tmpdir")));
    }

    public COSDocument(File scratchDir) throws IOException {
        this.tmpFile = File.createTempFile("pdfbox", "tmp", scratchDir);
        this.scratchFile = new RandomAccessFile(this.tmpFile, "rw");
    }

    public COSDocument(RandomAccessFile file) {
        this.scratchFile = file;
    }

    public RandomAccessFile getScratchFile() {
        return this.scratchFile;
    }

    public COSObject getObjectByType(String type) {
        return this.getObjectByType(COSName.getPDFName(type));
    }

    public COSObject getObjectByType(COSName type) {
        COSObject retval = null;
        Iterator iter = this.objects.iterator();
        while (iter.hasNext() && retval == null) {
            COSDictionary dic;
            COSName objectType;
            COSObject object = (COSObject)iter.next();
            COSBase realObject = object.getObject();
            if (!(realObject instanceof COSDictionary) || (objectType = (COSName)(dic = (COSDictionary)realObject).getItem(COSName.TYPE)) == null || !objectType.equals(type)) continue;
            retval = object;
        }
        return retval;
    }

    public List getObjectsByType(String type) {
        return this.getObjectsByType(COSName.getPDFName(type));
    }

    public List getObjectsByType(COSName type) {
        ArrayList<COSObject> retval = new ArrayList<COSObject>();
        Iterator iter = this.objects.iterator();
        while (iter.hasNext()) {
            COSDictionary dic;
            COSName objectType;
            COSObject object = (COSObject)iter.next();
            COSBase realObject = object.getObject();
            if (realObject instanceof COSStream) {
                realObject = ((COSStream)realObject).getDictionary();
            }
            if (!(realObject instanceof COSDictionary) || (objectType = (COSName)(dic = (COSDictionary)realObject).getItem(COSName.TYPE)) == null || !objectType.equals(type)) continue;
            retval.add(object);
        }
        return retval;
    }

    public void print() {
        Iterator iter = this.objects.iterator();
        while (iter.hasNext()) {
            COSObject object = (COSObject)iter.next();
            System.out.println(object);
        }
    }

    public void setVersion(float versionValue) {
        this.version = versionValue;
    }

    public float getVersion() {
        return this.version;
    }

    public boolean isEncrypted() {
        boolean encrypted = false;
        if (this.trailer != null) {
            encrypted = this.trailer.getDictionaryObject("Encrypt") != null;
        }
        return encrypted;
    }

    public COSDictionary getEncryptionDictionary() {
        return (COSDictionary)this.trailer.getDictionaryObject(COSName.getPDFName("Encrypt"));
    }

    public void setEncryptionDictionary(COSDictionary encDictionary) {
        this.trailer.setItem(COSName.getPDFName("Encrypt"), (COSBase)encDictionary);
    }

    public COSArray getDocumentID() {
        return (COSArray)this.getTrailer().getItem(COSName.getPDFName("ID"));
    }

    public void setDocumentID(COSArray id) {
        this.getTrailer().setItem(COSName.getPDFName("ID"), (COSBase)id);
    }

    public COSObject getCatalog() throws IOException {
        COSObject catalog = this.getObjectByType(COSName.CATALOG);
        if (catalog == null) {
            throw new IOException("Catalog cannot be found");
        }
        return catalog;
    }

    public List getObjects() {
        return new ArrayList(this.objects);
    }

    public COSDictionary getTrailer() {
        return this.trailer;
    }

    public void setTrailer(COSDictionary newTrailer) {
        this.trailer = newTrailer;
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromDocument(this);
    }

    public void close() throws IOException {
        if (this.scratchFile != null) {
            this.scratchFile.close();
            this.scratchFile = null;
        }
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
    }

    protected void finalize() {
        if (this.tmpFile != null || this.scratchFile != null) {
            Throwable t = new Throwable("Warning: You did not close the PDF Document");
            t.printStackTrace();
        }
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String header) {
        this.headerString = header;
    }

    public void dereferenceObjectStreams() throws IOException {
        Iterator objStm = this.getObjectsByType("ObjStm").iterator();
        while (objStm.hasNext()) {
            COSObject objStream = (COSObject)objStm.next();
            COSStream stream = (COSStream)objStream.getObject();
            PDFObjectStreamParser parser = new PDFObjectStreamParser(stream, this);
            parser.parse();
            Iterator compressedObjects = parser.getObjects().iterator();
            while (compressedObjects.hasNext()) {
                COSObject next = (COSObject)compressedObjects.next();
                COSObjectKey key = new COSObjectKey(next);
                COSObject obj = this.getObjectFromPool(key);
                obj.setObject(next.getObject());
            }
        }
    }

    public COSObject addObject(COSObject obj) throws IOException {
        COSObjectKey key = null;
        if (obj.getObjectNumber() != null) {
            key = new COSObjectKey(obj);
        }
        COSObject fromPool = this.getObjectFromPool(key);
        fromPool.setObject(obj.getObject());
        return fromPool;
    }

    public COSObject getObjectFromPool(COSObjectKey key) throws IOException {
        COSObject obj = null;
        if (key != null) {
            obj = (COSObject)this.objectPool.get(key);
        }
        if (obj == null) {
            obj = new COSObject(null);
            if (key != null) {
                obj.setObjectNumber(new COSInteger(key.getNumber()));
                obj.setGenerationNumber(new COSInteger(key.getGeneration()));
                this.objectPool.put(key, obj);
            }
            this.objects.add(obj);
        }
        return obj;
    }
}

