/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.filter;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.cos.COSName;
import org.pdfbox.filter.ASCII85Filter;
import org.pdfbox.filter.ASCIIHexFilter;
import org.pdfbox.filter.CCITTFaxDecodeFilter;
import org.pdfbox.filter.DCTFilter;
import org.pdfbox.filter.Filter;
import org.pdfbox.filter.FlateFilter;
import org.pdfbox.filter.LZWFilter;
import org.pdfbox.filter.RunLengthDecodeFilter;

public class FilterManager {
    private Map filters = new HashMap();

    public FilterManager() {
        FlateFilter flateFilter = new FlateFilter();
        DCTFilter dctFilter = new DCTFilter();
        CCITTFaxDecodeFilter ccittFaxFilter = new CCITTFaxDecodeFilter();
        LZWFilter lzwFilter = new LZWFilter();
        ASCIIHexFilter asciiHexFilter = new ASCIIHexFilter();
        ASCII85Filter ascii85Filter = new ASCII85Filter();
        RunLengthDecodeFilter runLengthFilter = new RunLengthDecodeFilter();
        this.addFilter(COSName.FLATE_DECODE, flateFilter);
        this.addFilter(COSName.FLATE_DECODE_ABBREVIATION, flateFilter);
        this.addFilter(COSName.DCT_DECODE, dctFilter);
        this.addFilter(COSName.DCT_DECODE_ABBREVIATION, dctFilter);
        this.addFilter(COSName.CCITTFAX_DECODE, ccittFaxFilter);
        this.addFilter(COSName.CCITTFAX_DECODE_ABBREVIATION, ccittFaxFilter);
        this.addFilter(COSName.LZW_DECODE, lzwFilter);
        this.addFilter(COSName.LZW_DECODE_ABBREVIATION, lzwFilter);
        this.addFilter(COSName.ASCII_HEX_DECODE, asciiHexFilter);
        this.addFilter(COSName.ASCII_HEX_DECODE_ABBREVIATION, asciiHexFilter);
        this.addFilter(COSName.ASCII85_DECODE, ascii85Filter);
        this.addFilter(COSName.RUN_LENGTH_DECODE, runLengthFilter);
        this.addFilter(COSName.RUN_LENGTH_DECODE_ABBREVIATION, runLengthFilter);
    }

    public Collection getFilters() {
        return this.filters.values();
    }

    public void addFilter(COSName filterName, Filter filter) {
        this.filters.put(filterName, filter);
    }

    public Filter getFilter(COSName filterName) throws IOException {
        Filter filter = (Filter)this.filters.get(filterName);
        if (filter == null) {
            throw new IOException("Unknown stream filter:" + filterName);
        }
        return filter;
    }
}

