/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.fdf;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDTextStream;
import org.pdfbox.pdmodel.fdf.FDFIconFit;
import org.pdfbox.pdmodel.fdf.FDFNamedPageReference;
import org.pdfbox.pdmodel.fdf.FDFOptionElement;
import org.pdfbox.pdmodel.interactive.action.PDAction;
import org.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.pdfbox.pdmodel.interactive.action.PDAdditionalActions;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.pdfbox.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FDFField
implements COSObjectable {
    private COSDictionary field;

    public FDFField() {
        this.field = new COSDictionary();
    }

    public FDFField(COSDictionary f) {
        this.field = f;
    }

    public FDFField(Element fieldXML) throws IOException {
        this();
        this.setPartialFieldName(fieldXML.getAttribute("name"));
        NodeList nodeList = fieldXML.getChildNodes();
        ArrayList<FDFField> kids = new ArrayList<FDFField>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (child.getTagName().equals("value")) {
                this.setValue(XMLUtil.getNodeValue(child));
                continue;
            }
            if (child.getTagName().equals("value-richtext")) {
                this.setRichText(new PDTextStream(XMLUtil.getNodeValue(child)));
                continue;
            }
            if (!child.getTagName().equals("field")) continue;
            kids.add(new FDFField(child));
        }
        if (kids.size() > 0) {
            this.setKids(kids);
        }
    }

    public void writeXML(Writer output) throws IOException {
        List kids;
        PDTextStream rt;
        output.write("<field name=\"" + this.getPartialFieldName() + "\">\n");
        Object value = this.getValue();
        if (value != null) {
            output.write("<value>" + value + "</value>\n");
        }
        if ((rt = this.getRichText()) != null) {
            output.write("<value-richtext>" + rt.getAsString() + "</value-richtext>\n");
        }
        if ((kids = this.getKids()) != null) {
            for (int i = 0; i < kids.size(); ++i) {
                ((FDFField)kids.get(i)).writeXML(output);
            }
        }
        output.write("</field>\n");
    }

    public COSBase getCOSObject() {
        return this.field;
    }

    public COSDictionary getCOSDictionary() {
        return this.field;
    }

    public List getKids() {
        COSArray kids = (COSArray)this.field.getDictionaryObject("Kids");
        COSArrayList retval = null;
        if (kids != null) {
            ArrayList<FDFField> actuals = new ArrayList<FDFField>();
            for (int i = 0; i < kids.size(); ++i) {
                actuals.add(new FDFField((COSDictionary)kids.getObject(i)));
            }
            retval = new COSArrayList(actuals, kids);
        }
        return retval;
    }

    public void setKids(List kids) {
        this.field.setItem("Kids", (COSBase)COSArrayList.converterToCOSArray(kids));
    }

    public String getPartialFieldName() {
        return this.field.getString("T");
    }

    public void setPartialFieldName(String partial) {
        this.field.setString("T", partial);
    }

    public Object getValue() throws IOException {
        Object retval = null;
        COSBase value = this.field.getDictionaryObject("V");
        if (value instanceof COSName) {
            retval = ((COSName)value).getName();
        } else if (value instanceof COSArray) {
            retval = COSArrayList.convertCOSStringCOSArrayToList((COSArray)value);
        } else if (value instanceof COSString || value instanceof COSStream) {
            retval = PDTextStream.createTextStream(value);
        } else if (value != null) {
            throw new IOException("Error:Unknown type for field import" + value);
        }
        return retval;
    }

    public void setValue(Object value) throws IOException {
        COSBase cos = null;
        if (value instanceof List) {
            cos = COSArrayList.convertStringListToCOSStringCOSArray((List)value);
        } else if (value instanceof String) {
            cos = COSName.getPDFName((String)value);
        } else if (value instanceof COSObjectable) {
            cos = ((COSObjectable)value).getCOSObject();
        } else if (value != null) {
            throw new IOException("Error:Unknown type for field import" + value);
        }
        this.field.setItem("V", cos);
    }

    public Integer getFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject("Ff");
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = new COSInteger(ff);
        }
        this.field.setItem("Ff", value);
    }

    public void setFieldFlags(int ff) {
        this.field.setItem("Ff", (COSBase)new COSInteger(ff));
    }

    public Integer getSetFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject("SetFf");
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setSetFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = new COSInteger(ff);
        }
        this.field.setItem("SetFf", value);
    }

    public void setSetFieldFlags(int ff) {
        this.field.setItem("SetFf", (COSBase)new COSInteger(ff));
    }

    public Integer getClearFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject("ClrFf");
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setClearFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = new COSInteger(ff);
        }
        this.field.setItem("ClrFf", value);
    }

    public void setClearFieldFlags(int ff) {
        this.field.setItem("ClrFf", (COSBase)new COSInteger(ff));
    }

    public Integer getWidgetFieldFlags() {
        Integer retval = null;
        COSNumber f = (COSNumber)this.field.getDictionaryObject("F");
        if (f != null) {
            retval = new Integer(f.intValue());
        }
        return retval;
    }

    public void setWidgetFieldFlags(Integer f) {
        COSInteger value = null;
        if (f != null) {
            value = new COSInteger(f);
        }
        this.field.setItem("F", value);
    }

    public void setWidgetFieldFlags(int f) {
        this.field.setItem("F", (COSBase)new COSInteger(f));
    }

    public Integer getSetWidgetFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject("SetF");
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setSetWidgetFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = new COSInteger(ff);
        }
        this.field.setItem("SetF", value);
    }

    public void setSetWidgetFieldFlags(int ff) {
        this.field.setItem("SetF", (COSBase)new COSInteger(ff));
    }

    public Integer getClearWidgetFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject("ClrF");
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setClearWidgetFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = new COSInteger(ff);
        }
        this.field.setItem("ClrF", value);
    }

    public void setClearWidgetFieldFlags(int ff) {
        this.field.setItem("ClrF", (COSBase)new COSInteger(ff));
    }

    public PDAppearanceDictionary getAppearanceDictionary() {
        PDAppearanceDictionary retval = null;
        COSDictionary dict = (COSDictionary)this.field.getDictionaryObject("AP");
        if (dict != null) {
            retval = new PDAppearanceDictionary(dict);
        }
        return retval;
    }

    public void setAppearanceDictionary(PDAppearanceDictionary ap) {
        this.field.setItem("AP", (COSObjectable)ap);
    }

    public FDFNamedPageReference getAppearanceStreamReference() {
        FDFNamedPageReference retval = null;
        COSDictionary ref = (COSDictionary)this.field.getDictionaryObject("APRef");
        if (ref != null) {
            retval = new FDFNamedPageReference(ref);
        }
        return retval;
    }

    public void setAppearanceStreamReference(FDFNamedPageReference ref) {
        this.field.setItem("APRef", (COSObjectable)ref);
    }

    public FDFIconFit getIconFit() {
        FDFIconFit retval = null;
        COSDictionary dic = (COSDictionary)this.field.getDictionaryObject("IF");
        if (dic != null) {
            retval = new FDFIconFit(dic);
        }
        return retval;
    }

    public void setIconFit(FDFIconFit fit) {
        this.field.setItem("IF", (COSObjectable)fit);
    }

    public List getOptions() {
        COSArrayList retval = null;
        COSArray array = (COSArray)this.field.getDictionaryObject("Opt");
        if (array != null) {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (int i = 0; i < array.size(); ++i) {
                COSBase next = array.getObject(i);
                if (next instanceof COSString) {
                    objects.add(((COSString)next).getString());
                    continue;
                }
                COSArray value = (COSArray)next;
                objects.add(new FDFOptionElement(value));
            }
            retval = new COSArrayList(objects, array);
        }
        return retval;
    }

    public void setOptions(List options) {
        COSArray value = COSArrayList.converterToCOSArray(options);
        this.field.setItem("Opt", (COSBase)value);
    }

    public PDAction getAction() {
        return PDActionFactory.createAction((COSDictionary)this.field.getDictionaryObject("A"));
    }

    public void setAction(PDAction a) {
        this.field.setItem("A", (COSObjectable)a);
    }

    public PDAdditionalActions getAdditionalActions() {
        PDAdditionalActions retval = null;
        COSDictionary dict = (COSDictionary)this.field.getDictionaryObject("AA");
        if (dict != null) {
            retval = new PDAdditionalActions(dict);
        }
        return retval;
    }

    public void setAdditionalActions(PDAdditionalActions aa) {
        this.field.setItem("AA", (COSObjectable)aa);
    }

    public PDTextStream getRichText() {
        COSBase rv = this.field.getDictionaryObject("RV");
        return PDTextStream.createTextStream(rv);
    }

    public void setRichText(PDTextStream rv) {
        this.field.setItem("RV", (COSObjectable)rv);
    }
}

