/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.ttf;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.ttf.CMAPTable;
import org.pdfbox.ttf.GlyphTable;
import org.pdfbox.ttf.HeaderTable;
import org.pdfbox.ttf.HorizontalHeaderTable;
import org.pdfbox.ttf.HorizontalMetricsTable;
import org.pdfbox.ttf.IndexToLocationTable;
import org.pdfbox.ttf.MaximumProfileTable;
import org.pdfbox.ttf.NamingTable;
import org.pdfbox.ttf.OS2WindowsMetricsTable;
import org.pdfbox.ttf.PostScriptTable;
import org.pdfbox.ttf.TTFDataStream;
import org.pdfbox.ttf.TTFTable;

public class TrueTypeFont {
    private float version;
    private Map tables = new HashMap();
    private TTFDataStream data;

    TrueTypeFont(TTFDataStream fontData) {
        this.data = fontData;
    }

    public void close() throws IOException {
        this.data.close();
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float versionValue) {
        this.version = versionValue;
    }

    public void addTable(TTFTable table) {
        this.tables.put(table.getTag(), table);
    }

    public Collection getTables() {
        return this.tables.values();
    }

    public NamingTable getNaming() {
        return (NamingTable)this.tables.get("name");
    }

    public PostScriptTable getPostScript() {
        return (PostScriptTable)this.tables.get("post");
    }

    public OS2WindowsMetricsTable getOS2Windows() {
        return (OS2WindowsMetricsTable)this.tables.get("OS/2");
    }

    public MaximumProfileTable getMaximumProfile() {
        return (MaximumProfileTable)this.tables.get("maxp");
    }

    public HeaderTable getHeader() {
        return (HeaderTable)this.tables.get("head");
    }

    public HorizontalHeaderTable getHorizontalHeader() {
        return (HorizontalHeaderTable)this.tables.get("hhea");
    }

    public HorizontalMetricsTable getHorizontalMetrics() {
        return (HorizontalMetricsTable)this.tables.get("hmtx");
    }

    public IndexToLocationTable getIndexToLocation() {
        return (IndexToLocationTable)this.tables.get("loca");
    }

    public GlyphTable getGlyph() {
        return (GlyphTable)this.tables.get("glyf");
    }

    public CMAPTable getCMAP() {
        return (CMAPTable)this.tables.get("cmap");
    }
}

