; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               FreeSpace
; -----------------------------------------------------------------------------
; Prefix:             fs_
; Version:            0.5
; Date:               2005-10-10
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_FreeSpace:
   Prefix = fs
   %Prefix%_ScriptName    = FreeSpace
   %Prefix%_ScriptVersion = 0.5

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %fs_ScriptName% - Zeigt den freien Speicherplatz
      Description                   = Zeigt in der Titelleiste des aktiven Explorer-Fensters den freien Speicherplatz an.
      lng_fs_FreeSpace              = Freier Speicherplatz
      lng_fs_DisplayGB              = Anzeige in Gigabyte
      lng_fs_DecimalPoint           = ,
      lng_fs_RefreshOnlyInExplorer  = Anzeige nur aktualisieren, wenn ein Explorer-Fenster aktiv ist (verhindert z.B. Mausruckler in Photoshop)
   }
   else        ; = other languages (english)
   {
      MenuName                      = %fs_ScriptName% - shows free drive-space
      Description                   = Shows the free drive-space in the title-bar of explorer-windows.
      lng_fs_FreeSpace              = free space
      lng_fs_DisplayGB              = show free space in gigabyte
      lng_fs_DecimalPoint           = .
      lng_fs_RefreshOnlyInExplorer  = refresh value only if an explorer-window is active (eg. prevents mouse-lag in Photoshop)
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, fs_DisplayGB, %ConfigFile%, %fs_ScriptName%, DisplayGigaByte, 0
   IniRead, fs_RefreshOnlyInExplorer, %ConfigFile%, %fs_ScriptName%, RefreshOnlyInExplorer, 0

   RegRead, fs_FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPath
   RegRead, fs_FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPathAddress

   RegRead, fs_RegDesktop, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders,Desktop
   StringReplace, fs_RegDesktop, fs_RegDesktop, `%USERPROFILE`%\

   RegRead, fs_RegPersonal, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders,Personal
   RegRead, fs_MyDocs, HKEY_CURRENT_USER,Software\Microsoft\Office\11.0\Common\General,MyDocuments
   StringReplace, fs_RegPersonal, fs_RegPersonal, `%USERPROFILE`%, %USERPROFILE%
   StringReplace, fs_RegPersonal, fs_RegPersonal, `%USERNAME`%, %USERNAME%
   SplitPath, fs_RegPersonal, fs_RegDir
Return

SettingsGui_FreeSpace:
   Gui, Add, Checkbox, gsub_CheckIfSettingsChanged XS+10 Y+5 vfs_DisplayGB Checked%fs_DisplayGB%, %lng_fs_DisplayGB%
   Gui, Add, Checkbox, gsub_CheckIfSettingsChanged XS+10 Y+5 vfs_RefreshOnlyInExplorer Checked%fs_RefreshOnlyInExplorer%, %lng_fs_RefreshOnlyInExplorer%
Return

SaveSettings_FreeSpace:
   IniWrite, %fs_DisplayGB%, %ConfigFile%, %fs_ScriptName%, DisplayGigaByte
   IniWrite, %fs_RefreshOnlyInExplorer%, %ConfigFile%, %fs_ScriptName%, RefreshOnlyInExplorer
Return

CancelSettings_FreeSpace:
Return

DoEnable_FreeSpace:
   SetTimer, fs_tim_FreeSpace, 200
Return

DoDisable_FreeSpace:
  SetTimer, fs_tim_FreeSpace, Off
Return

DefaultSettings_FreeSpace:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------


; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------

fs_tim_FreeSpace:
   WinGet, fs_WinIDs, List
   WinGetClass, fs_actClass, A
   If ( fs_RefreshOnlyInExplorer = 1 AND ( fs_actClass <> "CabinetWClass" AND fs_actClass <> "ExploreWClass" AND fs_actClass <> "Progman" AND fs_actClass <> "Shell_TrayWnd" ) )
      Return

   WinGet, fs_MinMax, MinMax, A
   If fs_MinMax = 1
      Return

   Loop, %fs_WinIDs%
   {
      fs_WinID := fs_WinIDs%A_Index%
      WinGetClass, fs_WinClass, ahk_id %fs_WinID%

      If fs_WinClass in CabinetWClass,ExploreWClass
      {

         If (fs_FullPath = 0 AND fs_FullPathAddress = 0)
            Return

         ; Aktuellen Pfad anhand der Adressleiste ermitteln
         If fs_FullPath = 1
            WinGetTitle, fs_Path, ahk_id %fs_WinID%

         If fs_FullPathAddress = 1
            ControlGetText, fs_Path, Edit1, ahk_id %fs_WinID%

         ; Prfe, ob 'Desktop' im Explorer ausgewhlt wurde
         If fs_RegDesktop = %fs_Path%
            fs_Path = %USERPROFILE%\%fs_RegDesktop%

         ; Prfe, ob 'Eigene Dateien' im Explorer ausgewhlt wurde
         If fs_Path in Eigene Dateien,My Documents,mijn documenten,%fs_MyDocs%,%fs_RegDir%
            fs_Path = %fs_RegPersonal%

         ifNotExist, %fs_Path%
            continue

         WinGetTitle, fs_Title, ahk_id %fs_WinID%
         fs_WinTitle := fs_Title
         fs_Path := fs_func_GetDrive(fs_Path, "RealPath")
         DriveSpaceFree, fs_FreeSpace, %fs_Path%
         StringReplace, fs_Path, fs_Path, :\,

         StringGetPos, fs_Len, fs_WinTitle, %A_Space%(%lng_fs_FreeSpace%
         if fs_Len > 1
               StringLeft, fs_WinTitle, fs_WinTitle, %fs_Len%

         SetFormat, float, 0.2

         if fs_DisplayGB = 1
         {
            fs_FreeSpace /= 1024.0
            StringReplace, fs_FreeSpace, fs_FreeSpace, . , %lng_fs_DecimalPoint%
            fs_NewTitle = %fs_WinTitle% (%lng_fs_FreeSpace% %fs_Path%: %fs_FreeSpace% GB)
         }
         Else
            fs_NewTitle = %fs_WinTitle% (%lng_fs_FreeSpace% %fs_Path%: %fs_FreeSpace% MB)


         If (fs_FreeSpace = fs_lastFreeSpace%fs_WinID% AND fs_Title = fs_LastTitle%fs_WinID%)
            continue

         fs_lastFreeSpace%fs_WinID% = %fs_FreeSpace%

         WinSetTitle, ahk_id %fs_WinID%,,%fs_NewTitle%

         fs_LastTitle%fs_WinID% = %fs_NewTitle%
      }
   }
Return

fs_func_GetDrive( Path, RealPath = "" )
{
   StringLeft, Drive, Path, 1
   If Drive = \
   {
      StringSplit, Path, Path, \
      If RealPath = RealPath
         Drive = \\%Path3%\%Path4%
      Else
         Drive := func_StrTranslate(Path3 "#" Path4, "-+ !&()'", "______[]_")
   }
   Else If RealPath = RealPath
      Drive = %Drive%:\

   Return %Drive%
}

