; -----------------------------------------------------------------------------
; #############################################################################
; -----------------------------------------------------------------------------
; Name:               NewFolder
; -----------------------------------------------------------------------------
; Prefix:             nf_
; Version:            0.7
; Date:               2005-09-14
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

; Initialisierungsroutine, welche beim Start von ac'tivAid aufgerufen wird.
init_NewFolder:
   SetBatchLines, 2000

   ; * Das verwendete Prfix
   Prefix = nf
   ; * Der Name der Erweiterung ohne Leerzeichen und Sonderzeichen
   %Prefix%_ScriptName    = NewFolder
   ; * Die Version der Erweiterung
   %Prefix%_ScriptVersion = 0.7

   CustomHotkey_NewFolder = 1          ; automatisches benutzerdefinierbares Tastaturkrzel? (1 = ja)
   Hotkey_NewFolder       = ^n         ; Standard-Hotkey
   HotkeyPrefix_NewFolder = ~          ; Prfix, welches vor immer vor dem Tastaturkrzel gesetzt wird
                                       ; in diesem Fall sorgt es dafr, dass das Tastaturkrzel durchgeschleift wird.
   HideSettings = 0                    ; Wenn 1, dann bekommt die Erweiterung keinen Eintrag im Konfigurationsdialog

   ; Sprachabhngige Variablen
   If Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      ; Name des Meneintrags im Tray-Men
      MenuName                      = %nf_ScriptName% - Neuer Ordner per Tastaturkrzel
      ; Beschreibung fr den Erweiterungsmanager und den Konfigurationsdialog
      Description                   = Im Explorer lassen sich direkt mit einem definierten Tastaturkrzel neue Ordner anlegen. ber ein weiteres Krzel kann man einen neuen Ordner anlegen in dem automatisch Unterordner erstellt werden.
      nf_FolderName                 = Neuer Ordner
      lng_nf_ErrorCreating          = Neuer Ordner kann nicht erstellt werden!
      lng_nf_ErrorCreatingDetail    = In den Ordneroptionen muss eingestellt werden, `ndass im Fenstertitel oder in der Adressleiste der vollstndige Pfad angezeigt wird.
      lng_nf_SpecialCreate          = Tastaturkrzel fr neuen Ordner `nmit vordefinierten Unterordnern
      lng_nf_SpecialFolders         = Vordefinierte Unterordner`n(ein Ordner je Zeile)
      lng_nf_DefaultFolders         = Bilder|Entwrfe
   }
   else        ; = other languages (english)
   {
      MenuName                      = %nf_ScriptName% - new folder with hotkey
      Description                   = Extends the windows explorer with a hotkey for creating a new folder. A second hotkey can be used to create a folder with predefined sub-folders.
      nf_FolderName                 = new folder
      lng_nf_ErrorCreating          = can't create new folder!
      lng_nf_ErrorCreatingDetail    = Please configure windows explorer to show the `nfull path either in the window-title or the address-bar.
      lng_nf_SpecialCreate          = Hotkey for a new folder with`npredefined sub-folders
      lng_nf_SpecialFolders         = predefined folders`n(one folder per line)
      lng_nf_DefaultFolders         = images|draft
   }

   ; zustzliches Hotkey aus der INI-Datei einlesen
   ; Syntax: HotkeyRead ( Name des Tastaturkrzels, INI-Datei, Sektion, INI-Variable, Subroutine des Tastaturkrzels, Standard-Krzel)
   func_HotkeyRead( "nf_SpecialCreate", ConfigFile , nf_ScriptName, "SpecialHotkey", "nf_main_SpecialNewFolder", "~^+n" )

   ; Die zustzlichen Unterordner aus der INI-Datei auslesen
   IniRead, nf_SpecialFolders, %ConfigFile%, NewFolder, SpecialFolders, %lng_nf_DefaultFolders%
Return

; Die folgende Routine enthlt alle Befehle, welche dazu ntig sind den Konfigurationsdialog zu ergnzen
; Das erste GUI-Element sollte immer mit "XS+10 Y+5" positioniert werden, wobei der Y-Wert ggf.
; auch angepasster werden kann.
SettingsGui_NewFolder:
   ; Schalftflche fr Abfrage eines Tastaturkrzels hinzufgen
   func_HotkeyAddGuiControl( lng_nf_SpecialCreate, "nf_SpecialCreate", "xs+10 y+10 w160" )
   Gui, Add, Text, xs+10 y+20 w155, %lng_nf_SpecialFolders%:
   StringReplace, nf_SpecialFolders, nf_SpecialFolders, |, `n, a
   Gui, Add, Edit,gsub_CheckIfSettingsChanged x+10 R10 W300 vnf_SpecialFolders, %nf_SpecialFolders%
Return

; wird aufgerufen, wenn im Konfigurationsdialog OK oder bernehmen angeklickt wird
SaveSettings_NewFolder:
   ; Syntax: HotkeyWrite ( Name des Tastaturkrzels, INI-Datei, Sektion, INI-Variable [, Subroutine des Tastaturkrzels] )
   func_HotkeyWrite( "nf_SpecialCreate", ConfigFile , nf_ScriptName, "SpecialHotkey" )
   StringReplace, nf_SpecialFolders, nf_SpecialFolders, `n, |, a
   StringReplace, nf_SpecialFolders, nf_SpecialFolders, ||, |, a
   IniWrite, %nf_SpecialFolders%, %ConfigFile%, NewFolder, SpecialFolders
Return

; wird beim Abbrechen des Konfigurationsdialogs aufgerufen
CancelSettings_NewFolder:
   StringReplace, nf_SpecialFolders, nf_SpecialFolders, `n, |, a
Return

; wird beim Aktivieren der Erweiterung aufgerufen
DoEnable_NewFolder:
   func_HotkeyEnable("nf_SpecialCreate")
Return

; wird beim Deaktivieren der Erweiterung und auch vor dem Speichern der Einstellungen aufgerufen
DoDisable_NewFolder:
   func_HotkeyDisable("nf_SpecialCreate")
Return

; wird aufgerufen, wenn der Anwender die Erweiterung auf die Standard-Einstellungen zurcksetzt
DefaultSettings_NewFolder:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

; Unterroutine fr das automatische Tastaturkrzel
sub_Hotkey_Newfolder: ; nf
   Gosub, nf_main_NewFolder
Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================nf==
; -----------------------------------------------------------------------------

; Neuer Ordner mit vordefinierten Unterordnern
nf_main_SpecialNewFolder:
   Gosub, nf_main_NewFolder
   If nf_SpecialFolders =
      Return
   IfNotExist, %nf_CurrentExplorerDirectory%\%nf_FolderName%%nf_FolderNameAdd%
      Return

   Loop, Parse, nf_SpecialFolders, |
   {
      If A_LoopField <>
         FileCreateDir, %nf_CurrentExplorerDirectory%\%nf_FolderName%%nf_FolderNameAdd%\%A_LoopField%
   }
Return

; Neuer Ordner in einem Explorer-Fenster
nf_main_NewFolder:
   WinGet, nf_ActiveID, ID, A                        ; ID des aktiven Fensters
   WinGetClass, nf_ActiveClass, A                    ; Klasse des aktiven Fensters
   nf_FolderNameAdd =
   If nf_ActiveClass in ExploreWClass,CabinetWClass,Progman,WorkerW  ; Wenn Explorer-Fenster ...
   {
      RegRead, nf_FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPath
      RegRead, nf_FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPathAddress

      ; Aktuellen Pfad anhand der Adressleiste ermitteln
      If nf_FullPath = 1
         WinGetTitle, nf_CurrentExplorerDirectory, ahk_id %nf_ActiveID%

      If nf_FullPathAddress = 1
         ControlGetText, nf_CurrentExplorerDirectory, Edit1, ahk_id %nf_ActiveID%

      If (nf_ActiveClass = "Progman" OR nf_ActiveClass = "WorkerW")
         nf_CurrentExplorerDirectory = %A_Desktop%

      Sleep,200

      If nf_CurrentExplorerDirectory =
      {
         MsgBox, 16, %lng_nf_ErrorCreating%, %lng_nf_ErrorCreatingDetail%
         Return
      }

      ; Prfe, ob 'Desktop' im Explorer ausgewhlt wurde
      RegRead, nf_Reg, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders,Desktop
      StringReplace, nf_Reg, nf_Reg, `%USERPROFILE`%\
      If nf_Reg = %nf_CurrentExplorerDirectory%
         nf_CurrentExplorerDirectory = %USERPROFILE%\%nf_Reg%

      ; Prfe, ob 'Eigene Dateien' im Explorer ausgewhlt wurde
      RegRead, nf_Reg, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders,Personal
      RegRead, nf_MyDocs, HKEY_CURRENT_USER,Software\Microsoft\Office\11.0\Common\General,MyDocuments
      StringReplace, nf_Reg, nf_Reg, `%USERPROFILE`%, %USERPROFILE%
      StringReplace, nf_Reg, nf_Reg, `%USERNAME`%, %USERNAME%
      SplitPath, nf_Reg, nf_RegDir
      If nf_CurrentExplorerDirectory in Eigene Dateien,My Documents,mijn documenten,%nf_MyDocs%,%nf_RegDir%
         nf_CurrentExplorerDirectory = %nf_Reg%

      ifNotExist, %nf_CurrentExplorerDirectory%
         Return

      IfExist, %nf_CurrentExplorerDirectory%\%nf_FolderName%%nf_FolderNameAdd%
      {
         Loop
         {
            nf_FolderNameAdd := " " A_Index+1
            IfNotExist, %nf_CurrentExplorerDirectory%\%nf_FolderName%%nf_FolderNameAdd%
               break
         }
      }

      ; Neuen Ordner anlegen
      FileCreateDir, %nf_CurrentExplorerDirectory%\%nf_FolderName%%nf_FolderNameAdd%

      ; Wenn kein Fehler
      If ErrorLevel = 0
      {
         ; Wenn Ordnerleiste aktiv, zum Ordnerinhalt wechseln
         ControlGetFocus, nf_Control, A
         If nf_Control = SysTreeView321
            ControlFocus, SysListView321, A

         ; 20 mal prfen, ob Ordner exisitert (dauert bei Netzlaufwerken etwas)
         Loop,20
         {
            IfExist, %nf_CurrentExplorerDirectory%\%nf_FolderName%%nf_FolderNameAdd%   ; Prfen ob existiert
            {
               Send,{ESC}{F5}                                         ; Explorer-Ansicht aktualisieren
               Send,%nf_FolderName%%nf_FolderNameAdd%{F2}                          ; Ordner auswhlen (durch Eingabe des Namens)
               Break                                             ; Schleife verlassen
            }
            Sleep,100                                            ; kleine Pause
         }
      }
   }

   If nf_ActiveClass = #32770                            ; Ist Dateidialog?
   {
      PostMessage, 0x111, 40962                          ; Direkten Befehl fr neuer Ordner senden
   }
   If nf_ActiveClass contains bosa_sdm_                  ; Ist Office-Dateidialog?
   {
      Send, !5                                           ; Krzel fr neuer Ordner senden
   }
Return

