; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               UserHotkeys
; -----------------------------------------------------------------------------
; Prefix:             uh_
; Version:            0.2
; Date:               2005-10-10
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ==========================================================
; -----------------------------------------------------------------------------

init_UserHotkeys:
   Prefix = uh
   %Prefix%_ScriptName     = UserHotkeys
   %Prefix%_ScriptVersion  = 0.2
   AddSettings_UserHotkeys = 1

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName                      = %uh_ScriptName% - Benutzerdefinierte Tastaturkrzel
      Description                   = Frei belegbare Tastaturkrzel. Sie lassen sich mit Programmen, Skripten, Verzeichnissen, URLs und einigen Spezialbefehlen, wie die Ausgabe von Text, belegen.
      lng_uh_FileTypes              = *.exe; *.cmd; *.bat; *.ahk; *.vbs; *.hlp; *.chm; *.txt; *.htm; *.html; *.txt; *.doc; *.xls; *.ppt; *.sxw; *.sxc
      lng_uh_Edit                   = Tastaturkrzel bearbeiten
      lng_uh_Add                    = Tastaturkrzel hinzufgen
      lng_uh_CMEdit                 = Bearbeiten`t(Doppelklick/Leertaste)
      lng_uh_CMAdd                  = Hinzufgen`t(Einfg)
      lng_uh_CMDelete               = Lschen`t(Entf)
      lng_uh_Legend                 = Folgende Spezialbefehle sind mglich:
   }
   else        ; = other languages (english)
   {
      MenuName                      = %uh_ScriptName% - user-definable hotkeys
      Description                   = Assign hotkeys to programs, scripts, folders, urls and some special commands, like the typing text or getting the color under the mouse.
      lng_uh_FileTypes              = programs/scripts (*.exe; *.cmd; *.bat; *.ahk; *.vbs)
      lng_uh_Edit                   = edit hotkey
      lng_uh_Add                    = add hotkey
      lng_uh_CMEdit                 = edit`t(Double-click/Space)
      lng_uh_CMAdd                  = add`t(Ins)
      lng_uh_CMDelete               = delete`t(Del)
      lng_uh_Legend                 = The following special commands are available:
   }
   If CustomLanguage <>
      gosub, CustomLanguage

   IniRead, uh_NumHotkeys, %ConfigFile%, %uh_ScriptName%, NumberOfHotkeys, 15
   Loop, %uh_NumHotkeys%
   {
      IniRead, uh_Path%A_Index%, %ConfigFile%, %uh_ScriptName%, Path%A_Index%
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 1)
      {
         uh_Path%A_Index% = 320MPH Old.ahk
         uh_DefHotkey = ^+Space
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 2)
      {
         uh_Path%A_Index% = <SingleInstanceClose>regedit.exe
         uh_DefHotkey = #+F12
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 3)
      {
         uh_Path%A_Index% = Control
         uh_DefHotkey = #c
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 4)
      {
         uh_Path%A_Index% = Properties C:\
         uh_DefHotkey = #^!c
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 5)
      {
         uh_Path%A_Index% = <SingleInstanceClose><AOT>calc.exe
         uh_DefHotkey = ##
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 6)
      {
         uh_Path%A_Index% = <send>
         uh_DefHotkey = !-
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 7)
      {
         uh_Path%A_Index% = <send>
         uh_DefHotkey = ^!-
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 8)
      {
         uh_Path%A_Index% = <send>
         uh_DefHotkey = !+-
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 9)
      {
         uh_Path%A_Index% = <send>
         uh_DefHotkey = ^!
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 10)
      {
         uh_Path%A_Index% = <send><a href="`%Selection`%"></a>{Left 4}
         uh_DefHotkey = #!l
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 11)
      {
         uh_Path%A_Index% = <send>`%A_DD`%.`%A_MM`%.`%A_YYYY`% - `%A_Hour`%:`%A_Min`%
         uh_DefHotkey = #+d
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 12)
      {
         uh_Path%A_Index% = <getControl>
         uh_DefHotkey = #^
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 13)
      {
         uh_Path%A_Index% = <getColor><RGB>
         uh_DefHotkey = #.
      }
      if (uh_Path%A_Index% = "ERROR" AND A_Index = 14)
      {
         uh_Path%A_Index% = <getControlText>
         uh_DefHotkey = #^c
      }
      if uh_Path%A_Index% = ERROR
         uh_Path%A_Index% =

      If uh_Path%A_Index% <> ""
         func_HotkeyRead( "uh_Hotkey" A_Index, ConfigFile, uh_ScriptName, "Hotkey" A_Index, "sub_Hotkey_UserHotkey", uh_DefHotkey )
      uh_DefHotkey =
   }

   uh_NumHotkeys_new = %uh_NumHotkeys%
   uh_SpecialCommands = <Send>,<SendRaw>,<Reload>,<ListHotkeys>,<ListLines>,<ListVars>,<ExitApp>,<KeyHistory>,<ChDir>,<getControl>,<getColor>,<getControlText>,<SingleInstance>,<SingleInstanceClose>,<AOT>
   StringReplace, uh_LegendItems, uh_SpecialCommands, `, , %A_Space%, a
   uh_LegendItems= %uh_LegendItems% `%Selection`%
Return

SettingsGui_UserHotkeys:
   Gui, Add, ListView, Count%uh_NumHotkeys% AltSubmit -Multi -Hdr -LV0x10 Grid xs+10 y+5 r18 w550 guh_sub_ListView, .|%lng_Hotkey%|%lng_Command%

   GuiControl, -Redraw, uh_sub_ListView
   Loop, %uh_NumHotkeys%
   {
      uh_Path%A_Index%_new := uh_Path%A_Index%
      LV_Add("", Hotkey_uh_Hotkey%A_Index%_new, func_HotkeyDecompose(Hotkey_uh_Hotkey%A_Index%_new,0), uh_Path%A_Index%_new)
   }
   LV_ModifyCol(1,0)
   LV_ModifyCol(2,"AutoHdr")
   LV_ModifyCol(3,"AutoHdr")
   LV_Modify(1, "Focus")
   GuiControl, +Redraw, uh_sub_ListView

   uh_EditTitle = %lng_uh_Edit%
Return

uh_sub_ListView:
   ;tooltip, % A_GuiEvent " " A_EventInfo " " uh_RowText " : " LV_GetNext()
   If MainGuiVisible = 2
      func_SettingsChanged( "UserHotkeys" )
   uh_LVrow := LV_GetNext()
   LV_GetText(uh_RowText, uh_LVrow, 3)
   If (A_GuiEvent = "DoubleClick" AND uh_LVrow = 0)
      Goto, uh_sub_AddHotkey
   If (A_GuiEvent = "DoubleClick" OR ( A_GuiEvent = "K" AND A_EventInfo = 32 ))
      Goto, uh_sub_EditHotkey
   If (A_GuiEvent = "RightClick" OR ( A_GuiEvent = "K" AND A_EventInfo = 93 ))
      Goto, uh_sub_ContextMenu
   If ( A_GuiEvent = "K" AND A_EventInfo = 46 )
      Goto, uh_sub_DelHotkey
   If ( A_GuiEvent = "K" AND A_EventInfo = 45 )
      Goto, uh_sub_AddHotkey
Return

uh_sub_DelHotkey:
   func_HotkeyDisable( "uh_Hotkey" uh_LVrow )
   LV_Delete( uh_LVrow )
   uh_NumHotkeys_new--
   func_SettingsChanged( "UserHotkeys" )
Return

uh_sub_AddHotkey:
   LV_Add("Select", "","","")
   uh_LVrow := LV_GetNext()
   uh_EditTitle = %lng_uh_Add%
   Hotkey_uh_Hotkey%uh_LVrow%_Sub = sub_Hotkey_UserHotkey
   Gosub, uh_sub_EditHotkey
   uh_NumHotkeys_new++
   func_SettingsChanged( "UserHotkeys" )
Return

uh_sub_EditHotkey:
   Gui, 3:Default
   Gui, 3:+Owner
   Gui, 1:+Disabled
   Gui, -MinimizeBox -MaximizeBox +AlwaysOnTop
   uh_Hotkey_org := Hotkey_uh_Hotkey%uh_LVrow%
   Hotkey_uh_Hotkey%uh_LVrow% := Hotkey_uh_Hotkey%uh_LVrow%_new
   func_HotkeyAddGuiControl( lng_Hotkey, "uh_Hotkey" uh_LVrow, "y+10 w80" )
   Gui, Add, Text, x10 y+7 w80, %lng_Command%:
   Gui, Add, Edit, x+5 yp-3 W460 h20 R3 -WantReturn vuh_Path%uh_LVrow%_new, % uh_Path%uh_LVrow%_new
   Gui, Add, Button, -Wrap x+5 h20 W21 vuh_Button%uh_LVrow% guh_sub_Browse, ...
   Gui, Add, Text, Readonly x95 y+30, %lng_uh_Legend%
   Gui, Add, Edit, +0x100 Readonly R3 x95 W460 y+2, %uh_LegendItems%
   Gui, Add, Button, -Wrap X+5 h27 w18 vCH_UserHotkeys gsub_ContextHelp, ?
   Gui, Add, Button, -Wrap y+30 x190 w100 Default guh_sub_OK, &OK
   Gui, Add, Button, -Wrap x+10 w100 g3GuiClose, %lng_Cancel%
   Gui, Show, w600 AutoSize, %uh_EditTitle%
Return

uh_sub_OK:
   Gui, 1:-Disabled
   Gui, Submit
   Gui, Destroy
   Gui, 1:Default
   LV_Modify( uh_LVrow,"" , Hotkey_uh_Hotkey%uh_LVrow%_new, func_HotkeyDecompose(Hotkey_uh_Hotkey%uh_LVrow%_new,0), uh_Path%uh_LVrow%_new )
   LV_ModifyCol(2,"AutoHdr")
   LV_ModifyCol(3,"AutoHdr")
   uh_EditTitle = %lng_uh_Edit%
   func_SettingsChanged( "UserHotkeys" )
   Hotkey_uh_Hotkey%uh_LVrow% := uh_Hotkey_org
Return

3GuiClose:
3GuiEscape:
   Gui, 1:-Disabled
   Gui, Destroy
   Gui, 1:Default
   Hotkey_uh_Hotkey%uh_LVrow%_new := Hotkey_uh_Hotkey%uh_LVrow%
   Hotkey_uh_Hotkey%uh_LVrow% := uh_Hotkey_org
   If uh_EditTitle = %lng_uh_Add%
   {
      LV_Delete( uh_LVrow )
      uh_NumHotkeys_new--
   }
   uh_EditTitle = %lng_uh_Edit%
Return

uh_sub_ContextMenu:
   Menu, uh_ContextMenu, Add, &%lng_uh_CMEdit% , uh_sub_EditHotkey
   Menu, uh_ContextMenu, Add, &%lng_uh_CMAdd% , uh_sub_AddHotkey
   Menu, uh_ContextMenu, Add, &%lng_uh_CMDelete% , uh_sub_DelHotkey
   Menu, uh_ContextMenu, Show
Return

uh_sub_Browse:
   Gui +OwnDialogs
   StringReplace, uh_Control, A_GuiControl,   GuiControlGet, uh_Control,,uh_Path%uh_Control%

   GuiControlGet, uh_DefaultPath,3:,uh_Path%uh_LVrow%_new

   if uh_DefaultPath =
      uh_DefaultPath = extensions\UserHotkeys-scripts\

   StringGetPos, uh_PathBeginVars, uh_DefaultPath, %A_Space%`%
   If uh_PathBeginVars > 0
      StringLeft, uh_DefaultPath, uh_DefaultPath, %uh_PathBeginVars%

   IfNotExist, %uh_DefaultPath%
      uh_DefaultPath = extensions\UserHotkeys-scripts\

   FileSelectFile, uh_Control,, %uh_DefaultPath%, %uh_ScriptName%, %lng_uh_FileTypes%
   If Errorlevel = 0
   {
      StringReplace, uh_Control, uh_Control, %A_Scriptdir%\,
      StringReplace, uh_Control, uh_Control, extensions\userhotkeys-scripts\,
      GuiControl,3:,uh_Path%uh_LVrow%_new, %uh_Control%
   }
Return

SaveSettings_UserHotkeys:
   IniDelete, %ConfigFile%, %uh_ScriptName%

   uh_NumHotkeys = %uh_NumHotkeys_new%
   IniWrite, %uh_NumHotkeys%, %ConfigFile%, %uh_ScriptName%, NumberOfHotkeys
   Loop, %uh_NumHotkeys%
   {
      uh_Path%A_Index% := uh_Path%A_Index%_new
      func_HotkeyWrite( "uh_Hotkey" A_Index, ConfigFile, uh_ScriptName, "Hotkey" A_Index, "sub_Hotkey_UserHotkey" )
      IniWrite, % uh_Path%A_Index%, %ConfigFile%, %uh_ScriptName%, Path%A_Index%
   }
Return

AddSettings_UserHotkeys:
   If AddFreshSettings = 1
   {
      uh_NumHotkeys_new = 0
      LV_Delete()
   }
   Else
   {
      uh_NumHotkeys_new2 = 0
      Loop, % LV_GetCount()
      {
         LV_GetText(uh_Col2, A_Index, 2)
         LV_GetText(uh_Col3, A_Index, 3)
         OutputDebug, % A_Index ":  " uh_Col2 " ... " uh_Col3
         If (uh_Col2 = "" AND uh_Col3 = "")
            LV_Delete(A_Index)
         Else
            uh_NumHotkeys_new2++
      }
      uh_NumHotkeys_new = %uh_NumHotkeys_new2%
   }

   IniRead, uh_NumHotkeysTmp, %AddFile%, %uh_ScriptName%, NumberOfHotkeys
   Loop, %uh_NumHotkeysTmp%
   {
      IniRead, uh_PathTmp, %AddFile%, %uh_ScriptName%, Path%A_Index%
      IniRead, uh_HotkeyTmp, %AddFile%, %uh_ScriptName%, Hotkey%A_Index%
      uh_Duplicates = 0
      Loop, %uh_NumHotkeys_new%
      {
         If (uh_HotkeyTmp = Hotkey_uh_Hotkey%A_Index%_new)
         {
            uh_Duplicates++
            break
         }
      }
      If uh_Duplicates = 0
      {
         uh_NumHotkeys_new++
         Hotkey_uh_Hotkey%uh_NumHotkeys_new%_new = %uh_HotkeyTmp%
         uh_Path%uh_NumHotkeys_new%_new = %uh_PathTmp%
         LV_Add("", Hotkey_uh_Hotkey%uh_NumHotkeys_new%_new, func_HotkeyDecompose(Hotkey_uh_Hotkey%uh_NumHotkeys_new%_new,0), uh_Path%uh_NumHotkeys_new%_new)
         LV_ModifyCol(2,"AutoHdr")
         LV_ModifyCol(3,"AutoHdr")
      }
   }
Return

CancelSettings_UserHotkeys:
   Loop, %uh_NumHotkeys%
   {
      Hotkey_uh_Hotkey%A_Index%_new := Hotkey_uh_Hotkey%A_Index%
   }
Return

DoEnable_UserHotkeys:
   Loop, %uh_NumHotkeys%
   {
      func_HotkeyEnable( "uh_Hotkey" A_Index )
   }
Return

DoDisable_UserHotkeys:
   Loop, %uh_NumHotkeys%
   {
      func_HotkeyDisable( "uh_Hotkey" A_Index )
   }
Return

DefaultSettings_UserHotkeys:
Return

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

sub_Hotkey_UserHotkey:
   uh_Path := func_HotkeyGetVar("uh_Hotkey",uh_NumHotkeys,"uh_Path")
   IfInString, uh_Path, <AOT>
   {
      StringReplace, uh_Path, uh_Path, <AOT>,
      uh_AOT = 1
   }
   Else
      uh_AOT = 0

   StringGetPos, uh_PathBeginVars, uh_Path, %A_Space%`%
   StringLeft, uh_PathOnly, uh_Path, %uh_PathBeginVars%

   IfInString, uh_Path, `%Selection`%
   {
      uh_temp = %ClipboardAll%
      Clipboard =
      Send, ^c
      ClipWait, 0.5, 1

      Selection = %Clipboard%

      Clipboard = %uh_temp%
   }

   Transform, uh_Path, Deref, %uh_Path%
   If uh_PathOnly =
      uh_PathOnly = %uh_Path%
   StringGetPos, uh_PathBeginVars, uh_Path, >
   StringLeft, uh_PathTag, uh_Path, % uh_PathBeginVars + 1
   If StrLen(uh_PathTag) > 3
      StringReplace, uh_PathWithoutTag, uh_path, %uh_PathTag%,

   If uh_PathTag Not in %uh_SpecialCommands%
   {
      ifExist, extensions\userhotkeys-scripts\%uh_PathOnly%
         Run, extensions\userhotkeys-scripts\%uh_Path%,,UseErrorlevel, uh_ProcID%uh_HotkeyNumber%
      Else
         Run, %uh_Path%,,UseErrorlevel, uh_ProcID%uh_HotkeyNumber%
      IfWinNotActive, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%,,1
         WinWaitActive, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%,,1
   }
   Setkeydelay, 0
   If uh_PathTag = <send>
      Send, %uh_PathWithoutTag%
   If uh_PathTag = <sendraw>
      SendRaw, %uh_PathWithoutTag%
   If uh_PathTag = <reload>
      Reload
   If uh_PathTag = <listhotkeys>
      ListHotkeys
   If uh_PathTag = <listlines>
      ListLines
   If uh_PathTag = <listvars>
      ListVars
   If uh_PathTag = <exitapp>
      ExitApp
   If uh_PathTag = <keyhistory>
      KeyHistory
   If uh_PathTag = <getControl>
   {
      MouseGetPos, , , uh_WinID, uh_ControlClass
      Clipboard = %uh_ControlClass%
      ToolTip, %uh_ControlClass%
      Sleep, 800
      ToolTip
   }
   If uh_PathTag = <getColor>
   {
      CoordMode, Mouse, Screen
      CoordMode, Pixel, Screen
      MouseGetPos, uh_MouseX , uh_MouseY
      PixelGetColor, uh_Color, %uh_MouseX%, %uh_MouseY%, RGB
      StringTrimLeft, uh_Color, uh_Color, 2
      IfInString, uh_PathWithoutTag, <RGB>
      {
         StringReplace, uh_Color, uh_PathWithoutTag, <RGB>, %uh_Color%,a
      }
      Else
         uh_Color = %uh_PathWithoutTag%%uh_Color%
      Clipboard = %uh_Color%
      ToolTip, %uh_Color%
      Sleep, 800
      ToolTip
   }
   If uh_PathTag = <getControlText>
   {
      CoordMode, Mouse, Screen
      MouseGetPos, uh_MouseX , uh_MouseY, uh_gWin, uh_gControl
      ControlGetText, uh_getText, %uh_gControl%, ahk_id %uh_gWin%
      uh_getText = %uh_PathWithoutTag%%uh_getText%
      Clipboard = %uh_getText%
      ToolTip, %uh_getText%
      Sleep, 800
      ToolTip
   }
   If uh_PathTag = <SingleInstance>
   {
      StringReplace, uh_PathOnly,uh_PathOnly,<SingleInstance>,
      ifExist, extensions\userhotkeys-scripts\%uh_PathOnly%
         uh_Path = extensions\userhotkeys-scripts\%uh_PathWithoutTag%
      Else
         uh_Path = %uh_PathWithoutTag%

      uh_HotkeyNumber := func_HotkeyGetNumber("uh_Hotkey",uh_NumHotkeys)
      IfWinExist, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
      {
         IfWinNotActive, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
         {
            WinRestore, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
            WinActivate, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
         }
         Else
            WinMinimize, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
      }
      Else
      {
         Run, %uh_Path%,, UseErrorLevel, uh_ProcID%uh_HotkeyNumber%
         WinWaitActive, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
      }
   }
   If uh_PathTag = <SingleInstanceClose>
   {
      StringReplace, uh_PathOnly,uh_PathOnly,<SingleInstanceClose>,
      ifExist, extensions\userhotkeys-scripts\%uh_PathOnly%
         uh_Path = extensions\userhotkeys-scripts\%uh_PathWithoutTag%
      Else
         uh_Path = %uh_PathWithoutTag%

      uh_HotkeyNumber := func_HotkeyGetNumber("uh_Hotkey",uh_NumHotkeys)
      IfWinExist, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
      {
         IfWinNotActive, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
         {
            WinRestore, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
            WinActivate, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
         }
         Else
            WinClose, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
      }
      Else
      {
         Run, %uh_Path%,, UseErrorLevel, uh_ProcID%uh_HotkeyNumber%
         WinWaitActive, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
      }
   }
   If uh_PathTag = <chdir>
      func_ChangeDir(uh_PathWithoutTag,-1,0)

   If uh_AOT = 1
   {
      WinGet, uh_ExStyle, ExStyle, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
      if not (uh_ExStyle & 0x8)
      {
         WinGetTitle, uh_WinTitle, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
         WinSet, AlwaysOnTop, On, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
         IfNotInString, uh_WinTitle, /\
            uh_WinTitle = /\  %uh_WinTitle%
         WinSet, ExStyle, +0x20000, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%
         WinSetTitle, % "ahk_pid" uh_ProcID%uh_HotkeyNumber%,, %uh_WinTitle%
      }
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =============================================================
; -----------------------------------------------------------------------------


