; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               ac'tivAid
; -----------------------------------------------------------------------------
; Version:            0.9.3
; Date:               2005-06-02
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; AutoHotkey Version: 1.0.32.00
; Language:           German/Dutch (+ English GUI)
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Dies ist eine Zusammenstellung verschiedener ntzlicher AutoHotkey-Skripte,
; die einem die tgliche Arbeit am Computer erleichtern.
; Nach dem Starten befindet sich ein rotes c't-Symbol rechts in der Taskleiste.
; ber die rechte Maustaste erreicht man ein Kontextmen, mit welchem sich die
; Einzelnen Funktionen einzeln ein-/ausschalten lassen. Ac'tivAid funktioniert
; parallel zu NiftyWindows mit der einzigen Einschrnkung dass nur eines von
; beiden seine Funktionen auf die mittlere Maustaste legt. Dazu muss man
; gegenseitig die Funktion aktivieren und deaktivieren. Falls man gelegentlich
; zwischen beiden Funktionen wechseln mchte, lsst man die mittlere Maustaste
; in NiftyWindows immer aktiv und de-/aktiviert MouseClip in ac'tivAid.
; ndert man manuell Einstellungen in der zu ac'tivAid gehrenden INI-Datei,
; muss es ber das Tray-Men neu geladen werden, damit die nderungen
; angenommen werden.
; Ac'tivAid lsst sich automatisch ber das Internet aktualisieren.
; Gelegentlich sollte man also die Update-Funktion aufrufen. nderungen am
; Skript gehen dabei verloren, Einstellungen aus der INI-Datei werden aber
; nicht berschrieben.
;
; Win+Shift+ESC      - Deaktiviert alle Funktionen von ac'tivAid
; oder CapsLock+ESC
; oder Doppelklick
; auf c't-Symbol
;
; Win+Shift+#        - Fhrt eine Problembehebung aus, die 'festsitzende'
; oder CapsLock+#      Tasten lst.

; *** Nederlands **************************************************************

; ac'tivAid is een collectie handige AutoHotkey-scripts, die het dagelijkse werken
; op de computer gemakkelijker maken.
; Na het starten vind je een rood c't-icon in de taakbalk. Via de rechter muis-
; toets krijg je een contextmenu, waarmee je de afzonderlijke functies kunt in-
; en uitschakelen. ac'tivAid werkt parallel aan NiftyWindows met als enige be-
; perking dat slechts een van de twee zijn functies via de middelste muistoets
; beschikbaar kan maken. Dit moet je zelf in beide programma's instellen. Als
; je af en toe tussen de twee functies wilt wisselen, moet je de middelste muis-
; toets in NiftyWindows actief laten en MouseClip in ac'tivAid in-/uitschakelen.
; Als je handmatig instellingen wijzigt in het bij ac'tivAid horend INI-bestand,
; moet het via het tray-menu opnieuw worden geladen voordat de veranderingen actief
; worden.
; Je kunt ac'tivAid automatisch via internet updaten. Hierbij verlies je
; niet de instellingen uit het INI-bestand.
;
; Win+Shift+Esc      - Schakelt alle functies van ac'tivAid uit
; of dubbelklik op
; c't-symbool
;
; Win+Shift+#        - Lost problemen op door "vastzittende" toetsen
;                      vrij te geven

; #################################################################EndHeader###

; -----------------------------------------------------------------------------
; === Global Settings =========================================================
; -----------------------------------------------------------------------------

#HotkeyInterval 500
#singleinstance force
#Winactivateforce
DetectHiddenWindows, Off
SetTitlematchMode, 2
SetBatchLines, -1
SetWinDelay, 0
SetControlDelay, 0
;---ComfortDrag--->
Hotkey,$+ESC, off
Hotkey,$ESC, off
Hotkey,$RButton, off
Hotkey,$PgUp, off
;<---ComfortDrag---

; -----------------------------------------------------------------------------
; === Initialisation ======================================================cd==
; -----------------------------------------------------------------------------

ScriptName         = ac'tivAid
ScriptNameClean    = activAid
ScriptVersion      = 0.9.3
neededAHKversion   = 1.0.32.00

ScriptTitle        = %ScriptName% v%ScriptVersion%

ConfigFile = %ScriptName%.ini

; -----------------------------------------------------------------------------
; Hier werden alle verwendeten Funktionen eingetragen. Mit diesem Array
; wird automatisch das Tray-Men erzeugt.
; -----------------------------------------------------------------------------
Function[1] = ComfortDrag  ; cd_
Function[2] = MouseClip    ; md_
Function[3] = WebSearch    ; wr_
Function[4] = FilePaste    ; fp_
Function[5] = NewFolder    ; nf_
Function[6] = LikeDirkey   ; ld_
Function[7] = CommandLine  ; cl_

; eigene Funktionen laden (include)
#Include *i include\header.ahk

; -----------------------------------------------------------------------------

; sprachabhngige Variablen, Systemsprache wird ermittelt
IniRead, Lng, %ConfigFile%, %ScriptNameClean%, Language
If Lng = ERROR
   StringRight, Lng, A_Language, 2 ; Sprache ermitteln, wenn nicht in INI festgelegt

If Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
{
   lng_Info          = Hilfe und Informationen zu %ScriptTitle%
   lng_wrongAHK      = AutoHotkey %neededAHKversion% oder hher wird bentigt.`nBitte besorgen Sie sich die neuste Version.
   lng_ProblemSolver = Problembehebung`tWin+Shift+#
   lng_ProbSolvHidden= Alle von %ScriptName% versteckten Fenster wurden wiederhergestellt!
   lng_ProbSolvResult= Folgende Probleme wurden behoben:
   lng_ProbSolvWhy   = Beim Starten von %ScriptName% wurden nicht wiederhergestellte Fenster gefunden.
   lng_ProbSolvNoRes = Es wurden keine Probleme gefunden.`nVersuchen sie evtl. %ScriptName% mit Win+Shift+ESC zu deaktivieren.
   lng_update        = Auf Online-Updates prfen
   lng_AutoCheckUpdt = Jede Woche automatisch prfen
   lng_AskUpdate     = Soll ein automatisches Online-Update durchgefhrt werden?`nSie mssen dazu online sein und mindestens den Internet Explorer 3 installiert haben.`n`nDie aktuelle Version finden Sie auch unter: http://www.heise.de/ct/ftp/05/08/098
   lng_NeedNoUpdate  = %ScriptTitle% ist bereits auf dem aktuellsten Stand!
   lng_NeedUpdate    = Es ist eine neue Version von %ScriptName% verfgbar.`nSoll sie runtergeladen und %ScriptName% automatisch aktualisiert werden?`nEs werden dabei keine Einstellungen in den INI-Dateien gendert!`n`nAktuelle Version: %ScriptVersion%`nVerfgbare Version:
   lng_UpdateError   = Es konnte die aktuelle Version nicht ermittelt werden, prfen Sie ggf. ihre Internetverbindung.`nDamit das Update funktioniert, muss Internet Explorer 3 oder hher installiert sein.
   lng_UpdateFinished= Das Update wurde durchgefhrt. %ScriptName% wird nun neu geladen.
   lng_UpdateSuccess = Update war erfolgreich: %ScriptTitle%
   lng_UpdateFailed  = Das runtergeladene Update ist fehlerhaft, versuchen Sie es spter noch einmal.
   lng_autostart     = %ScriptName% beim Systemstart laden
   lng_reload        = %ScriptName% neu laden
   lng_deactivate    = %ScriptName% deaktivieren`tWin+Shift+ESC
   lng_Includes      = Erweiterungen (Includes)
   lng_ExtMenu       = Erweiterungen mit Meneintrag
   lng_ExtNoMenu     = Erweiterungen ohne Meneintrag
   lng_ExtOff        = Alle Erweiterungen deaktivieren
   lng_ExtOn         = Alle Erweiterungen aktivieren
   lng_SwitchExtErr  = Kein Zugriff auf das Include-Verzeichnis, evtl. sind noch Dateien geffnet!

   lng_exit          = Beenden
   lng_Left          = linke
   lng_Right         = rechte
   lng_MouseButton   = Maustaste
   lng_Win           = Windows-Taste
   lng_Alt           = Alt-Taste
   lng_Shift         = Shift-Taste
   lng_Ctrl          = Strg-Taste
   lng_ScriptReload  = %ScriptName% aktualisiert.
   lng_Readme        = Informationen
   lng_Changelog     = nderungen
   lng_Select        = &Durchsuchen ...

   LngCode           =
}
else if Lng = 13  ; Nederlands
{
   lng_Info          = Hulp en info over %ScriptTitle%
   lng_wrongAHK      = AutoHotkey %neededAHKversion% of hoger nodig.`nHaalt u a.u.b. de nieuwste versie op.
   lng_ProblemSolver = Problemen oplossen`tWin+Shift+#
   lng_ProbSolvHidden= Alle door %ScriptName% verstopte vensters werden hersteld!
   lng_ProbSolvResult= De volgende problemen werden opgelost:
   lng_ProbSolvWhy   = Bij het starten van %ScriptName% werden niet herstelde vensters gevonden.
   lng_ProbSolvNoRes = Geen problemen gevonden.`nProbeer indien nodig %ScriptName% met Win+Shift+ESC uit te schakelen.
   lng_update        = Check op online-updates
   lng_AutoCheckUpdt = Elke week automatisch checken
   lng_AskUpdate     = Wilt u een automatisch online update uitvoeren?`nJe moet hiervoor online zijn en minimaal over Internet Explorer 3 beschikken
   lng_NeedNoUpdate  = %ScriptTitle% is al up-to-date!
   lng_NeedUpdate    = Er is een nieuwe versie van %ScriptName% beschikbaar. Moet deze worden gedownload en %ScriptName% automatisch worden geactualiseerd?`nHierbij worden geen instellingen in de INI-bestanden veranderd. `n`nActuele versie: %ScriptVersion%`nBeschikbare versie:
   lng_UpdateError   = De actuele versie kon niet worden achterhaald, controleer je internetverbinding.`nDe update werkt alleen met Internet Explorer 3 of hoger.
   lng_UpdateFinished= De update werd doorgevoerd. %ScriptName% wordt nu opnieuw geladen.
   lng_UpdateSuccess = Update geslaagd: %ScriptTitle%
   lng_UpdateFailed  = De gedownloade update is corrupt, probeer het later nog eens.
   lng_autostart     = %ScriptName% bij de systeemstart laden
   lng_reload        = %ScriptName% opnieuw laden
   lng_deactivate    = %ScriptName% uitschakelen`tWin+Shift+ESC
   lng_Includes      = Extensions (Includes)
   lng_ExtMenu       = Extensions with menu-entry
   lng_ExtNoMenu     = Extensions without menu-entry
   lng_ExtOff        = activate all extensions
   lng_ExtOn         = deactivate all extensions
   lng_SwitchExtErr  = No access to the include-folder, maybe you have files open!

   lng_exit          = Afsluiten
   lng_Left          = linker
   lng_Right         = rechter
   lng_MouseButton   = muistoets
   lng_Win           = Windows-toets
   lng_Alt           = Alt-toets
   lng_Shift         = Shift-toets
   lng_Ctrl          = Ctrl-toets
   lng_ScriptReload  = %ScriptName% gepdate.
   lng_Readme        = Informatie
   lng_Changelog     = Veranderingen (Duits)
   lng_Select        = &Doorzoeken ...

   LngCode           = _nl
}
else        ; = other languages (english)
{
   lng_Info          = Help and information about %ScriptTitle%
   lng_wrongAHK      = AutoHotkey %neededAHKversion% or high will be needed.`nPlease download the newest version.
   lng_ProblemSolver = resolve problems`tWin+Shift+#
   lng_ProbSolvHidden= All by %ScriptName%' hidden windows are restored!
   lng_ProbSolvResult= The following problems have been solved:
   lng_ProbSolvWhy   = %ScriptName% has found some hidden windows.
   lng_ProbSolvNoRes = No problems found.`nTry to deactivate %ScriptName% with Win+Shift+ESC.
   lng_update        = check for online-updates
   lng_AutoCheckUpdt = automatically check every week
   lng_AskUpdate     = Should the script check for an update?`nYou have to be online and at least Internet Explorer 3 has to be installed.`n`nA new version could also be found at: http://www.heise.de/ct/ftp/05/08/098
   lng_NeedNoUpdate  = %ScriptTitle% needs no update!
   lng_NeedUpdate    = There's a new version of %ScriptName% available.`nShould %ScriptName% be downloaded and automatically updated?`nThe INI-files won't be changed!`n`nactual version: %ScriptVersion%`navailable version:
   lng_UpdateError   = Could not get the actual version, please check your internet connection.`nInternet Explorer 3 or greater must be installed for this function to work.
   lng_UpdateFinished= %ScriptName% has been updated, it will be reloaded.
   lng_UpdateSuccess = Update successfull: %ScriptTitle%
   lng_UpdateFailed  = The downloaded file is not correct, please try it again later.
   lng_autostart     = load %ScriptName% at system-start
   lng_reload        = reload %ScriptName%
   lng_deactivate    = deactivate %ScriptName%`tWin+Shift+ESC
   lng_Includes      = Extensions (Includes)
   lng_ExtMenu       = Extensions with menu-entry
   lng_ExtNoMenu     = Extensions without menu-entry
   lng_ExtOff        = activate all extensions
   lng_ExtOn         = deactivate all extensions
   lng_SwitchExtErr  = No access to the include-folder, maybe you have files open!

   lng_exit          = Exit
   lng_Left          = left
   lng_Right         = right
   lng_MouseButton   = Mousebutton
   lng_Win           = Windows-key
   lng_Alt           = Alt-key
   lng_Shift         = Shift-key
   lng_Ctrl          = Ctrl-key
   lng_ScriptReload  = %ScriptName% reloaded.
   lng_Readme        = Information
   lng_Changelog     = Changes (german)
   lng_Select        = &Select ...

   LngCode           =
}

; Wenn ac'tivAid mit dem Parameter 'kill' aufgerufen wird, wird es direkt beendet.
; Wird fr das Auto-Update der EXE-Datei bentigt
If 1 = kill
   ExitApp

; Falls das Skript als EXE-Datei vorliegt, verwendet es sich selber fr die Icons
; das setzt voraus, dass die AutoHotkeySC.bin im Compilerverzeichnis modifiziert wurde
If A_Iscompiled = 1
{
   ScriptIcon = %A_ScriptFullPath%
   ScriptIcon# = 1
   ScriptOnIcon = %A_ScriptFullPath%
   ScriptOnIcon# = 6
   ScriptOffIcon = %A_ScriptFullPath%
   ScriptOffIcon# = 7
   ScriptTitleAdd := " (exe)"
}
Else
{
   ScriptIcon = %ScriptName%_ct.ico
   ScriptIcon# = 1
   ScriptOnIcon = %ScriptName%.ico
   ScriptOnIcon# = 1
   ScriptOffIcon = %ScriptName%_off.ico
   ScriptOffIcon# = 1

   ; Skript-berwachung, damit es bei nderung neu geladen wird
   SetTimer, UPDATEDSCRIPT, 1000
}

; Prfen, ob richtige AutoHotkey-Version installiert ist
If A_AHKversion < %neededAHKversion%
{
   MsgBox, 16, %ScriptTitle%, %lng_wrongAHK%
   Run, http://www.autohotkey.com./download/
   ExitApp
}

; Prfen ob NiftyWindows aktiv ist
DetectHiddenWindows, On
IfWinExist,NiftyWindows,,.zip
   niftyWindows = on
Else
   IfWinExist,,NiftyWindows.ahk,.zip,NiftyWindows.ini
      niftyWindows = on
DetectHiddenWindows, Off

; Prfen ob die Sprechblasen (BalloonTips) deaktiviert sind
RegRead, EnableBalloonTips, HKEY_CURRENT_USER, Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced, EnableBalloonTips

; Gelegentlich auf NiftyWindows prfen
SetTimer, sub_CheckForNifty, 2000

; -----------------------------------------------------------------------------
; Tray-Men und Icon erstellen
; -----------------------------------------------------------------------------
Menu, Tray, Tip, %ScriptTitle%%ScriptTitleAdd%

Menu, Tray, Icon, %ScriptOnIcon%, %ScriptOnIcon#%, 1

Menu, Tray, NoStandard
Menu, Tray, Add, %lng_Info%%ScriptTitleAdd%, sub_ShowReadme
Menu, Tray, Add, %lng_update%, sub_getUpdates
Menu, Tray, Add
Menu, Tray, Add, %lng_ProblemSolver%, sub_ProblemSolver
Menu, Tray, Add

; Menpunkt fr jede eingebundenen Funktionen erstellen
Loop
{
   FIndex++
   If (A_Index = 8 AND Function[8] <> "")
      Menu, Tray, Add

   FunctionMenu[%FIndex%] := Function[%A_Index%]

   actFunct := FunctionMenu[%FIndex%]
   actEnable = Enable_%actFunct%

   If actFunct =
      Break

   IniRead, %actEnable%, %ConfigFile%, %ScriptNameClean%, %actEnable%
   If %actEnable% = ERROR
      If A_Index < 8
         %actEnable% = yes
      Else
         %actEnable% = no  ; Erweiterungen nicht automatisch aktivieren

   Gosub, init_%actFunct% ; cd_

   If MenuName =  ; kein Meneintrag?
   {
      NoMenuIndex++
      FunctionNoMenu[%NoMenuIndex%] := FunctionMenu[%FIndex%]
      FunctionNoMenuVer[%NoMenuIndex%] := %Prefix%_ScriptVersion
      FIndex --
      continue
   }

   FunctionMenuVer[%FIndex%] := %Prefix%_ScriptVersion

   ScriptMenu[%FIndex%] = %MenuName%
   ScriptMenu[%SubMenu%] = %MenuName%
   Gosub, sub_MenuCreate

;---MouseClip--->
   if actFunct = MouseClip
      if %actEnable% <> yes
      {
        Hotkey, $MButton, Off
        Hotkey, $MButton Up, Off
      }
;<---MouseClip---
}

; Unterer Teil des Mens mit 'deaktivieren' und 'beenden'.
Menu, Tray, Add
Menu, Tray, Add, %lng_autostart%, sub_MenuAutostart
Menu, Tray, Add, %lng_reload%, sub_MenuReload
Menu, Tray, Add, %lng_deactivate%, sub_MenuSuspend
Menu, Tray, Default, %lng_deactivate%

Menu, Tray, Add
Menu, Tray, Add, %lng_exit% , sub_MenuExit

IfExist %A_Startup%\%ScriptName%.lnk
   Menu, Tray, Check, %lng_autostart%
Else
   Menu, Tray, UnCheck, %lng_autostart%

; -----------------------------------------------------------------------------

AutoTrim, Off

; Readme-Datei einlesen
Loop, Read, %ScriptName% Readme%LngCode%.txt
{
   ReadLine = %A_LoopReadLine%
   StringReplace, ReadLine, ReadLine, aktiv: ###, aktiv: %A_AHKversion%
   Readme = %Readme%%ReadLine%`n
}

; Changelog-Datei einlesen
Loop, Read, %ScriptName% Changelog.txt
{
   Changelog = %Changelog%%A_LoopReadLine%`n
}

AutoTrim, On

; Problembehebung erforderlich?
; Prfe ob versteckte Fenster nicht wiederhergestellt wurden
IniRead, HiddenWindowsList, %ConfigFile%, HiddenWindows, WindowList

If HiddenWindowsList = ERROR
   HiddenWindowsList =

If HiddenWindowsList <>
{
   ProbSolvStartMessage = %lng_ProbSolvWhy%`n`n
   Gosub, sub_ProblemSolver
}

; Skript aktualisiert?
IfExist, update.zip
{
   FileSetAttrib,-A,%A_ScriptFullPath%
   FileDelete, update.zip
   FileDelete, update.cmd
   FileDelete, unzip.exe
   Changlog_active = |
   Gosub, sub_ShowReadme
}

; Wchentliches Update
IniRead, AutoUpdate, %ConfigFile%, Update, AutoUpdate
IniRead, LastUpdate, %ConfigFile%, Update, LastUpdate
UpdateDiff := (A_YYYY A_YDay) - LastUpdate

If (AutoUpdate = "yes" AND (LastUpdate = "" OR LastUpdate = "ERROR" OR UpdateDiff >6) )
{
   Suspend, On
   URLDownloadToFile,http://www.heise.de/ct/ftp/05/08/098/versions.ini?dl=yes,versions.ini

   If ErrorLevel = 1
   {
      MsgBox, 16, %ScriptTitle% Update, %lng_UpdateError%
      Return
   }

   IniRead, newScriptVersion, versions.ini, activAid, version
   IniRead, newScriptURL, versions.ini, activAid, url
   IniRead, newScriptSize, versions.ini, activAid, size
   IniRead, newScriptUnzipURL, versions.ini, activAid, unzip
   FileDelete, versions.ini

   If newScriptVersion = ERROR
   {
      MsgBox, 16, %ScriptTitle%, %lng_UpdateError%
      Return
   }

   if newScriptVersion > %ScriptVersion%
   {
      Gosub, sub_NewVersion
   }
   IniWrite, % A_YYYY A_YDay, %ConfigFile%, Update, LastUpdate

   Suspend, Off
}

; eigene Funktionen laden (include)
#Include *i include\main.ahk

Return

; -----------------------------------------------------------------------------
; === Subroutines =======================================================main==
; -----------------------------------------------------------------------------

; Menpunkt fr Funktion erstellen und Haken setzen
sub_MenuCreate:
   If SubMenu <>
   {
      Menu, Tray, add, %MenuName%, :%SubMenu%
      EnableMenu := %actFunct%_EnableMenu
      if (Enable_%actFunct% = "yes")
      {
         Menu, %SubMenu%, Check, %EnableMenu%
         Menu, Tray, Check, %MenuName%
      }
      Else
      {
         Menu, %SubMenu%, UnCheck, %EnableMenu%
         Menu, Tray, UnCheck, %MenuName%
      }
   }
   Else
   {
      Menu, Tray, add, %MenuName%, sub_MenuCall
      if (Enable_%actFunct% = "yes")
         Menu, Tray, Check, %MenuName%
      Else
         Menu, Tray, UnCheck, %MenuName%
   }
   SubMenu =
Return


; Wird von den Menpunkten aufgerufen.
sub_MenuCall:
   If A_ThisMenu = Tray
   {
      MenuID := A_ThisMenuItemPos -5
      If MenuID > 7
         MenuID--
      MenuItem := FunctionMenu[%MenuID%]
   }
   Else
   {
      MenuID = 0
      StringSplit, MenuItem, A_ThisMenu, _
      MenuItem = %MenuItem1%
   }

   ; Menupunkt de/aktivieren
   if Enable_%MenuItem% = yes
   {
      Menu, %A_ThisMenu%, UnCheck, %A_ThisMenuItem%
      If A_ThisMenu <> Tray
         Menu, Tray, UnCheck, % ScriptMenu[%A_ThisMenu%]

      Enable_%MenuItem% = no

      if MenuItem = MouseClip
      {
         Hotkey, $MButton, Off
         Hotkey, $MButton Up, Off
      }
   }
   Else
   {
      Menu, %A_ThisMenu%, Check, %A_ThisMenuItem%
      If A_ThisMenu <> Tray
         Menu, Tray, Check, % ScriptMenu[%A_ThisMenu%]

      Enable_%MenuItem% = yes

      if MenuItem = MouseClip
      {
         Hotkey, $MButton, On
         Hotkey, $MButton Up, On
      }
   }

   ; Einstellung speichern
   Loop
   {
      actFunct := FunctionMenu[%A_Index%]
      actEnable = Enable_%actFunct%

      If actFunct =
         Break

      IniWrite, % %actEnable% , %ConfigFile%, %ScriptNameClean%, %actEnable%
   }
Return

; ProblemSolver versucht 'festhngende' Tasten und Maustasten zu lsen
$#+SC02B:: ; ProblemSolver
~CapsLock & SC02B:: ; ProblemSolver
sub_ProblemSolver:
   If cd_tempDesktop <>
      Gosub, $ESC

   Gosub, sub_RestoreKeyStates  ; Korrigiert die Modifier-Tasten

   If HiddenWindowsList <>
   {
      Loop
      {
         If HiddenWindowsList =
            break

         StringGetPos, ProbSolvPos, HiddenWindowsList, |
         StringLeft, ProbSolvID, HiddenWindowsList, %ProbSolvPos%
         WinShow, ahk_id %ProbSolvID%
         StringReplace, HiddenWindowsList, HiddenWindowsList, %ProbSolvID%|,
      }
      ProbSolvMessage = %ProbSolvMessage%%lng_ProbSolvHidden%
      IniWrite, %HiddenWindowsList%, %ConfigFile%, HiddenWindows, WindowList
   }

   If ProbSolvMessage =
      BalloonTip(ScriptTitle, ProbSolvStartMessage lng_ProbSolvNoRes,"Info")
   Else
      BalloonTip(ScriptTitle, ProbSolvStartMessage lng_ProbSolvResult "`n`n" ProbSolvMessage, "Info")
   ProbSolvStartMessage =
Return

sub_MenuReload:
   Reload
return

; Alle Funktionen deaktivieren
$#+ESC:: ; Suspend
~CapsLock & ESC:: ; Suspend
sub_MenuSuspend:
   Suspend, Toggle
   Menu, Tray, ToggleCheck, %lng_deactivate%

   if ScriptIconSwitch =
   {
      Menu, Tray, Icon, %ScriptOffIcon%, %ScriptOffIcon#%, 1
      ScriptIconSwitch = 1
   }
   Else
   {
      Menu, Tray, Icon, %ScriptOnIcon%,%ScriptOnIcon#%, 1
      ScriptIconSwitch =
   }

   Loop
   {
      actFunct := FunctionMenu[%A_Index%]

      If actFunct =
         Break

      Menu, Tray, ToggleEnable, % ScriptMenu[%A_Index%]
   }
Return

; Informations-Dialog mit Readme anzeigen
sub_ShowReadme:
   ; Erweiterungen auflisten.
   Extensions = ======================================`n%lng_ExtMenu%:`n======================================
   Loop
   {
      If A_Index < 8
         Continue
      If FunctionMenu[%A_Index%] =
         Break
      Temp := FunctionMenu[%A_Index%]
      Temp := Enable_%Temp%
      If Temp = yes
         Temp := "[] "
      Else
         Temp := "[ ] "
      Extensions := Extensions "`n" Temp FunctionMenu[%A_Index%] "`tv" FunctionMenuVer[%A_Index%]
   }
   Extensions = %Extensions%`n`n======================================`n%lng_ExtNoMenu%:`n======================================
   Loop
   {
      If FunctionNoMenu[%A_Index%] =
         Break
      Extensions := Extensions "`n[] " FunctionNoMenu[%A_Index%] "`tv" FunctionNoMenuVer[%A_Index%]
   }

   IniRead, AutoUpdate, %ConfigFile%, Update, AutoUpdate
   If AutoUpdate = yes
      AutoUpdate = 1
   Else
      AutoUpdate = 0

   Suspend,On
   Gui, Add, Picture,H32 W32 Icon%ScriptIcon#%, %ScriptIcon%
   Gui, Font, s25 bold italic,Arial
   Gui, Add, Text, x+10 yp-2 , ac'tivAid%A_Space%
   Gui, Font, s8 norm italic
   Gui, Add, Text, x+70 yp+5 , v%ScriptVersion% von Wolfgang Reszel fr c't`n 2005 Heise Zeitschriften Verlag GmbH && Co. KG
   Gui, Font
   If Function[8] =
      IfExist include
         NoExts = yes

   If NoExts = yes
      Gui, Add, Tab,X8 H330 W608, %lng_Readme%|%lng_Changelog%|%Changlog_active%
   Else
      Gui, Add, Tab,X8 H330 W608, %lng_Readme%|%lng_Changelog%|%Changlog_active%%lng_Includes%

   Gui, Font, S8, Courier New
   Gui, Font, S8, Lucida Consolea
   Gui, Tab, %lng_Readme%
   Gui, Add, Edit, X+2 Y+3 Readonly H300 W600 vReadme, %Readme%
   Gui, Tab, %lng_Changelog%
   Gui, Add, Edit, X+2 Y+3 Readonly H300 W600 vChangelog, %Changelog%
   If NoExts =
   {
      Gui, Tab, %lng_Includes%
      IfExist, include
      {
         Gui, Add, Edit, X+2 Y+3 Readonly H270 W600 vIncludes T115, %Extensions%
         Gui, Font
         If A_IsCompiled <> 1
            Gui, Add, Button, gsub_ExtensionsOff, %A_Space%%A_Space%%lng_ExtOff%%A_Space%%A_Space%
      }
      IfExist, include_off
      {
         Gui, Font
         If A_IsCompiled <> 1
            Gui, Add, Button, gsub_ExtensionsOn, %A_Space%%A_Space%%lng_ExtOn%%A_Space%%A_Space%
      }
   }
   Gui, Font
   Gui, Tab
   Gui, Add, Button, X8 gsub_getUpdates, &%lng_Update%
   Gui, Add, CheckBox, X+8 YP+5 vAutoUpdate Checked%AutoUpdate%, &%lng_AutoCheckUpdt%
   Gui, Add, Button, X535 YP+0 W80 Default gGuiClose, &OK
   GuiControl, 1:Focus, &OK
   Gui, Show,, Informationen ber %ScriptTitle%%ScriptTitleAdd%

   If Changlog_active = |
   {
      Changlog_active =
      MsgBox, 64, %ScriptTitle%, %lng_UpdateSuccess%
   }
Return

GuiEscape:
GuiClose:
GuiExit:
GuiCancel:
   Gui, Submit

   If AutoUpdate = 1
      AutoUpdate = yes
   Else
      AutoUpdate = no
   IniWrite, %AutoUpdate%, %ConfigFile%, Update, AutoUpdate

   Gui, Destroy
   Suspend,Off
Return

sub_MenuExit:
   ExitApp
Return

; Prfen, ob NiftyWindows luft und dieses Skript ggf. mit doppeltem Suspend *vor* Nifty setzen
sub_CheckForNifty:
   DetectHiddenWindows, On
   IfWinExist,NiftyWindows,,.zip
   {
      if niftyWindows <> on
      {
         Suspend, Toggle
         Suspend, Toggle
         niftyWindows = on
      }
   }
   Else IfWinExist,,NiftyWindows.ahk,.zip,NiftyWindows.ini
   {
      if niftyWindows <> on
      {
         Suspend, Toggle
         Suspend, Toggle
         niftyWindows = on
      }
   }
   Else
      NiftyWindows =

   DetectHiddenWindows, Off

   IfWinExist,,,NiftyWindows is resumed now.
   {
      WinGetClass, NiftyClass
      If ( NiftyClass = "tooltips_class32" AND NiftyTip <> "on" )
      {
         Suspend, Toggle
         Suspend, Toggle
         niftyWindows = on
         NiftyTip = on
      }
   }
   Else
      NiftyTip =
Return

sub_ExtensionsOff:
   FileMoveDir, include, include_off, R
   If ErrorLevel = 0
      Reload
   Else
      MsgBox, 16, %ScriptTitle%, %lng_SwitchExtErr%
return

sub_ExtensionsOn:
   FileMoveDir, include_off, include, R
   If ErrorLevel = 0
      Reload
   Else
      MsgBox, 16, %ScriptTitle%, %lng_SwitchExtErr%
return

; Unterroutine vom ProblemSolver, welche die Tasten prft und zurcksetzt
sub_RestoreKeyStates:
   ProbSolvMessage =

   Suspend, Toggle
   Suspend, Toggle

   GetKeyState,stateL,LButton
   GetKeyState,stateP,LButton, P
   if (stateL <> stateP)
   {
      Send,{LButton Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_MouseButton%`n
   }

   GetKeyState,stateL,RButton
   GetKeyState,stateP,RButton, P
   if (stateL <> stateP)
   {
      Send,{RButton Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_MouseButton%`n
   }

   GetKeyState,stateL,MButton
   GetKeyState,stateP,MButton, P
   if (stateL <> stateP)
   {
      Send,{MButton Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Middle% %lng_MouseButton%`n
   }

   GetKeyState,stateL,LWin
   GetKeyState,stateP,LWin, P
   if (stateL <> stateP)
   {
      Send,{LWin Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_Win%`n
   }

   GetKeyState,stateL,RWin
   GetKeyState,stateP,RWin, P
   if (stateL <> stateP)
   {
      Send,{RWin Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_Win%`n
   }

   GetKeyState,stateL,LAlt
   GetKeyState,stateP,LAlt, P
   if (stateL <> stateP)
   {
      Send,{LAlt Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_Alt%`n
   }

   GetKeyState,stateL,RAlt
   GetKeyState,stateP,RAlt, P
   if (stateL <> stateP)
   {
      Send,{RAlt Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_Alt%`n
   }

   GetKeyState,stateL,LCtrl
   GetKeyState,stateP,LCtrl, P
   if (stateL <> stateP)
   {
      Send,{LCtrl Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_Ctrl%`n
   }

   GetKeyState,stateL,RCtrl
   GetKeyState,stateP,RCtrl, P
   if (stateL <> stateP)
   {
      Send,{RCtrl Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_Ctrl%`n
   }

   GetKeyState,stateL,LShift
   GetKeyState,stateP,LShift, P
   if (stateL <> stateP)
   {
      Send,{LShift Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Left% %lng_Shift%`n
   }

   GetKeyState,stateL,RShift
   GetKeyState,stateP,RShift, P
   if (stateL <> stateP)
   {
      Send,{RShift Up}
      ProbSolvMessage = %ProbSolvMessage%%lng_Right% %lng_Shift%`n
   }
Return

; Nach Updates im Internet suchen
sub_getUpdates:
   Suspend, On
   If AutoUpdate <> yes
   {
      MsgBox, 36, %ScriptTitle% Update, %lng_AskUpdate%
      Suspend, Off
      IfMsgBox, No, Return
      Suspend, On
   }

   URLDownloadToFile,http://www.heise.de/ct/ftp/05/08/098/versions.ini?dl=yes,versions.ini

   If ErrorLevel = 1
   {
      MsgBox, 16, %ScriptTitle% Update, %lng_UpdateError%
      Return
   }

   IniRead, newScriptVersion, versions.ini, activAid, version
   IniRead, newScriptURL, versions.ini, activAid, url
   IniRead, newScriptSize, versions.ini, activAid, size
   IniRead, newScriptUnzipURL, versions.ini, activAid, unzip
   FileDelete, versions.ini

   If newScriptVersion = ERROR
   {
      MsgBox, 16, %ScriptTitle%, %lng_UpdateError%
      Return
   }

   if newScriptVersion > %ScriptVersion%
   {
      Gosub, sub_NewVersion
   }
   Else
   {
      MsgBox, 64, %ScriptTitle% Update, %lng_NeedNoUpdate% (Online: %newScriptVersion%)
   }

   Suspend, Off
Return

sub_NewVersion:
   MsgBox, 36, %ScriptTitle% Update, %lng_NeedUpdate% %newScriptVersion% %newScriptSize%
   IfMsgBox, Yes
   {
      Progress, P20 w400, %newScriptUnzipURL%, Downloading ..., %ScriptTitle% Update
      URLDownloadToFile, %newScriptUnzipURL%?dl=yes, unzip.exe
      Progress, 40
      Sleep,200
      Progress, P50 w400, %newScriptURL%, Downloading ..., %ScriptTitle% Update
      URLDownloadToFile, %newScriptURL%?dl=yes, update.zip
      Progress, 70
      Sleep,200
      If A_IsCompiled = 1
      {
         FileAppend, %ScriptName%.exe kill`n, update.cmd
         If CustomIncudes <> no
            FileAppend, unzip -o update.zip -x *.ini include\header.ahk include\main.ahk`n, update.cmd
         Else
            FileAppend, unzip -o update.zip -x *.ini`n, update.cmd
         FileAppend, unzip -n update.zip`n, update.cmd
         FileAppend, %ScriptName%.exe`n, update.cmd
         RunWait, update.cmd,, Hide
      }
      Progress, P90 w400, %A_Space%, Updating ..., %ScriptTitle% Update
      If CustomIncudes <> no
         RunWait, unzip -o update.zip -x *.ini include\header.ahk include\main.ahk,,Hide
      Else
         RunWait, unzip -o update.zip -x *.ini,,Hide
      RunWait, unzip -n update.zip,,Hide
      Sleep,200
      Progress, 100
      Sleep,200
      Progress, Off
      If ErrorLevel = 0
         MsgBox, 64, %ScriptTitle% Update, %lng_UpdateFinished%
      Else
      {
         MsgBox, 16, %ScriptTitle% Update, %lng_UpdateFailed%
         FileDelete, update.zip
         FileDelete, update.cmd
         FileDelete, unzip.exe
         return
      }
      Reload
   }
Return

; Skript bei nderung automatisch neu laden
UPDATEDSCRIPT:
   WinGetActiveTitle, act_Title
   IfNotInString, act_Title, %ScriptName%.ahk
      Return

   IfNotExist, update.zip
   {
      FileGetAttrib,attribs,%A_ScriptFullPath%

      IfInString,attribs,A
      {
         FileSetAttrib,-A,%A_ScriptFullPath%
         posX = %A_CaretX%
         posY = %A_CaretY%
         ToolTip, %lng_ScriptReload% , %posX%, %posY%
         Sleep,500
         Reload
      }
   }
Return

; Falls BalloonTips deaktiviert sind, normale Meldung ausgeben
BalloonTip(Title, Text, Symbol)
{
   Global EnableBalloonTips

   If EnableBalloonTips = 0
   {
      If Symbol = Info
         MsgBox,64, %Title%, %Text%
      If Symbol = Warning
         MsgBox,48, %Title%, %Text%
      If Symbol = Error
         MsgBox,16, %Title%, %Text%
   }
   Else
   {
      If Symbol = Info
         Symbol = 1
      If Symbol = Warning
         Symbol = 2
      If Symbol = Error
         Symbol = 3
      TrayTip, %Title%, %Text%,, %Symbol%
   }
}

; ac'tivAid im Autostart-Ordner eintragen
sub_MenuAutostart:
   IfExist %A_Startup%\%ScriptName%.lnk
   {
      Menu, Tray, UnCheck, %lng_autostart%
      FileDelete, %A_Startup%\%ScriptName%.lnk
   }
   Else
   {
      Menu, Tray, Check, %lng_autostart%
      If A_Iscompiled = 1
         FileCreateShortcut,%A_ScriptFullPath%,%A_Startup%\%ScriptName%.lnk,%A_ScriptDir%,,,%A_ScriptFullPath%
      Else
         FileCreateShortcut,%A_ScriptFullPath%,%A_Startup%\%ScriptName%.lnk,%A_ScriptDir%,,,%A_ScriptDir%\%ScriptName%_ct.ico
   }
Return

;---HotKeys------------------------------------:;------------------------------

; -----------------------------------------------------------------------------
; === Hotkeys =================================================================
; -----------------------------------------------------------------------------

~#ESC::
   Sleep, 300
   Suspend, Toggle
   Suspend, Toggle
   niftyWindows = on

   If Extend_WinESC <>
      Gosub, %Extend_WinESC%
Return

;---ComfortDrag--->
~*LButton:: ; cd
   cd_activatedWindowsList =

   GetKeyState,LBstate,LButton
   GetKeyState,LBstateP,LButton,P
   if ( LBstate = "D" AND LBstateP = "U")
      Send,{LButton Up}

   If Enable_ComfortDrag = yes
   {
      Gosub, cd_main_ComfortDrag_LButton
      Gosub, cd_main_ComfortDrag_LButtonUP
   }

   If Extend_LButton <>
      Gosub, %Extend_LButton%
Return
;<---ComfortDrag---

;---ComfortDrag--->
~*LButton Up:: ; cd
   ; ist seltsamerweise notwendig

   If Extend_LButtonUp <>
      Gosub, %Extend_LButtonUp%
Return
;<---ComfortDrag---

;---ComfortDrag-->
$+ESC:: ; cd
$ESC::  ; cd
   If Enable_ComfortDrag = yes
      Gosub, cd_main_ComfortDrag_ESC

   If cd_tempDesktop <>
      gosub, cd_main_ComfortDrag_ShiftCapsLock

   If Extend_ESC <>
      Gosub, %Extend_ESC%

   Send, {ESC}
Return
;<---ComfortDrag---

;---ComfortDrag--->
$RButton:: ; cd
   Gosub, cd_main_ComfortDrag_RButton

   If Extend_RButton <>
      Gosub, %Extend_RButton%
Return
;<---ComfortDrag---

;---ComfortDrag--->
$PgUp::    ; cd
   Gosub, cd_main_ComfortDrag_RButton

   If Extend_PgUp <>
      Gosub, %Extend_PgUp%
Return
;<---ComfortDrag---

;<--ComfortDrag---
$PgDn:: ;cd
   StringReplace, pgdn_LastHotkey, A_ThisHotkey, $,

   If Enable_ComfortDrag = yes
      Gosub, cd_main_ComfortDrag_MButton

   If Extend_PgDn <>
      Gosub, %Extend_PgDn%

   If MButton_send =
      Send, {%pgdn_LastHotkey%}

   MButton_send =
Return
;---ComfortDrag--->

$MButton:: ; mc cd
   StringReplace, mbutton_LastHotkey, A_ThisHotkey, $,
   GetKeyState,cd_LButtonstate,LButton,P
;<---ComfortDrag---
   If cd_LButtonstate = D
   {
      If Enable_ComfortDrag = yes
         Gosub, cd_main_ComfortDrag_MButton
   }
   Else
;---ComfortDrag--->
;---MouseClip--->
   If Enable_MouseClip = yes
      Gosub, mc_main_MouseClip
;<---MouseClip---

   If Extend_MButton <>
      Gosub, %Extend_MButton%

   If (MButton_send = "")
   {
      Send, {%mbutton_LastHotkey% Down}
      MBdown = yes
   }

   MButton_send =
Return

$MButton Up::
   StringReplace, cd_LastHotkey, A_ThisHotkey, $,

   If Extend_MButtonUp <>
      Gosub, %Extend_MButtonUp%

   If MBdown = yes
   {
      Send, {%cd_LastHotkey%}
   }
   MBdown =
Return

;---ComfortDrag--->
~Shift & Capslock:: ; cd
   Gosub, cd_main_ComfortDrag_ShiftCapsLock

   If Extend_ShiftCapslock <>
      Gosub, %Extend_ShiftCapslock%
Return
;<---ComfortDrag---

;---FilePaste--->
~^c:: ; fp
   If Enable_FilePaste = yes
      Gosub, fp_main_FilePaste_copy

   If Extend_CtrlC <>
      Gosub, %Extend_CtrlC%
Return
;<---FilePaste---

;---FilePaste--->
$^!+v:: ; fp
   StringReplace, fp_LastHotkey, A_ThisHotkey, $,

   If Enable_FilePaste = yes
      Gosub, fp_main_FilePaste_paste
   Else
      Send, {%fp_LastHotkey%}

   If Extend_CtrlAltShiftV <>
      Gosub, %Extend_CtrlAltShiftV%
Return
;<---FilePaste---

;---NewFolder--->
~^n:: ; nf
   If Enable_NewFolder = yes
      Gosub, nf_main_NewFolder

   If Extend_CtrlN <>
      Gosub, %Extend_CtrlN%
Return
;<---NewFolder---

;---WebSearch--->
#w:: ; wr
~CapsLock & w:: ; wr
   If Enable_WebSearch = yes
      Gosub, wr_main_WebSearch

   If Extend_WinW <>
      Gosub, %Extend_WinW%
Return
;<---WebSearch---

;---CommandLine--->
~Enter:: ; cl
   If Enable_CommandLine = yes
      Gosub, cl_main_CommandLine_invoke

   If Extend_Enter <>
      Gosub, %Extend_Enter%
Return
;<---CommandLine---

;---ComfortDrag--->
; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               ComfortDrag
; -----------------------------------------------------------------------------
; Prefix:             cd_
; Version:            0.7
; Date:               2005-05-13
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Vereinfacht das Kopieren und Verschieben von Dateien, besonders wenn
; viele Fenster geffnet sind. Verschiebt man Dateien im Explorer oder aus
; einem Programm in den Explorer, wird nach kurzer Zeit das Fenster unter der
; Maus aktiviert. Zudem lassen sich Fenster bei gedrckt gehaltener
; linker Maustaste mit der rechten Maustaste temporr ausschalten. Sobald die
; linke Maustaste losgelassen wird, werden die Fenster wiederhergestellt.
; Letzteres klappt bei Browsern (wegen Kompatibilitt zu Mausgesten) nur wenn
; die Maus auf der Titelleiste liegt (konfigurierbar).
; Anwendungen die mit ComfortDrag Probleme bereiten knnen in der ac'tivAid.ini
; unter [ComfortDrag] mit der Variable ExcludeApps von ComfortDrag
; ausgeschlossen werden. Die Eintrge werden mit einem Komma ohne Leerzeichen
; getrennt und beziehen sich auf einen Teil des Fenstertitels.
; Beispiel: ExcludeApps =Opera,Adobe
;
; Folgende Krzel lassen sich bei gedrckter linker Maustaste nutzen.
;
; ESC                - Stellt die Fensteranordnung wieder her und bricht einen
;                      Vorgang ab.
;
; rechte Maustaste   - Blendet das Fenster unter der Maus aus, funktioniert
; Bild Hoch            auch, wenn man auf dem Fenstertitel mit der linken und
;                      rechten Maustaste klickt. Beim Loslassen beider Maus-
;                      Tasten wird der Ursprungszustand hergestellt.
;
; Shift              - Hlt man beim Loslassen der Maustasten die Shift-Taste
;                      gedrckt, bleibt das Fenster unter der Maus aktiviert.
;                      Somit kann man sich sozusagen ein Fenster 'raussuchen'.
;
; mittlere Maustaste - Stellt einzeln mit der rechten Maustaste versteckte
; Bild Runter          Fenster wieder her. Werden keine Fenster versteckt, wird
;                      das Fenster unter der Maus aktiviert und falls es
;                      schon aktiviert war, wird das verdeckte Fenster
;                      darunter hervorgeholt.
;
; Shift + ShiftLock  - Zeigt kurzfristig den Desktop, was auch beim Kopieren
; (Feststellen-Taste)  funktioniert. Drckt man das Krzel nochmals, erscheinen
;                      die Fenster wieder, was ebenso nach dem zweiten
;                      Mausklick passiert.

; *** Nederlands **************************************************************

; Maakt het kopiren en verplaatsen van bestanden makkelijker, vooral als meerdere
; vensters geopend zijn. Als je bestanden binnen de Verkenner of vanuit een
; programma naar de verkenner verplaatst, wordt na korte tijd het venster onder de
; muis actief. Bovendien kun je vensters bij ingedrukte linker muistoets
; met de rechter muistoets tijdelijk op inactief zetten. Zodra de linker
; muistoets losgelaten wordt worden de vensters hersteld.
;
; De volgende afkortingen kun je bij gedrukte linker muistoets gebruiken.
;
; ESC                - Herstelt de originele vensterconfiguratie en breekt een
;                      actie af
;
; rechter muistoets  - schakelt het venster onder de muis uit, werkt ook als
; PgUp                 je op de venstertitel met de linker en rechter muistoets
;                      clickt. Bij het loslaten van beide muistoetsen wordt de
;                      originele toestand hersteld.
;
; Shift              - Als je bij het loslaten van de muistoets de shift-toets
;                      ingedrukt houdt, blijft het venster onder de muis actief.
;                      Zo kun je bij wijze van spreken een venster 'uitzoeken'.
;
; midden muistoets   - Herstelt afzonderlijk met de rechter muistoets verstopte
; PgDn                 vensters. Als geen vensters verstopt werden, wordt het
;                      venster onder de muis actief en als het al actief was wordt
;                      het afgedekte venster eronder naar voren gehaald.
;
; Shift + CapsLock   - Laat voor korte tijd de desktop zien. Dit werkt ook bij
;                      het kopiren. Als je de sneltoets nog eens indrukt, ver-
;                      schijnen de vensters weer; dit gebeurt ook na de tweede
;                      muisklik.

; #################################################################EndHeader###

;---ComfortDrag--------------------------------:;------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ======================================================cd==
; -----------------------------------------------------------------------------

init_ComfortDrag:
   Prefix = cd
   %Prefix%_ScriptName    = ComfortDrag
   %Prefix%_ScriptVersion = 0.7

   SubMenu          = ComfortDrag_Menu ; ID des Untermens

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName               = %cd_ScriptName% - interaktives Wechseln der Fenster
      ComfortDrag_EnableMenu = %cd_ScriptName% aktiviert
      lng_cd_MenuGestures    = Web-Browser nur ber Titelleiste versteckbar
      lng_cd_TempDesk        = kurzfristiger Desktop
   }
   else if Lng = 13  ; = Nederlands
   {
      MenuName               = %cd_ScriptName% - interactief venster veranderen
      ComfortDrag_EnableMenu = %cd_ScriptName% actief
      lng_cd_MenuGestures    = Web-Browser kan alleen via de titelbalk worden verstopt
      lng_cd_TempDesk        = tijdelijke desktop
   }
   else        ; = other languages (english)
   {
      MenuName               = %cd_ScriptName% - interactive windows switching
      ComfortDrag_EnableMenu = %cd_ScriptName% active
      lng_cd_MenuGestures    = web browsers only hideable from the title-bar
      lng_cd_TempDesk        = temporary desktop
   }

   ; fr die Verwendung innerhalb das Skripts
   cd_SubMenu   = %SubMenu%
   cd_MenuName  = %MenuName%

   Menu, %cd_SubMenu%, Add, %ComfortDrag_EnableMenu%, sub_MenuCall
   Menu, %cd_SubMenu%, Add
   Menu, %cd_SubMenu%, Add, %lng_cd_MenuGestures%, cd_sub_MenuGestures

   IniRead, cd_onGestures, %ConfigFile%, %cd_ScriptName%, GestureApplications
   if cd_onGestures = ERROR
      cd_onGestures = yes

   if cd_onGestures = yes
   {
      Menu, %cd_SubMenu%, Check, %lng_cd_MenuGestures%
   }
   Else
   {
      Menu, %cd_SubMenu%, UnCheck, %lng_cd_MenuGestures%
   }

   ; Variable ExcludeApps aus der INI einlesen
   IniRead, cd_ExcludeApps, %ConfigFile%, %cd_ScriptName%, ExcludeApps
   If cd_ExcludeApps = ERROR
      cd_ExcludeApps =

   ; Wenn CapsLock lsen aus Shift-Taste eingestellt wurde, das Krzel
   ; fr den kurzfristigen Desktop ndern, dass CapsLock wieder mit
   ; Shift gelst wird.
   RegRead, cd_releaseWithShift, HKEY_CURRENT_USER, Keyboard Layout, Attributes
   If cd_releaseWithShift = 65536
   {
      msgbox,%cd_releaseWithShift%
      Hotkey, ~Shift & CapsLock, Off
      Hotkey, ~Shift & ~CapsLock, cd_main_ComfortDrag_ShiftCapslock
   }

   Gesture_Exclusions = OperaWindowClass,MozillaWindowClass,Internet Explorer_Server
Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================cd==
; -----------------------------------------------------------------------------

; linke Maustaste gedrckt
cd_main_ComfortDrag_LButton:
   cd_activeWindowHasChanged =
   cd_MouseStartCursor =

   If cd_tempDesktop =
   {
      MouseGetPos, cd_MouseStartDragX, cd_MouseStartDragY, cd_MouseStartWinID, cd_MouseStartControl
      WinGetPos, cd_WinStartX, cd_WinStartY,,, ahk_id %cd_MouseStartWinID%

      WinGetTitle, cd_MouseStartWinName, ahk_id %cd_MouseStartWinID%
      If cd_ExcludeApps <>
         If cd_MouseStartWinName contains %cd_ExcludeApps%
            Return

      gosub, cd_sub_StoreWindows

      Hotkey, $PgUp, On
      Hotkey, $RButton, On
      Hotkey, $+ESC, On
      Hotkey, $ESC, On
      Hotkey, ~CTRL, cd_sub_actImmediately
      Hotkey, ~CTRL, On

      SetTimer, cd_sub_whileDragging, 50

;---MouseClip--->
      If Enable_MouseClip = no
         Hotkey,$MButton, On
;<---MouseClip---

      KeyWait, LButton ; warten bis linke Maustaste wieder losgelassen wird

;---MouseClip--->
      If Enable_MouseClip = no
         Hotkey,$MButton, Off
;<---MouseClip---

      Hotkey, ~CTRL, Off
      Hotkey, $+ESC, Off
      Hotkey, $ESC, Off
      Hotkey, $PgUp, Off
      Hotkey, $RButton, Off
   }
Return

; linke Maustaste losgelassen
cd_main_ComfortDrag_LButtonUP:
   SetTimer, cd_sub_whileDragging, OFF
   SetTimer, cd_sub_ShowTree, Off

   If cd_temporaryTreeID <>
   {
      If (cd_HTMouseWinControl <> "SysTreeView321")
      {
         PostMessage, 0x111, 41525, 0, , ahk_id %cd_temporaryTreeID%
         cd_STMouseStartWinID =
         cd_hideTreeTimer =
         cd_temporaryTreeID =
      }
   }

   If cd_tempDesktop =
   {
      If cd_HiddenWinCount <>
      {
         GetKeyState, cd_shiftState, shift, P

         If cd_shiftState = D
         {
            MouseGetPos,,,cd_activateWinID

            IfWinNotActive, ahk_id %cd_activateWinID%
               WinActivate, ahk_id %cd_activateWinID%

            WinGet, cd_ExStyle, ExStyle, ahk_id %cd_activateWinID%

            If (cd_ExStyle & 0x8) ; 0x8 = WS_EX_TOPMOST.
               cd_actStartWin_AOT = yes
            Else
               cd_actStartWin_AOT = no

            If cd_actStartWin_AOT = no
               WinSet, AlwaysOnTop, On, ahk_id %cd_activateWinID%
         }

         If cd_onlyHiddenWin = yes
            Gosub, cd_sub_RestoreWindowsManualHidden
         Else
            Gosub, cd_sub_RestoreWindows

         If cd_shiftState = D
         {
            If cd_actStartWin_AOT = no
               WinSet, AlwaysOnTop, Off, ahk_id %cd_activateWinID%
            Else
               WinActivate, ahk_id %cd_activeStartWinID%
         }
      }

      If cd_activeWindowHasChanged = yes
      {
         SetTimer, cd_sub_activateUnderMouse, OFF
         cd_activateUnderMouseTimer = off
         MouseGetPos,,,cd_activeStartWinID
         WinActivate, ahk_id %cd_activeStartWinID%
      }
   }
   Else if cd_tempDesktop = restore
   {
      Gosub, cd_sub_RestoreWindows
      WinGet, cd_activeStartWinID, ID, A
      WinSet, AlwaysOnTop, Toggle, ahk_id %cd_activeStartWinID%
      WinSet, AlwaysOnTop, Toggle, ahk_id %cd_activeStartWinID%
   }
   Else
   {
      cd_tempDesktop = restore
   }
   cd_activeWindowHasChanged = ; no
Return

; whrend eine Operation ESC gedrckt
cd_main_ComfortDrag_ESC:
   SetTimer, cd_sub_ShowTree, Off
   SetTimer, cd_sub_whileDragging, Off
   SetTimer, cd_sub_activateUnderMouse, Off

   If cd_temporaryTreeID <>
   {
      If (cd_HTMouseWinControl <> "SysTreeView321")
      {
         PostMessage, 0x111, 41525, 0, , ahk_id %cd_temporaryTreeID%
         cd_STMouseStartWinID =
         cd_hideTreeTimer =
         cd_temporaryTreeID =
      }

      ESC_send = no
   }

   If cd_HiddenWinCount <>
   {
      GetKeyState, cd_shiftState, shift, P

      If cd_shiftState = D
      {
         MouseGetPos,,, cd_activeStartWinID
         WinActivate, ahk_id %cd_activeStartWinID%
      }

      If cd_onlyHiddenWin = yes
         Gosub, cd_sub_RestoreWindowsManualHidden
      Else
         Gosub, cd_sub_RestoreWindows
      ESC_send = no
   }

   If cd_activeWindowHasChanged = yes
   {
      cd_activateUnderMouseTimer = off
      WinActivate, ahk_id %cd_activeStartWinID%
      Gosub, cd_sub_RestoreWindows
      cd_activeWindowHasChanged =
      ESC_send =
   }
Return

; Timer der so lange ausgefhrt wird, wie die linke Maustaste gerdckt ist
cd_sub_whileDragging:
   MouseGetPos, cd_actMouseX, cd_actMouseY, cd_actWinID

   If ( cd_lastMouseX = cd_actMouseX AND cd_lastMouseY = cd_actMouseY )
      Return

   cd_lastMouseX = %cd_actMouseX%
   cd_lastMouseY = %cd_actMouseY%
   cd_diffX := cd_MouseStartDragX - cd_actMouseX
   cd_diffY := cd_MouseStartDragY - cd_actMouseY
   Transform, cd_diffX, abs, %cd_diffX%
   Transform, cd_diffY, abs, %cd_diffY%
   If ( (cd_diffY < 5 AND cd_diffX < 5) OR cd_MouseStartControl = "")
      Return

   If ( cd_MouseStartCursor = "" OR (cd_actWinID = cd_DragStartWinID AND cd_MouseStartCursor = "Arrow") )
   {
      cd_MouseStartCursor = %A_Cursor%
      cd_DragStartWinID = %cd_actWinID%

      SetTimer, cd_sub_whileDragging, 500
   }

   ;sleep, 250

   ; Dragging beginnt (Maust hat sich mehr als 4 Pixel bewegt)
   If ( cd_MouseStartCursor = "IBeam" )
   {
      SetTimer, cd_sub_activateUnderMouse, Off
      cd_activateUnderMouseTimer = off
      Return
   }
   If cd_MouseStartCursor In Unknown,No
   {
      GetKeyState,cd_LButtonstate,LButton,P

      If cd_LButtonstate = D
      {
         If cd_activeWindowHasChanged <> nop
         {
            WinGet, cd_activeWinID, ID, A
            MouseGetPos,,,cd_MouseWinID

            If cd_activeWinID <> %cd_MouseWinID%
            {
               cd_makeActiveWinID = %cd_MouseWinID%

               WinGetTitle, cd_MouseWinTitle, ahk_id %cd_MouseWinID%

               If cd_MouseWinTitle not in ,Program Manager
               {
                  If ( cd_activateUnderMouseTimer <> "on" ) ;  AND cd_HiddenWinCount = "" )
                  {
                     cd_activateUnderMouseTimer = on
                     MouseGetPos, cd_startMouseX , cd_startMouseY
                     SetTimer, cd_sub_activateUnderMouse, 480
                  }
               }
            }
            Else
            {
               If cd_temporaryTreeID =
                  SetTimer, cd_sub_ShowTree, 450
            }
         }
      }
   }
Return

; Fenster unter der Maus aktivieren
cd_sub_activateUnderMouse:
   MouseGetPos,,,cd_MouseStartWinID
   MouseGetPos, cd_endMouseX , cd_endMouseY
   cd_diffX := cd_startMouseX - cd_endMouseX
   cd_diffY := cd_startMouseY - cd_endMouseY
   Transform, cd_diffX, abs, %cd_diffX%
   Transform, cd_diffY, abs, %cd_diffY%

   If ( cd_diffY < 5 AND cd_diffX < 5)
   {
      If cd_makeActiveWinID = %cd_MouseStartWinID%
      {
         cd_onlyHiddenWin =
         WinActivate, ahk_id %cd_makeActiveWinID%
         cd_activatedWindowsList = %cd_activatedWindowsList%%cd_makeActiveWinID%|
         cd_activeWindowHasChanged = yes
         WinGetClass, cd_WinClass, ahk_id %cd_makeActiveWinID%

         If cd_WinClass in CabinetWClass,ExploreWClass
            SetTimer, cd_sub_ShowTree, 450
      }
   }

   SetTimer, cd_sub_activateUnderMouse, Off
   cd_activateUnderMouseTimer = off
Return

cd_sub_actImmediately:
   MouseGetPos,,,cd_makeActiveWinID
   cd_onlyHiddenWin =
   WinActivate, ahk_id %cd_makeActiveWinID%
   cd_activatedWindowsList = %cd_activatedWindowsList%%cd_makeActiveWinID%|
   cd_activeWindowHasChanged = yes
   SetTimer, cd_sub_activateUnderMouse, Off
   cd_activateUnderMouseTimer = off
Return

; Ordnerleiste einblenden
cd_sub_ShowTree:
   CoordMode, Mouse, RELATIVE

   If cd_temporaryTreeID <>
   {
      MouseGetPos, cd_MouseX,,cd_STMouseWinID,cd_STMouseWinControl
      If ((cd_STMouseWinID <> cd_temporaryTreeID OR cd_STMouseWinControl <> "SysTreeView321") and (cd_MouseX > 10 or cd_MouseX < 0))
      {
         If cd_hideTreeTimer <> on
         {
            SetTimer, cd_sub_HideTree, 400
            cd_hideTreeTimer = on
         }
      }

      Return
   }
   MouseGetPos, cd_MouseX,, cd_STMouseWinID
   WinGet, cd_STactiveWinID, ID, A
   WinGetClass, cd_WinClass, ahk_id %cd_STactiveWinID%

   If cd_STactiveWinID = %cd_STMouseWinID%
   {
      If cd_WinClass in CabinetWClass,ExploreWClass
      {
         If cd_MouseX < 10
         {
            ControlGet, cd_TreeVis, Visible,, SysTreeView321, ahk_id %cd_STactiveWinID%

            If cd_TreeVis < 1
            {
               SendMessage, 0x111, 41525, 0, , ahk_id %cd_STactiveWinID%

               cd_temporaryTreeID = %cd_STactiveWinID%
            }
            Else If cd_temporaryTreeID <>
            {
               MouseGetPos, cd_MouseX,,cd_STMouseWinID,cd_STMouseWinControl

               If ((cd_STMouseWinID <> cd_temporaryTreeID OR cd_STMouseWinControl <> "SysTreeView321") and (cd_MouseX > 10 or cd_MouseX < 0))
                  SetTimer, cd_sub_HideTree, 400
            }
         }
      }
   }
Return

; Ordnerleiste wieder verstecken
cd_sub_HideTree:
   CoordMode, Mouse, RELATIVE
   MouseGetPos, cd_MouseX,,cd_HTMouseWinID,cd_HTMouseWinControl

   If ((cd_HTMouseWinID <> cd_temporaryTreeID OR cd_HTMouseWinControl <> "SysTreeView321") and (cd_MouseX > 10 or cd_MouseX < 0))
   {
      SendMessage, 0x111, 41525, 0, , ahk_id %cd_temporaryTreeID%

      SetTimer, cd_sub_HideTree, Off
      cd_STMouseStartWinID =
      cd_hideTreeTimer =
      cd_temporaryTreeID =
   }
Return

; zustzlich rechte Maustaste gedrckt
cd_main_ComfortDrag_RButton:
   If Enable_ComfortDrag = yes
      Gosub, cd_sub_HideWindow
Return

; mit rechts angeklicktes Fenster verstecken
cd_sub_HideWindow:
   MouseGetPos, , , cd_actID, cd_actClass

   if cd_onGestures = yes
      If cd_actClass Contains %Gesture_Exclusions%
         If ( cd_actID = cd_MouseStartWinID AND cd_HiddenWinCount = "" AND cd_activeWindowHasChanged ="" )
         {
            Send, {RButton}
            Return
         }

   if (cd_HiddenWinCount = "" AND cd_activeWindowHasChanged = "")
      cd_onlyHiddenWin = yes

   MouseGetPos,,,cd_HWMouseWinID
   WinGetClass,cd_actClass, ahk_id %cd_HWMouseWinID%

   If cd_actClass not in Progman,Shell_TrayWnd
   {
      cd_HiddenWinCount ++
      cd_HiddenWinList[%cd_HiddenWinCount%] = %cd_HWMouseWinID%

      StringReplace, HiddenWindowsList, HiddenWindowsList, %cd_HWMouseWinID%|,
      HiddenWindowsList = %HiddenWindowsList%%cd_HWMouseWinID%|
      IniWrite, %HiddenWindowsList%, %ConfigFile%, HiddenWindows, WindowList

      WinHide, ahk_id %cd_HWMouseWinID%
   }
   RButton_send = no
Return

; zustzlich mittlere Maustaste gedrckt
cd_main_ComfortDrag_MButton:
   GetKeyState,cd_LButtonstate,LButton,P

   If cd_LButtonstate = D
      Gosub, cd_sub_ShowWindow
Return

; zuletzt verstecktes Fenster wiederholen oder zwischen zwei bereinander liegenden Fenstern wechseln
cd_sub_ShowWindow:
   If A_Cursor <> IBeam
   {
      MouseGetPos,,,cd_SWMouseWinID
      WinGet,cd_SWactiveWinID,ID,A

      If cd_HiddenWinCount <>
      {
         cd_Temp := cd_HiddenWinList[%cd_HiddenWinCount%]
         WinShow, ahk_id %cd_Temp%

         StringReplace, HiddenWindowsList, HiddenWindowsList, %cd_Temp%|,
         IniWrite, %HiddenWindowsList%, %ConfigFile%, HiddenWindows, WindowList

         cd_HiddenWinCount --

         If cd_HiddenWinCount = 0
         {
            cd_HiddenWinCount =
            cd_allWindowsRestored = yes
            WinSet,Redraw,, ahk_id %cd_Temp%
         }
      }
      Else
      {
         If ( cd_SWactiveWinID = cd_SWMouseWinID and cd_allWindowsRestored = "" )
         {
            Gosub, cd_sub_WindowBehind

            If cd_FoundID
               WinActivate, ahk_id %cd_FoundID%
         }
         Else
         {
            If cd_allWindowsRestored =
            {
               WinActivate, ahk_id %cd_SWMouseWinID%
            }
            Else
            {
               WinActivate, ahk_id %cd_activeStartWinID%
               cd_allWindowsRestored =
            }
         }
      }

      MButton_send = no
   }
Return

; kurzfristiger Desktop mit Shift+ShiftLock
cd_main_ComfortDrag_ShiftCapslock:
   If Enable_ComfortDrag = yes
   {
      StringReplace, cd_LastHotkey, A_ThisHotkey, $,

      If cd_tempDesktop =
      {
         Hotkey, $+ESC, On
         Hotkey, $ESC, On

         If cd_HiddenWinCount =
           gosub, cd_sub_StoreWindows

         SetTimer, cd_sub_DektopToolTip,0
         SetTimer, cd_sub_activateUnderMouse, Off
         cd_activateUnderMouseTimer = off

         CoordMode, Mouse
         MouseGetPos, cd_MouseX, cd_MouseY, testID

         WinGet, cd_List, List,,, Program Manager ; Lister alle sichtbaren Fenster auer Desktop

         cd_FirstWindowFound := False

         Loop %cd_List%  ; Alle sichtbaren Fenster durchgehen
         {
            cd_Index := cd_List-A_Index+1

            cd_ID := cd_List%cd_Index%
            WinGetClass, cd_class, ahk_id %cd_ID%

            If cd_class Not In Progman
            {
               StringReplace, HiddenWindowsList, HiddenWindowsList, %cd_ID%|,
               HiddenWindowsList = %HiddenWindowsList%%cd_ID%|
               WinHide, ahk_id %cd_ID%
            }
         }

         IniWrite, %HiddenWindowsList%, %ConfigFile%, HiddenWindows, WindowList

         cd_HiddenWinCount =
         cd_tempDesktop = yes

      }
      Else
      {
         Hotkey,$+ESC, Off
         Hotkey,$ESC, Off

         Gosub, cd_sub_RestoreWindows
      }
   }
Return

; alle sichtbaren Fenster in cd_WinIDs sichern
cd_sub_StoreWindows:
   DetectHiddenWindows, Off
   WinGet, cd_activeStartWinID,ID,A
   WinGet, cd_WinIDs, list, , , Program Manager

   Loop, %cd_WinIDs%
   {
      cd_Temp := cd_WinIDs%A_Index%
   }
Return

; Fenster aus cd_WinIDs wiederherstellen
cd_sub_RestoreWindows:
   WinGet, cd_ExStyle, ExStyle, ahk_id %cd_activeStartWinID%
   If (cd_ExStyle & 0x8) ; 0x8 = WS_EX_TOPMOST.
      cd_actStartWin_AOT = yes
   Else
      cd_actStartWin_AOT = no

   If cd_actStartWin_AOT = no
      WinSet, AlwaysOnTop, On, ahk_id %cd_activeStartWinID%

   Loop, %cd_WinIDs%
   {
      cd_TempIndex := A_Index
      cd_Temp := cd_WinIDs%cd_TempIndex%

      IfNotInString, cd_activatedWindowsList, %cd_temp%
         If (cd_activatedWindowsList <> "" AND cd_HiddenWinCount = "")
         {
            continue
         }
      cd_activatedWindowsList =

      If (cd_tempDesktop <> "" OR cd_HiddenWinCount > 0)
      {
         WinShow, ahk_id %cd_Temp%

         StringReplace, HiddenWindowsList, HiddenWindowsList, %cd_Temp%|,
         If cd_Temp = %cd_activeStartWinID%
            If cd_actStartWin_AOT = no
               WinSet, AlwaysOnTop, On, ahk_id %cd_activeStartWinID%
      }
      Else
      {
         WinSet, Bottom,, ahk_id %cd_Temp%
         WinSet, Redraw,, ahk_id %cd_Temp%
      }

   }

   ; brig gebliebene Schatten schlieen.
   WinGet, cd_List, List,,, Program Manager ; Lister alle sichtbaren Fenster auer Desktop
   Loop %cd_List%  ; Alle sichtbaren Fenster durchgehen
   {
      cd_ID := cd_List%A_Index%
      WinGetClass, cd_class, ahk_id %cd_ID%
      If cd_class in SysShadow
         WinClose, ahk_id %cd_ID%
   }

   SetTimer, cd_sub_DektopToolTip, Off
   ToolTip,,,,3

   IniWrite, %HiddenWindowsList%, %ConfigFile%, HiddenWindows, WindowList

   cd_WinIDs =
   cd_HiddenWinCount =
   cd_tempDesktop =
   If cd_actStartWin_AOT = no
      WinSet, AlwaysOnTop, Off, ahk_id %cd_activeStartWinID%
Return

; Einzeln versteckte Fenster wiederherstellen
cd_sub_RestoreWindowsManualHidden:
   SetTimer, cd_sub_DektopToolTip,Off
   ToolTip,,,,3

   If cd_activeStartWinID =
   {
      cd_Temp := cd_HiddenWinList[1]
      WinShow, ahk_id %cd_Temp%
      WinActivate, ahk_id %cd_Temp%
   }

   If cd_HiddenWinCount > 0
   {
      Loop
      {
         cd_Temp := cd_HiddenWinList[%cd_HiddenWinCount%]
         WinShow, ahk_id %cd_Temp%

         if (cd_Temp = cd_MouseStartWinID AND cd_activeWindowHasChanged ="")
            WinMove, ahk_id %cd_MouseStartWinID%,, %cd_WinStartX%, %cd_WinStartY%

         StringReplace, HiddenWindowsList, HiddenWindowsList, %cd_Temp%|,

         If cd_activeStartWinID <> %cd_Temp%
            cd_activeStartWinID =

         cd_HiddenWinList[%cd_HiddenWinCount%] =
         cd_HiddenWinCount --

         If cd_HiddenWinCount = 0
         {
            cd_HiddenWinCount =
            Break
         }
      }

      IniWrite, %HiddenWindowsList%, %ConfigFile%, HiddenWindows, WindowList
   }
Return

; Unterroutine, um zwischen zwei verdeckten Fenstern zu wechseln.
cd_sub_WindowBehind:
   CoordMode, Mouse
   MouseGetPos, cd_MouseX, cd_MouseY
   WinGet, cd_List, List,,, Program Manager

   cd_FirstWindowFound := False
   cd_FoundID =

   Loop %cd_List%
   {
      cd_ID := cd_List%A_Index%
      WinGetPos, cd_WinX, cd_WinY, cd_WinW, cd_WinH, ahk_id %cd_ID%

      If (cd_MouseX > cd_WinX and cd_MouseY > cd_WinY and cd_MouseX < cd_WinX+cd_WinW and cd_MouseY < cd_WinY+cd_WinH)
      {
         If cd_FirstWindowFound
         {
            cd_FoundID := cd_ID
            Break
         }
         Else
            cd_FirstWindowFound := True
      }
   }
Return

; Tooltip an der Maus solange temporrer Desktop aktiv
cd_sub_DektopToolTip:
   ToolTip, %lng_cd_TempDesk%,,,3
Return

; --- Unterroutine fr das Maus-Gesten-Men ----------------------------------------
cd_sub_MenuGestures:
   if cd_onGestures = no
   {
      cd_onGestures = yes
      Menu, %cd_SubMenu%, Check, %lng_cd_MenuGestures%
   }
   Else
   {
      cd_onGestures = no
      Menu, %cd_SubMenu%, UnCheck, %lng_cd_MenuGestures%
   }

   IniWrite, %cd_onGestures%, %ConfigFile%, %cd_ScriptName%, GestureApplications
Return
;<---ComfortDrag---



;---MouseClip--->
; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               MouseClip
; -----------------------------------------------------------------------------
; Prefix:             mc_
; Version:            0.6
; Date:               2005-05-31
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; AutoHotkey Version: 1.0.30.04
; Language:           German
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Ist ein Wort markiert und man drckt die mittlere Maustaste an einer
; anderen Stelle, wird dort automatisch das markierte Wort hinkopiert.
; Ist kein Wort markiert, wird der Inhalt der Zwischenablage eingefgt.
; Hlt man die mittlere Maustaste gedrckt, lsst sich damit Text
; markieren, welcher dann beim Loslassen automatisch kopiert wird.

; *** Nederlands **************************************************************

; Als een woord gemarkeerd is en je de middelste muistoets op een andere plek
; indrukt, wordt het gemarkeerde woord daar automatisch naartoe gekopieerd. Als
; er geen woord gemarkeerd is, wordt de inhoud van het klembord ingevoegd.
; Als de middelste muistoets ingedrukt wordt gehouden, kun je hiermee tekst markeren
; die dan bij het loslaten automatisch wordt gekopieerd.

; #################################################################EndHeader###

;---MouseClip----------------------------------:;------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ======================================================mc==
; -----------------------------------------------------------------------------

init_MouseClip:
   Prefix = mc
   %Prefix%_ScriptName   = MouseClip
   %Prefix%_ScriptVersion = 0.6

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName  = %mc_ScriptName% - Kopieren/Einfgen mit der Maus
      lng_mc_copied = kopiert
   }
   else if Lng = 13  ; = Nederlands
   {
      MenuName  = %mc_ScriptName% - Kopiren/invoegen met de muis
      lng_mc_copied = gekopieerd
   }
   else        ; = other languages (english)
   {
      MenuName  = %mc_ScriptName% - Copy/Paste with Mouse
      lng_mc_copied = copied
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================mc==
; -----------------------------------------------------------------------------

mc_main_MouseClip:
   SetKeyDelay,0,0

   MouseGetPos, mc_MouseStartX, mc_MouseStartY, mc_MouseStartWinID, mc_mouseStartClass
   WinGetTitle, mc_mouseStartTitle, ahk_id %mc_mouseStartWinID%

   ; Adobe-Anwendung erkennen
   StringLeft, mc_mouseStartTitle, mc_mouseStartTitle, 6
   If (mc_mouseStartTitle = "Adobe ")
      mc_mouseStartTitle = Adobe

   ; wenn mittlere Maustaste gedrckt und der Textmauspfeil (IBeam) sichtbar ist
   If (A_Cursor = "IBeam" OR (A_Cursor = "Unknown" AND mc_mouseStartClass="_WwG1") OR (A_Cursor = "Unknown" AND mc_mouseStartTitle = "Adobe") )
   {
      mc_cliptemp = %ClipboardAll%
      Clipboard =

      Send,^c
      mc_cliptemp_text = %Clipboard%

      mc_LBsend =
      If Clipboard =
      {
         Send,{LButton Down}
         mc_LBsend = yes
      }

      Clipboard = %mc_cliptemp%

      KeyWait,MButton

      MouseGetPos, mc_MouseEndX, mc_MouseEndY
      mc_diffX := mc_MouseStartX - mc_MouseEndX
      mc_diffY := mc_MouseStartY - mc_MouseEndY
      Transform, mc_diffX, abs, %mc_diffX%
      Transform, mc_diffY, abs, %mc_diffY%

      ToolTip

      Send, {LButton Up}

      If mc_mouseStartTitle contains Adobe
         SetKeyDelay,20,10

      If ( A_TimeSincePriorHotkey > 100 AND ( mc_diffX > 4 OR mc_diffY > 4 ) )
      {
         Send,^c
         ToolTip, %lng_mc_copied%

         If mc_mouseStartTitle contains Adobe
         {
            WinActivate,ahk_class Progman           ; Aktiviert kurz den Desktop
            ClipWait,1
            WinActivate,ahk_ID %mc_MouseStartWinID% ; und dann wieder die ursprngliche Anwendung
         }

         Sleep,400
         ToolTip
      }
      Else
      {
         If A_TimeSincePriorHotkey < 600
         {
            If mc_cliptemp_text <>
            {
               Clipboard = %mc_cliptemp_text%
               ToolTip, %lng_mc_copied%
            }

            If mc_LBsend =
               Send,{LButton}

            Clipboard = %Clipboard%

            If mc_mouseStartTitle contains Adobe
            {
               WinActivate,ahk_class Progman           ; Aktiviert kurz den Desktop
               WinActivate,ahk_ID %mc_MouseStartWinID% ; und dann wieder die ursprngliche Anwendung
            }

            If mc_NoPaste =
               Send,^v

            Sleep,400
            ToolTip
         }
      }
      MButton_send = no
   }
   Else
      MButton_send =
Return
;<---MouseClip---

;---FilePaste--->
; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               FilePaste
; -----------------------------------------------------------------------------
; Prefix:             fp_
; Version:            0.3
; Date:               2005-03-20
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Hat man im Explorer Dateien mit Strg+C kopiert, kann man deren Dateinamen
; als Text in einer beliebigen Anwendung mit Strg+Alt+Shift+V wieder
; einfgen. Kann auch dazu genutzt werden, formatierten Text
; unformatiert einzufgen (z.B. innerhalb von InDesign oder Illustrator).
;
; Strg+Alt+Shift+V   - den reinen Textinhalt der Zwischenablage einfgen
;                      z.B. im Explorer kopierte Dateien werden dann
;                      als Dateinamen eingefgt.

; *** Nederlands **************************************************************

; Als je bestanden in de Verkenner met Ctrl-C voor kopiren selecteert, kun je
; de bestandsnamen als tekst in een willekeurig programma met Ctrl-Alt-Shift-V
; invoegen. Je kun het ook gebruiken om opgemaakte tekst zonder opmaak in te voegen.
;
; Ctrl+Alt+Shift+V   - de pure tekstinhoud van het klembord invoegen, van bestanden
;                      die je met Ctrl-C vanuit de Verkenner naar het klembord kopieert
;                      wordt dan de bestandsnaam ingevoegd

; #################################################################EndHeader###

;---FilePaste----------------------------------:;------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ======================================================fp==
; -----------------------------------------------------------------------------

init_FilePaste:
   Prefix = fp
   %Prefix%_ScriptName    = FilePaste
   %Prefix%_ScriptVersion = 0.3

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName = %fp_ScriptName% - kopierte Dateien als Text einfgbar`tStrg+Alt+Sh+V
   }
   else if Lng = 13  ; = Nederlands
   {
      MenuName = %fp_ScriptName% - Gekopieerde bestanden als tekst invoegen `tCtrl+Alt+Sh+V
   }
   else        ; = other languages (english)
   {
      MenuName = %fp_ScriptName% - copied files are pasteable as plain text`tCtrl+Alt+Sh+V
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================fp==
; -----------------------------------------------------------------------------

; Strg+C heimlich abfragen und merken welche Verzeichnis sichtbar war
fp_main_FilePaste_copy:
   fp_path =
   WinGetClass, fp_winClass, A

   If fp_winClass in ExploreWClass,CabinetWClass,Progman
   {
      RegRead, fp_FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState, FullPath
      RegRead, fp_FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState, FullPathAddress

      If fp_FullPath = 1
      {
         WinGetTitle, fp_path, ahk_class %fp_winClass%
         fp_path = %fp_path%\
      }

      If fp_FullPathAddress = 1
      {
         ControlGetText, fp_path, Edit1, ahk_class %fp_winClass%
         fp_path = %fp_path%\
      }

      If fp_winClass = Progman
      {
         fp_CurrentExplorerDirectory = %A_Desktop%\
      }
   }
Return

; Textversion der Zwischenablage einfgen
fp_main_FilePaste_paste:
   fp_text = %Clipboard%
   StringReplace, fp_text, fp_text, %fp_path% ,,A
   Clipboard = %fp_text%
   ClipWait, 2

   ; Folgendes sorgt dafr, dass man Unformatierten Text auch in Adobe-Anwendungen einfgen kann.
   WinGet, fp_actID, ID, A
   IfWinActive, Adobe
   {
      WinActivate,ahk_class Progman ; Aktiviert kurz den Desktop
      WinActivate,ahk_ID %fp_actID% ; und dann wieder die ursprngliche Anwendung
   }

   Send, ^v
Return
;<---FilePaste---

;---NewFolder--->
; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               NewFolder
; -----------------------------------------------------------------------------
; Prefix:             nf_
; Version:            0.6
; Date:               2005-05-03
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; AutoHotkey Version: 1.0.30.04
; Language:           German
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Im Explorer, Dateidialogen und auf dem Desktop kann man mit
; Strg+N direkt einen neuen Ordner anlegen.
;
; Strg+N             - Neuen Ordner im Explorer anlegen

; *** Nederlands **************************************************************

; In de Verkenner, bestandsdialoogvensters en op de desktop kun je met
; Ctrl+N direct een nieuwe directory aanmaken
;
; Ctrl+N             - Nieuwe map in de Verkenner aanmaken

; #################################################################EndHeader###

;---NewFolder----------------------------------:;------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ======================================================nf==
; -----------------------------------------------------------------------------

init_NewFolder:
   Prefix = nf
   %Prefix%_ScriptName    = NewFolder
   %Prefix%_ScriptVersion = 0.5

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName = %nf_ScriptName% - Strg+N erstellt neue Ordner`tStrg+N
      nf_FolderName              = Neuer Ordner
      lng_nf_ErrorCreating       = Neuer Ordner kann nicht erstellt werden!
      lng_nf_ErrorCreatingDetail = In den Ordneroptionen muss eingestellt werden, `ndass im Fenstertitel oder in der Adressleiste der vollstndige Pfad angezeigt wird.
   }
   else if Lng = 13  ; = Nederlands
   {
      MenuName = %nf_ScriptName% - Ctrl+N maakt nieuwe mappen aan`tStrg+N
      nf_FolderName              = Nieuwe map
      lng_nf_ErrorCreating       = Kan geen nieuwe map aanmaken!
      lng_nf_ErrorCreatingDetail = Je moet in de mapopties aangeven dat`nin de venstertitel of de adresbalk het complete pad wordt weergegeven
   }
   else        ; = other languages (english)
   {
      MenuName = %nf_ScriptName% - Ctrl+N creates new folders`tCtrl+N
      nf_FolderName              = New Folder
      lng_nf_ErrorCreating       = Can't create folder!
      lng_nf_ErrorCreatingDetail = Please activate full paths for title-bar or address-bar in the folder-options!
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================nf==
; -----------------------------------------------------------------------------

; Strg+N in einem Explorer-Fesnter
nf_main_NewFolder:
   WinGetClass, nf_ActiveClass, A                    ; Klasse des aktiven Fensters

   If nf_ActiveClass in ExploreWClass,CabinetWClass,Progman  ; Wenn Explorer-Fenster ...
   {
      RegRead, nf_FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPath
      RegRead, nf_FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPathAddress

      ; Aktuellen Pfad anhand der Adressleiste ermitteln
      If nf_FullPath = 1
         WinGetTitle, nf_CurrentExplorerDirectory, ahk_class %nf_ActiveClass%

      If nf_FullPathAddress = 1
         ControlGetText, nf_CurrentExplorerDirectory, Edit1, ahk_class %nf_ActiveClass%

      If nf_ActiveClass = Progman
         nf_CurrentExplorerDirectory = %A_Desktop%

      Sleep,200

      If nf_CurrentExplorerDirectory =
      {
         MsgBox, 16, %lng_nf_ErrorCreating%, %lng_nf_ErrorCreatingDetail%
         Return
      }

      ; Prfe, ob 'Desktop' im Explorer ausgewhlt wurde
      RegRead, nf_Reg, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders,Desktop
      StringReplace, nf_Reg, nf_Reg, `%USERPROFILE`%\
      If nf_Reg = %nf_CurrentExplorerDirectory%
         nf_CurrentExplorerDirectory = %USERPROFILE%\%nf_Reg%

      ; Prfe, ob 'Eigene Dateien' im Explorer ausgewhlt wurde
      RegRead, nf_Reg, HKEY_CURRENT_USER,Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders,Personal
      RegRead, nf_MyDocs, HKEY_CURRENT_USER,Software\Microsoft\Office\11.0\Common\General,MyDocuments
      StringReplace, nf_Reg, nf_Reg, `%USERPROFILE`%, %USERPROFILE%
      StringReplace, nf_Reg, nf_Reg, `%USERNAME`%, %USERNAME%
      SplitPath, nf_Reg, nf_RegDir
      If nf_CurrentExplorerDirectory in Eigene Dateien,My Documents,mijn documenten,%nf_MyDocs%,%nf_RegDir%
         nf_CurrentExplorerDirectory = %nf_Reg%

      ifNotExist, %nf_CurrentExplorerDirectory%
         Return

      ; Neuen Ordner anlegen
      FileCreateDir, %nf_CurrentExplorerDirectory%\%nf_FolderName%

      ; Wenn kein Fehler
      If ErrorLevel = 0
      {
         ; Wenn Ordnerleiste aktiv, zum Ordnerinhalt wechseln
         ControlGetFocus, nf_Control, A
         If nf_Control = SysTreeView321
            ControlFocus, SysListView321, A

         ; 20 mal prfen, ob Ordner exisitert (dauert bei Netzlaufwerken etwas)
         Loop,20
         {
            IfExist, %nf_CurrentExplorerDirectory%\%nf_FolderName%   ; Prfen ob existiert
            {
               Send,{F5}                                         ; Explorer-Ansicht aktualisieren
               Send,%nf_FolderName%{F2}                          ; Ordner auswhlen (durch Eingabe des Namens)
               Break                                             ; Schleife verlassen
            }
            Sleep,100                                            ; kleine Pause
         }
      }
   }

   IfWinActive, ahk_class #32770                            ; Ist Dateidialog?
   {
      PostMessage, 0x111, 40962                                ; Direkten Befehl fr neuer Ordner senden
   }
Return
;<---NewFolder---

;---WebSearch--->
; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               WebSearch
; -----------------------------------------------------------------------------
; Prefix:             wr_
; Version:            0.6
; Date:               2005-05-06
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Markierter Text aus fast jeder Anwendung wird an eine Suchmaschine im
; Internet weitergeben. Mit Win+W ruft man den Dialog auf, wo man entscheiden
; kann, bei welcher Suchmaschine gesucht werden soll. Der Dialog enthlt
; ein Bearbeiten-Men, wo sich Eintrge bearbeiten, hinzufgen und lschen
; lassen. Im Bearbeiten/Hinzufgen-Dialog wird dabei automatisch das Favicon
; ermitteln und ggf. runtergeladen. Zum schnellen Zugriff auf die
; Suchmaschinen kann man sie mit Alt-Krzeln belegen. Dazu muss man ein &
; vor dem gewnschten Buchstaben stellen. Z.B. G&oogle bedeutet, dass man
; mit Alt+o darauf zugreifen kann. Alle Einstellungen und Icons werden im
; Unterordner WebSearch abgelegt. Die Option, dass der Suchbegriff kodiert
; weitergegeben wird, ist nur fr Opera ntzlich, wenn es Probleme mit
; der bertragung von Umlauten gibt. Mchte man die Suchergebnis in einem
; anderen als den Standardbrowser anzeigen lassen, kann man das im Bearbeiten-
; Men einstellen.
;
; Win+W              - Starten den Dialog zu WebSearch
; oder CapsLock+#

; *** Nederlands **************************************************************

; Gemarkeerde tekst kan vanuit bijna elk programma worden doorgegeven aan een
; zoekmachine op internet. Met Win+W roep je het venster op waarin je de
; zoekmachine kunt kiezen. Het venster bevat een Bewerken-menu waarin je zoekmachines
; kunt bewerken, toevoegen en wissen. In het bewerken/toevoegen-venster
; wordt hierbij automatisch het favicon opgezocht en eventueel gedownload.
; Om sneller toegang te hebben tot de zoekmachines kun je er Alt-
; sneltoetsen voor aanmaken. Hiervoor moet je een & voor de gewenste letter
; zetten. G&oogle betekent bijvoorbeeld dat je deze zoekmachine met Alt-o aanspreekt.
; Alle instellingen en icons worden in de subdirectory WebSearch opgeslagen.
; De optie om de zoekterm gecodeerd door te geven is eigenlijk alleen nuttig
; voor Opera, als zich problemen zouden voordoen met het coderen van diacritische
; tekens. Als je het zoekresultaat met een andere dan de standaardbrowser
; wilt bekijken kun je dit in het Bewerken-menu instellen.
;
; Win+W        - Start het venster voor WebSearch op

; #################################################################EndHeader###

;---WebSearch--------------------------------:;------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ======================================================wr==
; -----------------------------------------------------------------------------

init_WebSearch:
   Prefix = wr
   %Prefix%_ScriptName    = WebSearch
   %Prefix%_ScriptVersion = 0.6
   %Prefix%_ScriptTitle   = %wr_ScriptName% v%wr_ScriptVersion%

   wr_IconPath = %wr_ScriptName%

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName = %wr_ScriptName% - Internet-Recherche`tWin+W
      lng_wr_WebRecherche = Internet&-Recherche fr:
      lng_wr_Add          = &Hinzufgen ...
      lng_wr_Edit         = &Bearbeiten
      lng_wr_Exit         = Schlieen
      lng_wr_EntryName    = Menname: (&& fr Alt-Krzel):
      lng_wr_EntryURL     = URL: (### = Platzhalter fr Suchbegriff)
      lng_wr_Cancel       = &Abbrechen
      lng_wr_OK           = &OK
      lng_wr_DelEntry     = &Eintrag entfernen
      lng_wr_EditEntry    = Eintrag bearbeiten
      lng_wr_NoSymbols    = Der Platzerhalter (###) fr den Suchbegriff fehlt!
      lng_wr_ErrCRLF      = Zeilenschaltungen (Return/Enter) sind nicht erlaubt, `nsie werden nun automatisch entfernt!
      lng_wr_Encoding     = Umlaute und Sonderzeichen kodieren:
      lng_wr_URLencode    = URL ( > `%F6)
      lng_wr_Unicode      = Unicode
      lng_wr_NoEncode     = nein
      lng_wr_MenuBrowser  = &Browser auswhlen ...
      lng_wr_Browser      = Welcher Browser soll verwendet werden? (z.B. ob1.exe)`nWird hier nichts angegeben, wird der Standardbrowser verwendet.
      lng_wr_SelectBrowser = Bitte einen Browser auswhlen
      lng_wr_FileTypeEXE   = Programme (*.exe)
      lng_wr_UpdateCFG     = Wegen der neuen Mglichkeiten von %wr_ScriptName% sollte die Konfigurations-Datei mit den Suchmaschinen (URLs.cfg) neu angelegt werden.`nAlle manuell hinzugefgte URLs werden gelscht. Von der alten Konfigurations-Datei wird aber eine Sicherung (URLs.bak) angelegt.
   }
   else if Lng = 13  ; = Nederlands
   {
      MenuName = %wr_ScriptName% - Op Internet zoeken`tWin+W
      lng_wr_WebRecherche = Op Internet &zoeken:
      lng_wr_Add          = &Toevoegen ...
      lng_wr_Edit         = &Bewerken
      lng_wr_Exit         = Sluiten
      lng_wr_EntryName    = Menunaam: (&& voor Alt-sneltoets):
      lng_wr_EntryURL     = URL: (### = vervangt zoekbegrip)
      lng_wr_Cancel       = &Afbreken
      lng_wr_OK           = &OK
      lng_wr_DelEntry     = &Zoekmachine verwijderen
      lng_wr_EditEntry    = Zoekmachine bewerken
      lng_wr_NoSymbols    = De placeholder (###) voor de zoekterm ontbreekt!
      lng_wr_ErrCRLF      = Regelafbrekingen (Return/Enter) zijn niet toegestaan, `ndeze worden automatisch verwijderd!
      lng_wr_Encoding     = Trema's en speciale tekens coderen:
      lng_wr_URLencode    = URL ( > `%F6)
      lng_wr_Unicode      = Unicode
      lng_wr_NoEncode     = Nee
      lng_wr_MenuBrowser  = B&rowser kiezen ...
      lng_wr_Browser      = Welke browser moet worden gebruikt? (Bijv. ob1.exe)`nAls hier niets staat wordt de standaardbrowser gebruikt.
      lng_wr_SelectBrowser = Kies een browser
      lng_wr_FileTypeEXE   = Programma's (*.exe)
      lng_wr_UpdateCFG     = Vanwege de nieuwe opties van %wr_ScriptName% moet het configuratiebestand met de zoekmachines (URLs.cfg) opnieuw worden aangemaakt.`nAlle handmatig toegevoegde URL's worden verwijderd! Het oude configuratiebestand wordt naar een back-upbestand (URLs.bak) weggeschreven.
   }
   else        ; = other languages (english)
   {
      MenuName = %wr_ScriptName% - web search`tWin+W
      lng_wr_WebRecherche = web&-search for:
      lng_wr_Add          = &Add ...
      lng_wr_Edit         = &Edit
      lng_wr_Exit         = Close
      lng_wr_EntryName    = menuname: (&& for alt-hotkey):
      lng_wr_EntryURL     = URL: (### = search-word)
      lng_wr_Cancel       = &Cancel
      lng_wr_OK           = &OK
      lng_wr_DelEntry     = &delete entry
      lng_wr_EditEntry    = Edit entry
      lng_wr_NoSymbols    = The symbols (###) for the search-word are missing!
      lng_wr_ErrCRLF      = Return/Enter is not allowed, `nthey will be removed now!
      lng_wr_Encoding     = Encode umlauts and special chars:
      lng_wr_URLencode    = URL ( > `%F6)
      lng_wr_Unicode      = Unicode
      lng_wr_NoEncode     = no
      lng_wr_MenuBrowser  = select &browser ...
      lng_wr_Browser      = Which browser should handle the search? (eg. ob1.exe)`nLeave empty to use the standard-browser.
      lng_wr_SelectBrowser = Please select a browser
      lng_wr_FileTypeEXE   = Programs (*.exe)
      lng_wr_UpdateCFG     = Due to new capabilities of %wr_ScriptName% the config-file (URLs.cfg) should be recreated.`nAll added urls will be deleted. A backup of the old config-file (URLs.bak) will be created.
   }

   wr_Name[1] =
   wr_ItemNr = 1

   ; Update von 0.8
   IfExist, WebResearch
   {
      FileCreateDir, %wr_IconPath%
      FileMove, WebResearch\*.*, %wr_IconPath%\, 1
      FileRemoveDir, WebResearch
      IfExist, %wr_IconPath%\URLs.cfg
      {
         MsgBox, 36, %wr_ScriptTitle%, %lng_wr_UpdateCFG%
         IfMsgBox,yes
         {
            FileMove, %wr_IconPath%\URLs.cfg, %wr_IconPath%\URLs.bak
         }
      }
      FileAppend, null, update.zip
   }

   Loop, Read, %wr_IconPath%\URLs.cfg
   {
      wr_Line ++

      If wr_Line = 1
         wr_Name[%wr_ItemNr%] = %A_LoopReadLine%

      If wr_Line = 2
      {
         wr_Url[%wr_ItemNr%] = %A_LoopReadLine%
         wr_Encode[%wr_ItemNr%] =
         IfInString, A_LoopReadLine, URL:
         {
            StringReplace, wr_Url[%wr_ItemNr%], wr_Url[%wr_ItemNr%], URL:
            wr_Encode[%wr_ItemNr%] = URL
         }
         IfInString, A_LoopReadLine, Unicode:
         {
            StringReplace, wr_Url[%wr_ItemNr%], wr_Url[%wr_ItemNr%], Unicode:
            wr_Encode[%wr_ItemNr%] = Unicode
         }
      }

      If wr_Line = 3
      {
         wr_Line = 0
         wr_ItemNr ++
      }
   }

   If wr_Name[1] =
   {
      if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
      {
         wr_Name[1]   = &LEO
         wr_URL[1]    = http://dict.leo.org/?lp=ende&lang=de&searchLoc=0&cmpType=relaxed&relink=on&sectHdr=on&spellToler=std&search=###
         wr_Encode[1] = URL
         wr_Name[2]   = &Google
         wr_URL[2]    = http://www.google.de/search?hl=de&q=###&btnG=Google-Suche&meta=
         wr_Encode[2] = Unicode
         wr_Name[3]   = &Wikipedia
         wr_URL[3]    = http://de.wikipedia.org/wiki/###
         wr_Encode[3] =
         wr_Name[4]   = &Heise-Newsticker
         wr_URL[4]    = http://www.heise.de/newsticker/search.shtml?T=###
         wr_Encode[4] = URL
         wr_Name[5]   = &AutoHotkey-Forum
         wr_URL[5]    = http://www.autoHotkey.com/forum/search.php?search_terms=all&search_keywords=###
         wr_Encode[5] = URL
         wr_Name[6]   = &Deutsches Wrterbuch
         wr_URL[6]    = http://www.dwds.de/cgi-bin/portalL.pl?search=###
         wr_Encode[6] = URL
      }
      else if Lng = 13  ; = Nederlands
      {
         wr_Name[1]   = &Allwords Engels-Nederlands
         wr_URL[1]    = http://www.allwords.com/query.php?SearchType=0&Keyword=###&goquery=Find+it`%21&Language=ENG&NLD=1
         wr_Encode[1] = URL
         wr_Name[2]   = &Google
         wr_URL[2]    = http://www.google.nl/search?hl=nl&q=###
         wr_Encode[2] = Unicode
         wr_Name[3]   = &Wikipedia
         wr_URL[3]    = http://nl.wikipedia.org/wiki/###
         wr_Encode[3] =
         wr_Name[4]   = &FnL Nieuwsticker
         wr_URL[4]    = http://www.fnl.nl/search/search.cgi?q=###
         wr_Encode[4] = URL
         wr_Name[5]   = &AutoHotkey-Forum
         wr_URL[5]    = http://www.autoHotkey.com/forum/search.php?search_terms=all&search_keywords=###
         wr_Encode[5] = URL
         wr_Name[6]   = &IMDB
         wr_URL[6]    = http://www.imdb.com/find?q=###;tt=on;nm=on;mx=20
         wr_Encode[6] = URL
      }
      else        ; = other languages (english)
      {
         wr_Name[1]   = &LEO
         wr_URL[1]    = http://dict.leo.org/?lp=ende&lang=en&searchLoc=0&cmpType=relaxed&relink=on&sectHdr=on&spellToler=std&search=###
         wr_Encode[1] = URL
         wr_Name[2]   = &Google
         wr_URL[2]    = http://www.google.com/search?hl=nl&q=###
         wr_Encode[2] = Unicode
         wr_Name[3]   = &Wikipedia
         wr_URL[3]    = http://en.wikipedia.org/wiki/###
         wr_Encode[3] =
         wr_Name[4]   = &Techworld News
         wr_URL[4]    = http://www.techworld.com/search/index.cfm?thecriteria=###&fuseaction=dosearch&search_news=1
         wr_Encode[4] = URL
         wr_Name[5]   = &AutoHotkey-Forum
         wr_URL[5]    = http://www.autoHotkey.com/forum/search.php?search_terms=all&search_keywords=###
         wr_Encode[5] = URL
         wr_Name[6]   = &Dictionary
         wr_URL[6]    = http://dictionary.reference.com/search?q=###
         wr_Encode[6] = URL
      }
   }

   IniRead, wr_Browser, %ConfigFile%, %wr_ScriptName%, browser
   If wr_Browser = ERROR
      wr_Browser =

Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================wr==
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
wr_main_WebSearch:
   If wr_GuiActive = yes
   {
      Gosub, 7GuiClose
   }

   wr_temp = %ClipboardAll%
   Clipboard =
   Send, ^c
   ClipWait, 0.5, 1

   wr_searchFor = %Clipboard%

   IfExist, %wr_searchFor%
   {
      SplitPath, wr_searchFor, wr_searchFor
   }

   Clipboard = %wr_temp%
   wr_GuiActive = yes

   Gosub, wr_sub_SearchDialog
Return

; -----------------------------------------------------------------------------
wr_sub_SearchDialog:
   CoordMode, Mouse, Screen
   CoordMode, Caret, Screen

   If A_ThisHotkey contains #
   {
      wr_GuiY = %A_CaretY%
      wr_GuiX = %A_CaretX%
      If (wr_GuiY = 0 AND wr_GuiX =0)
         MouseGetPos, wr_GuiX, wr_GuiY
   }
   Else
   {
      MouseGetPos, wr_GuiX, wr_GuiY
   }

   Gui, 7:Add, Text, y+10 w200 , %lng_wr_WebRecherche%
   Gui, 7:Add, Edit, y+5 x8 w200 R1 -Multi vwr_searchFor, %wr_searchFor%

   Loop
   {
      If wr_Name[%A_Index%] =
         Break

      wr_ICO := wr_Name[%A_Index%]

      Gosub, wr_sub_CorrectIcoFilename

      wr_ICO = %wr_IconPath%\%wr_ICO%.ico
      wr_ICO[%A_Index%] = %wr_ICO%

      IfNotExist, %wr_ICO%
         wr_ICO =

      Gui, 7:Add, Pic,x8 y+10 w16 h16 vwr_picv%A_Index%,%wr_ICO%
      wr_picv = wr_picv%A_Index%

      GuiControlGet, wr_PicPos[%A_Index%] , 7:Pos, %wr_picv%
   }

   wr_Default = Default Focus

   Loop
   {
      If wr_Name[%A_Index%] =
         Break

      wr_X := wr_PicPos[%A_Index%]X + 20
      wr_Y := wr_PicPos[%A_Index%]Y - 3
      Gui, 7:Add, Button, x%wr_X% y%wr_Y% w180 h23 Left gwr_sub_Search %wr_Default% vwr_Button%A_Index%, % wr_Name[%A_Index%]

      wr_temp := wr_Name[%A_Index%]
      wr_temp = %wr_temp% ...
      Menu, wr_Bearbeiten, Add, %wr_temp% , wr_sub_EintragBearbeiten

      wr_Default =
      wr_Items = %A_Index%
   }

   Menu, wr_Bearbeiten, Add,
   Menu, wr_Bearbeiten, Add, %lng_wr_Add% , wr_sub_EintragHinzu
   Menu, wr_Bearbeiten, Add,
   Menu, wr_Bearbeiten, Add, %lng_wr_MenuBrowser% , wr_sub_Browser
   Menu, wr_Bearbeiten, Add,
   Menu, wr_Bearbeiten, Add, %lng_wr_Exit%, 7GuiExit
   Menu, wr_MenuBar, Add, %lng_wr_Edit%, :wr_Bearbeiten
   Gui, 7:Menu, wr_MenuBar
   Gui, 7:-MaximizeBox -MinimizeBox

   if wr_searchFor <>
      GuiControl, 7:Focus, wr_Button1

   Gui, 7:+LastFound
   Gui, 7:Show, AutoSize W200 x%wr_GuiX% y%wr_GuiY%, %wr_ScriptTitle%

   WinGetPos, wr_GuiX, wr_GuiY, wr_GuiW, wr_GuiH
   WinGetPos, ,wr_TaskBar,,,ahk_class Shell_TrayWnd

   SysGet, wr_ScreenW, 78
   SysGet, wr_ScreenH, 79

   If wr_TaskBar > 0
      wr_ScreenH := wr_TaskBar

   If (wr_GuiX + wr_GuiW > wr_ScreenW)
      wr_GuiX := wr_ScreenW - wr_GuiW
   If (wr_GuiY + wr_GuiH > wr_ScreenH)
      wr_GuiY := wr_ScreenH - wr_GuiH

   WinMove, wr_GuiX, wr_GuiY

   Gui, 8:+LastFound -SysMenu -MaximizeBox -MinimizeBox +Owner7
Return

; -----------------------------------------------------------------------------
wr_sub_CorrectIcoFilename:
   StringReplace, wr_ICO, wr_ICO, &,,A
   StringReplace, wr_ICO, wr_ICO, :,,A
   StringReplace, wr_ICO, wr_ICO, *,,A
   StringReplace, wr_ICO, wr_ICO, ?,,A
   StringReplace, wr_ICO, wr_ICO, \,,A
   StringReplace, wr_ICO, wr_ICO, /,,A
   StringReplace, wr_ICO, wr_ICO, `",,A
   StringReplace, wr_ICO, wr_ICO, <,,A
   StringReplace, wr_ICO, wr_ICO, >,,A
   StringReplace, wr_ICO, wr_ICO, |,,A
Return

; -----------------------------------------------------------------------------
wr_sub_Search:
   Gui, 7:Submit, NoHide

   StringReplace, wr_pressedButton, A_GuiControl, wr_Button,

   wr_URL := wr_URL[%wr_pressedButton%]

   if wr_Encode[%wr_pressedButton%] = URL
      Gosub, wr_sub_URLEncode

   if wr_Encode[%wr_pressedButton%] = Unicode
   {
      ClipBoard = %wr_searchFor%
      Transform, wr_searchFor, Unicode
      ClipBoard = %wr_temp%
   }

   StringReplace, wr_URL, wr_URL, ###, %wr_searchFor%
   If wr_Browser =
      Run, %wr_URL%,, UseErrorlevel
   Else
      Run, %wr_Browser% %wr_URL%,, UseErrorlevel

   Gui, 7:Destroy
   Menu, wr_Bearbeiten, DeleteAll
   Menu, wr_MenuBar, DeleteAll

   wr_GuiActive =
Return

; -----------------------------------------------------------------------------
7GuiEscape:
7GuiExit:
7GuiClose:
   Gui, 7:Destroy
   Menu, wr_Bearbeiten, DeleteAll
   Menu, wr_MenuBar, DeleteAll
   wr_GuiActive =
Return

; -----------------------------------------------------------------------------
wr_sub_EintragHinzu:
wr_sub_EintragBearbeiten:
   wr_Index := A_ThisMenuItemPos

   If A_ThisMenuItem = %lng_wr_Add%
      wr_Index := wr_Items + 1

   wr_URL   := wr_URL[%wr_Index%]
   wr_NAME  := wr_NAME[%wr_Index%]
   wr_ICO   := wr_ICO[%wr_Index%]
   wr_Encode:= wr_Encode[%wr_Index%]

   Gosub, wr_sub_UrlDialog

   Loop
   {
      Sleep, 100

      If wr_A_Gui <> 8
         Break
   }

   If wr_A_Gui = ok
   {
      FileDelete, %wr_ICO%
      wr_ICO = %wr_Name%

      Gosub, wr_sub_CorrectIcoFilename

      wr_ICO = %wr_IconPath%\%wr_ICO%.ico

      IfNotExist, %wr_IconPath%\
         FileCreateDir, %wr_IconPath%

      FileMove, %temp%\wr_temp.ico, %wr_ICO%,1
      FileMove, %temp%\wr_temp.ico, %wr_ICO%,1
      wr_URL[%wr_Index%]  = %wr_URL%
      wr_Name[%wr_Index%] = %wr_Name%
      wr_ICO[%wr_Index%]  = %wr_ICO%

      If wr_EncodeR1 = 1
         wr_Encode =
      If wr_EncodeR2 = 1
         wr_Encode = Unicode
      If wr_EncodeR3 = 1
         wr_Encode = URL

      wr_Encode[%wr_Index%] = %wr_Encode%

      Gosub, 7GuiClose
      Gosub, wr_sub_SearchDialog
   }
   Else If wr_A_Gui = del
   {
      FileDelete, %wr_ICO%
      wr_tempIndex = 1

      Loop
      {
         If wr_Name[%wr_tempIndex%] =
         {
            wr_URL[%A_Index%]  :=
            wr_Name[%A_Index%] :=
            wr_ICO[%A_Index%]  :=
            Break
         }

         If A_Index = %wr_Index%
            wr_tempIndex++

         wr_URL[%A_Index%]  := wr_URL[%wr_tempIndex%]
         wr_Name[%A_Index%] := wr_Name[%wr_tempIndex%]
         wr_ICO[%A_Index%]  := wr_ICO[%wr_tempIndex%]
         wr_Encode[%A_Index%]  := wr_Encode[%wr_tempIndex%]

         wr_tempIndex++
      }

      Gosub, 7GuiClose
      Gosub, wr_sub_SearchDialog
   }

   FileDelete, %wr_IconPath%\URLs.cfg

   Loop
   {
      If ( wr_Name[%A_Index%] = "" )
         Break

      wr_Name := wr_Name[%A_Index%]
      wr_Encode := wr_Encode[%A_Index%]
      wr_URL := wr_URL[%A_Index%]

      If wr_Encode <>
         wr_URL =  %wr_Encode%:%wr_URL%

      FileAppend,%wr_Name%`n,%wr_IconPath%\URLs.cfg
      FileAppend,%wr_URL%`n`n,%wr_IconPath%\URLs.cfg
   }
Return

; -----------------------------------------------------------------------------
wr_sub_UrlDialog:
   Gui, 7:+Disabled
   Gui, 8:Add, Text, y+10, %lng_wr_EntryName%
   Gui, 8:Add, Edit, y+3 x8 w200 R1 -Multi vwr_NAME Disabled, %wr_NAME%
   Gui, 8:Add, Text,, %lng_wr_EntryURL%
   Gui, 8:Add, Picture, x445 yp+23 w16 h16 vwr_FavIcon, %wr_ICO%
   Gui, 8:Add, Edit, yp-2 x8 w430 R3 -WantReturn vwr_URL Disabled Section, %wr_URL%

   Gui, 8:Add, Text, y+5, %lng_wr_Encoding%
   If wr_Encode =
      Gui, 8:Add, Radio, yp+0 x+6 vwr_EncodeR1 Checked, %lng_wr_NoEncode%
   Else
      Gui, 8:Add, Radio, yp+0 x+6 vwr_EncodeR1, %lng_wr_NoEncode%

   If wr_Encode = Unicode
      Gui, 8:Add, Radio, x+6 vwr_EncodeR2 Checked, %lng_wr_Unicode%
   Else
      Gui, 8:Add, Radio, x+6 vwr_EncodeR2, %lng_wr_Unicode%

   If wr_Encode = URL
      Gui, 8:Add, Radio, x+6 vwr_EncodeR3 Checked, %lng_wr_URLencode%
   Else
      Gui, 8:Add, Radio, x+6 vwr_EncodeR3, %lng_wr_URLencode%

   If wr_Items = 1
      Gui, 8:Add, Button, y+13 x8 w190 gwr_sub_Delete Disabled, %lng_wr_DelEntry%
   Else
      Gui, 8:Add, Button, y+13 x8 w190 gwr_sub_Delete, %lng_wr_DelEntry%

   Gui, 8:Add, Button, yp+0 x270 w80 g8GuiClose, %lng_wr_Cancel%
   Gui, 8:Add, Button, yp+0 x+8 w80 Default g8GuiOk, &OK
   Gui, 8:+LastFound -MaximizeBox -MinimizeBox +Owner
   Gui, 8:Show, AutoSize, %lng_wr_EditEntry%

   wr_A_Gui = 8
   SetTimer, wr_sub_AutoFavicon, 500
Return

; -----------------------------------------------------------------------------
wr_sub_Delete:
   Gosub, 8GuiClose
   wr_A_Gui = del
Return

; -----------------------------------------------------------------------------
8GuiOk:
   Gui, 8:Submit, NoHide

   IfNotInString, wr_URL, ###
   {

      MsgBox, %lng_wr_NoSymbols%
      Return

   }

   If wr_URL contains `r,`n
   {

      MsgBox, %lng_wr_ErrCRLF%
      StringReplace,wr_URL,wr_URL,`r,,All
      StringReplace,wr_URL,wr_URL,`n,,All
      GuiControl,8:,wr_URL,%wr_URL%
      Return

   }

   Gosub, 8GuiClose
   wr_A_Gui = ok
Return

; -----------------------------------------------------------------------------
8GuiClose:
8GuiEscape:
8GuiExit:
   SetTimer, wr_sub_AutoFavicon, Off
   Gui, 7:-Disabled
   Gui, 8:Destroy
   wr_lastDomain =
   wr_A_Gui =
Return

wr_sub_AutoFavicon:
   GuiControlGet,wr_tempDomain,8:,wr_URL

   IfNotInString, wr_tempDomain, http://
   {
      IfNotInString, wr_tempDomain, https://
      {
         GuiControl,8:,wr_URL,http://%wr_tempDomain%
         Send,{End}
         Return

      }
   }

   StringGetPos, wr_Pos, wr_tempDomain, /, L3
   StringGetPos, wr_Pos2, wr_tempDomain, /, L4
   StringLeft, wr_tempDomain, wr_tempDomain, %wr_Pos%

   If ( wr_lastDomain <> wr_tempDomain and wr_Pos > 6 and wr_Pos > 8 )
   {
      ; Favicon von Root laden
      URLDownloadToFile,%wr_tempDomain%/favicon.ico,%temp%\wr_temp.ico
      if ErrorLevel = 0
      {
         FileRead, wr_temp, %temp%\wr_temp.ico

         IfInString, wr_temp, <html>
            FileDelete, %temp%\wr_temp.ico
      }
      Else
      {
         FileDelete, %temp%\wr_temp.ico
      }

      ; Wenn kein Favicon auf Root, dann prfe den Quelltext der Startseite
      ; auf ein <link rel="SHORTCUT ICON" und extrahiere Url
      IfNotExist, %temp%\wr_temp.ico
      {
         URLDownloadToFile,%wr_tempDomain%,%temp%\wr_temp.htm
         if ErrorLevel = 0
         {
            Loop, Read, %temp%\wr_temp.htm
            {
               IfInString, A_LoopReadLine, </head>
                  Break
               IfInString, A_LoopReadLine, <body>
                  Break

               IfInString, A_LoopReadLine, <link
               IfInString, A_LoopReadLine, SHORTCUT ICON
               {
                  wr_FavURL = %A_LoopReadLine%
                  StringGetPos, wr_Pos, wr_FavURL, href
                  StringMid, wr_FavURL, wr_FavURL, % wr_Pos + 4, 255
                  StringGetPos, wr_Pos, wr_FavURL, "
                  StringMid, wr_FavURL, wr_FavURL, % wr_Pos + 2, 255
                  StringGetPos, wr_Pos, wr_FavURL, "
                  StringMid, wr_FavURL, wr_FavURL, 1, %wr_Pos%

                  IfNotInstring, wr_FacURL, http
                     wr_FavURL = %wr_tempDomain%/%wr_FavURL%

                  StringReplace, wr_FavURL, wr_FavURL, //,/,A
                  StringReplace, wr_FavURL, wr_FavURL, :/,://,A

                  URLDownloadToFile,%wr_FavURL%, %temp%\wr_temp.ico
                  if ErrorLevel = 0
                  {
                     FileRead, wr_temp, %temp%\wr_temp.ico

                     IfInString, wr_temp, <html>
                        FileDelete, %temp%\wr_temp.ico
                  }
                  Else
                  {
                     FileDelete, %temp%\wr_temp.ico
                  }
               }
            }
            FileDelete, %temp%\wr_temp.htm
         }
         Else
         {
            FileDelete, %temp%\wr_temp.ico
         }
      }

      GuiControl,8:,wr_FavIcon,%temp%\wr_temp.ico
   }
   GuiControl, 8:Enable, wr_Name
   GuiControl, 8:Enable, wr_URL

   wr_lastDomain = %wr_tempDomain%
Return

; URLEncode
wr_sub_URLEncode:
   SetFormat, integer, hex
   StringReplace, wr_searchFor, wr_searchFor, %A_Space%, `%20
   Loop, 127
   {
      wr_HexCode := A_Index+127
      Transform, wr_HighChar, Chr, %wr_HexCode%
      StringReplace, wr_HexCode, wr_HexCode, 0x,`%
      StringReplace, wr_searchFor, wr_searchFor, %wr_HighChar%, %wr_HexCode%
   }
   SetFormat, integer, dec
Return

; -----------------------------------------------------------------------------
wr_sub_Browser:
   Gui, 7:+Disabled
   Gui, 8:Add, Text, y+10, %lng_wr_Browser%
   Gui, 8:Add, Edit, y+8 x8 w400 R1 -Multi vwr_Browser, %wr_Browser%
   Gui, 8:Add, Button, yp+0 x+5 w100 gwr_sub_SelectBrowser, %lng_Select%

   Gui, 8:Add, Button, x180 w80 g8GuiClose, %lng_wr_Cancel%
   Gui, 8:Add, Button, yp+0 x+8 w80 Default gwr_sub_SetOptions, &OK
   Gui, 8:+LastFound -MaximizeBox -MinimizeBox +Owner
   Gui, 8:Show, AutoSize, %wr_ScriptTitle% - Browser

   wr_A_Gui = 8
Return

wr_sub_SelectBrowser:
   wr_Suspended = %A_IsSuspended%
   If wr_Suspended = 0
      Suspend, On

   FileSelectFile, wr_Browser,, %A_Programfiles%, %lng_wr_SelectBrowser%, %lng_wr_FileTypeEXE%
   ControlSetText, Edit1, %wr_Browser%, %wr_ScriptTitle% - Browser

   If wr_Suspended = 0
      Suspend, Off
Return

wr_sub_SetOptions:
   Gui, 8:Submit
   Gosub, 8GuiClose
   Gui, 7:-Disabled

   IniWrite, %wr_Browser%, %ConfigFile%, %wr_ScriptName%, browser

   WinActivate, %wr_ScriptTitle%
   wr_A_Gui = ok
Return
;<---WebSearch---

;---LikeDirkey--->
; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               LikeDirkey
; -----------------------------------------------------------------------------
; Prefix:             ld_
; Version:            0.6
; Date:               2005-04-20
; Author:             Wolfgang Reszel fr c't
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Mit LikeDirkey kann man die Tasten Win+0 - Win+9 und Strg+0 - Strg+9
; mit Verzeichnissen belegen. Ruft man ein Win-Krzel auf, wird immer
; ein neues Explorer-Fenster geffnet.
; Bei Strg wird versucht im entsprechenden Fenster das Verzeichnis zu
; wechseln. Mit Strg+Win+0 - 9 kann man direkt aus dem
; Explorer die Tasten neu belegen. Es heit LikeDirkey, weil es ein hnliches
; Freeware-Tool namens Dirkey gibt.
; Damit das Skript mit NiftyWindows zusammenarbeitet, sind standardmig nur
; die Zahlen des Ziffernblocks zu verwenden. Man kann das aber im Tray-Men
; auf die Ziffernreihe umkonfigurieren.
;
; Win + 0-9      - Explorer mit dem gespeicherten Ordner ffnen
;
; Strg + 0-9     - Im aktuellen Fenster zum gespeicherten Ordner wechseln
;
; Strg+Win + 0-9 - Speichert den aktuellen Ordner auf ein Krzel
;                  (nur im Explorer)

; *** Nederlands **************************************************************

; Met LikeDirkey kun je de toetsen Win+0 t/m Win+9 en Ctrl+0 t/m Ctrl+9
; aan mappen koppelen. Als je een Win-cijfercombinatie oproept, wordt altijd
; een nieuw Verkenner-venster geopend.
; Bij Ctrl wordt geprobeerd om in het actieve venster naar de map
; te gaan. Met Ctrl+Win+0 t/m 9 kun je direct vanuit de Verkenner
; de toetsen herprogrammeren. We hebben als naam LikeDirkey gegeven, omdat er
; een vergelijkbare freeware-tool bestaat met de naam Dirkey.
; Als je het script met NiftyWindows wilt laten samenwerken, mag je standaard
; alleen de cijfers van het numerieke toetsenboard gebruiken. Je kunt in het
; tray-menu aangeven dat je de cijfers bovenaan je toetsenbord wilt gebruiken.
;
; Win + 0 t/m 9    - Verkenner met de opgeslagen map openen
;
; Ctrl + 0 t/m 9   - In het huidige venster naar de map gaan
;
; Ctrl+Win+0 t/m 9 - Koppel de huidige map aan een sneltoets
;                    (Alleen in de Verkenner)

; #################################################################EndHeader###

;---LikeDirkey---------------------------------:;------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ======================================================ld==
; -----------------------------------------------------------------------------

init_LikeDirkey:
   Prefix = ld
   %Prefix%_ScriptName    = LikeDirkey
   %Prefix%_ScriptVersion = 0.6

   SubMenu          = LikeDirkey_Menu  ; ID des Untermens

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName              = %ld_ScriptName% - Ordnerkrzel`tStrg/Win 0-9
      LikeDirkey_EnableMenu = %ld_ScriptName% aktiviert

      lng_ld_MenuNumPad     = Krzel auf Ziffernblock
      lng_ld_MenuFolderTree = Explorer mit Verzeichnisbaum ffnen

      lng_ld_NoDialog       = Das Setzen eines Verzeichnisses funktioniert nicht in Dialogen!
      lng_ld_FolderOptions  = Verzeichnis kann nicht ermittelt werden.`nin den Ordneroptionen muss eingestellt werden, `ndass im Fenstertitel oder in der Adressleiste der vollstndige Pfad angezeigt wird.
   }
   else if Lng = 13  ; = Nederlands
   {
      MenuName              = %ld_ScriptName% - Snelmap`tCtrl/Win 0-9
      LikeDirkey_EnableMenu = %ld_ScriptName% actief

      lng_ld_MenuNumPad     = Sneltoetsencombinatie met numeriek toetsenbord
      lng_ld_MenuFolderTree = Open Verkenner met directory tree

      lng_ld_NoDialog       = Je kunt in een dialoogvenster geen map selecteren!
      lng_ld_FolderOptions  = Kan map niet bepalen.`nIn de mapopties moet ingesteld zijn`ndat in de venstertitel of in de adresbalk het complete pad wordt weergegeven.
   }
   else        ; = other languages (english)
   {
      MenuName              = %ld_ScriptName% - folder-hotkeys`tCtrl/Win 0-9
      LikeDirkey_EnableMenu = %ld_ScriptName% active

      lng_ld_MenuNumPad     = Hotkeys on numeric pad
      lng_ld_MenuFolderTree = open explorer with folder-tree

      lng_ld_NoDialog       = Folders can not be stored from dialogs!
      lng_ld_FolderOptions  = Please activate full paths for title-bar or address-bar in the folder-options!
   }

   ; fr die Verwendung innerhalb das Skripts
   ld_SubMenu   = %SubMenu%
   ld_MenuName  = %MenuName%

   Menu, %ld_SubMenu%, Add, %LikeDirkey_EnableMenu%, sub_MenuCall
   Menu, %ld_SubMenu%, Add
   Menu, %ld_SubMenu%, Add, %lng_ld_MenuNumPad%, ld_sub_MenuNumPad
   IniRead, ld_onNumPad, %ConfigFile%, %ld_ScriptName%, NumPad
   if ld_onNumPad = ERROR
      ld_onNumPad = yes

   if ld_onNumPad = yes
   {
      ld_NumPadPrefix = NumPad
      Menu, %ld_SubMenu%, Check, %lng_ld_MenuNumPad%
   }
   Else
   {
      ld_NumPadPrefix =
      Menu, %ld_SubMenu%, UnCheck, %lng_ld_MenuNumPad%
   }

   Menu, %ld_SubMenu%, Add, %lng_ld_MenuFolderTree%, ld_sub_MenuFolderTree
   IniRead, ld_FolderTree, %ConfigFile%, %ld_ScriptName%, FolderTree
   if ld_FolderTree = ERROR
      ld_FolderTree = no

   if ld_FolderTree = yes
      Menu, %ld_SubMenu%, Check, %lng_ld_MenuFolderTree%
   Else
      Menu, %ld_SubMenu%, UnCheck, %lng_ld_MenuFolderTree%

   ; Belegung aus Datei einlesen
   Loop, 10
   {
      ld_Index := A_Index - 1
      IniRead, ld_Folder[%ld_Index%], %ConfigFile%, %ld_ScriptName%, Folder[%ld_Index%]
   }

   if (ld_Folder[0] = "ERROR" AND ld_Folder[1] = "ERROR") ; Wenn Definition nicht exisitert > Standardbelegung
   {
      ld_Folder[1] = C:\
      ld_Folder[2] = D:\
      ld_Folder[3] =
      ld_Folder[4] = %A_Desktop%
      ld_Folder[5] = HKEY_LOCAL_MACHINE,SOFTWARE\AutoHotkey,InstallDir
      ld_Folder[6] =
      ld_Folder[7] =
      ld_Folder[8] =
      ld_Folder[9] = %A_Programfiles%
      ld_Folder[0] = %A_ScriptDir%
   }

   ; Alle 10 Strings aus Pseudo-Array mit Krzeln belegen
   Loop, 10
   {
      ld_Index :=  A_Index -1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      ld_KeyName = %ld_NumPadPrefix%%ld_Index%

      If ld_current <> ; Wenn nicht leer
      {
         Hotkey, ~^%ld_KeyName%, ld_main_LikeDirkey_call ; Strg+ Krzel zuweisen
         Hotkey, #%ld_KeyName% , ld_main_LikeDirkey_call ; Win+ Krzel zuweisen
      }

      Hotkey, ~^#%ld_KeyName% , ld_main_LikeDirkey_set ; Strg+Win+ Krzel zuweisen
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================ld==
; -----------------------------------------------------------------------------

; --- Unterroutine fr Tastaturkrzel -----------------------------------------
ld_main_LikeDirkey_call:
   If Enable_LikeDirkey = yes
   {
      StringRight, ld_keyIndex, A_ThisHotkey, 1 ; Nur die Zahl des Krzels
      ld_path := ld_Folder[%ld_keyIndex%] ; Pfad auslesen

      StringLeft, ld_check, ld_path, 5

      If ld_check = HKEY_
      {
         StringSplit, ld_path, ld_path, `,
         RegRead, ld_path, %ld_path1%,%ld_path2%,%ld_path3%
      }

      StringLeft, ld_check, ld_path, 1

      If ld_check = `%
      {
         StringReplace, ld_path, ld_path, `% ,, A
         ld_path := %ld_path%
      }

      GetKeyState, ld_ctrlState, Ctrl ; Status der Strg-Taste ermitteln

      Gosub, ld_sub_ChangeDir ; Verzeichniswechsel aufrufen
   }
Return

; --- Unterroutine fr Tastaturkrzel-Belegung -------------------------------
ld_main_LikeDirkey_set:
   if Enable_LikeDirkey = yes
   {
      StringRight, ld_keyIndex, A_ThisHotkey, 1 ; Nur die Zahl des Krzels
      Gosub, ld_sub_SetDir ; Verzeichniswechsel aufrufen

      If ld_path <>
      {
         IfExist, %ld_path%
         {
            ld_Folder[%ld_keyIndex%] = %ld_path%

            SetTimer, ld_sub_ToolTip, 10

            Hotkey, ~^%ld_NumPadPrefix%%ld_keyIndex%, ld_main_LikeDirkey_call ; Strg+ Krzel zuweisen
            Hotkey, #%ld_NumPadPrefix%%ld_keyIndex% , ld_main_LikeDirkey_call ; Win+ Krzel zuweisen

            Loop, 10
            {
               ld_Index := A_Index - 1
               IniWrite, % ld_Folder[%ld_Index%], %ConfigFile%, %ld_ScriptName%, Folder[%ld_Index%]
            }

            Sleep,2500

            SetTimer, ld_sub_ToolTip, Off

            ToolTip
         }
      }
   }

Return

; -----------------------------------------------------------------------------
ld_sub_ToolTip:
   ToolTip, Krzel %ld_keyIndex% wurde neu belegt: %ld_path%, 4,4
Return

; --- Unterroutine fr den Verzeichniswechsel ---------------------------------
ld_sub_ChangeDir:
   WinGet     , ld_activeWinID, ID, A             ; ID es aktiven Fensters
   WinGetClass, ld_activeClass, ahk_id %ld_activeWinID%  ; Fensterklasse ermitteln

   ; Prfen ob Fensterklasse untersttzt wird
   If ld_activeClass contains #32770,ExploreWClass,CabinetWClass,Afx:400000:0,FileZilla Main Window,bosa_sdm
   {
      ; Ermitteln ob ein Edit1-Control vorhanden ist (Eingabezeile)
      ld_EditClass = Edit1
      ControlGetPos, ld_Edit1Pos,,,, %ld_EditClass% , ahk_id %ld_activeWinID%
   }

   If ld_Edit1Pos =  ; Wenn kein Edit1-Control gefunden ...
   {
      ; Ermitteln ob ein RichEdit-Control vorhanden ist (MS-Office)
      ld_EditClass = RichEdit20W2
      ControlGetPos, ld_Edit1Pos,,,, %ld_EditClass% , ahk_id %ld_activeWinID%
   }

   FileGetAttrib, ld_isFolder, %ld_path%

   If ld_ctrlState = D ; wenn Strg-Taste gedrckt ...
   {
      IfNotInString, ld_isFolder, D
         Return

      ; Verzeichnis in Dateidialogen wechseln
      If ld_activeClass contains #32770,bosa_sdm
      {
         If ld_Edit1Pos <>
         {
            WinActivate ahk_id %ld_activeWinID%
            ControlGetText, ld_text, %ld_EditClass%, ahk_id %ld_activeWinID%
            ControlSetText, %ld_EditClass%, %ld_path%, ahk_id %ld_activeWinID%
            WinGet,ld_Process, ProcessName, ahk_id %ld_activeWinID%
            If ld_Process in WinRar.exe
               Return
            ControlSend   , %ld_EditClass%, {Enter} , ahk_id %ld_activeWinID%
            Sleep, 100
            ControlSetText, %ld_EditClass%, %ld_text%, ahk_id %ld_activeWinID%
            Return
         }
      }
      ; Verzeichnis in Explorer-Fenstern wechseln
      Else If ld_activeClass in ExploreWClass,CabinetWClass
      {
         If ld_Edit1Pos <>
         {
            ControlSetText, Edit1, %ld_path%      , ahk_id %ld_activeWinID%
            ControlSend   , Edit1, {Right}{Enter}, ahk_id %ld_activeWinID%
            Return
         }
      }
      ; Verzeichnis in AcdSee wechseln
      Else If ld_activeClass = Afx:400000:0
      {
         If ld_Edit1Pos <>
         {
            ControlSetText, Edit1, %ld_path%, ahk_id %ld_activeWinID%
            ControlSend   , Edit1, {Enter} , ahk_id %ld_activeWinID%
            Return
         }
      }
      ; Verzeichnis in FireFox wechseln
      Else If ld_activeClass = FileZilla Main Window
      {
         If ld_Edit1Pos <>
         {
            ControlSetText, Edit1, %ld_path%, ahk_id %ld_activeWinID%
            ControlSend   , Edit1, {Enter} , ahk_id %ld_activeWinID%
            Return
         }
      }
      ; Verzeichnis in der Eingabeaufforderung wechseln
      Else If ld_activeClass = ConsoleWindowClass
      {
         WinGetActiveTitle, wTitle

         If wTitle contains cmd.exe
         {
            WinActivate, ahk_id %ld_activeWinID%
            SetKeyDelay, 0

            IfInString, ld_path, :
            {
               StringLeft, ld_path_Drive, ld_path, 1
               Send %ld_path_Drive%:{Enter}
            }

            Send, cd %ld_path%{Enter}
            Return
         }
      }
   }
   Else
   {
      ; Wenn Windows-Taste gedrckt (fhrt auch Programme aus)
      IfExist, %ld_path%
      {
         FileGetAttrib, ld_isDir, %ld_path%
         If ( ld_isDir contains "D" AND ld_FolderTree = "yes")
            Run, explorer /e`,%ld_path%
         Else
            Run, %ld_path%
      }
   }
Return

; --- Unterroutine zum Setzen eines neuen Verzeichnisses ----------------------
ld_sub_SetDir:
   ld_path =
   WinGet     , ld_activeWinID, ID, A             ; ID es aktiven Fensters
   WinGetClass, ld_activeClass, ahk_id %ld_activeWinID%  ; Fensterklasse ermitteln

   If ld_activeClass = #32770
   {
      MsgBox,16, %ld_ScriptName% %ld_ScriptVersion%, %lng_ld_NoDialog%
      Return
   }

   ; Prfen ob Fensterklasse untersttzt wird
   If ld_activeClass contains ExploreWClass,CabinetWClass,Afx:400000:0,FileZilla Main Window,bosa_sdm
   {
      ; Ermitteln ob ein Edit1-Control vorhanden ist (Eingabezeile)
      ld_EditClass = Edit1
      ControlGetPos, ld_Edit1Pos,,,, %ld_EditClass% , ahk_id %ld_activeWinID%
   }

   ; Verzeichnis in Explorer-Fenstern wechseln
   If ld_activeClass in ExploreWClass,CabinetWClass,Progman
   {
      If ld_Edit1Pos <>
      {
         RegRead, ld_FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPath
         RegRead, ld_FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPathAddress

         ; Aktuellen Pfad anhand der Adressleiste ermitteln
         If ld_FullPath = 1
            WinGetTitle, ld_CurrentExplorerDirectory, ahk_class %ld_activeClass%

         If ld_FullPathAddress = 1
            ControlGetText, ld_CurrentExplorerDirectory, Edit1, ahk_class %ld_activeClass%

         If ld_activeClass = Progman
            ld_CurrentExplorerDirectory = %A_Desktop%

         Sleep,200

         If ld_CurrentExplorerDirectory =
         {
            MsgBox, 16, %ld_ScriptName% %ld_ScriptVersion%, %lng_ld_FolderOptions%
            Return
         }

         ld_path = %ld_CurrentExplorerDirectory%
         Return
      }
   }
   ; Verzeichnis aus AcdSee auslesen
   Else if ld_activeClass = Afx:400000:0
   {
      If ld_Edit1Pos <>
      {
         ControlGetText, ld_path, Edit1, ahk_id %ld_activeWinID%
         Return
      }
   }
   ; Verzeichnis aus FireFox auslesen
   Else if ld_activeClass = FileZilla Main Window
   {
      If ld_Edit1Pos <>
      {
         ControlGetText, ld_path, Edit1, ahk_id %ld_activeWinID%
         Return
      }
   }
Return

; --- Unterroutine fr das NumPad-Men ----------------------------------------
ld_sub_MenuNumPad:
   Loop, 10
   {
      ld_Index :=  A_Index -1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      ld_KeyName = %ld_NumPadPrefix%%ld_Index%

      If ld_current <> ; Wenn nicht leer
      {
         Hotkey, ~^%ld_KeyName%, Off ; Strg+ Krzel lschen
         Hotkey, #%ld_KeyName% , Off ; Win+ Krzel lschen
      }

      Hotkey, ~^#%ld_KeyName% , Off ; Strg+Shift+ Krzel lschen
   }


   If ld_onNumPad = no
   {
      ld_onNumPad = yes
      ld_NumPadPrefix = NumPad
      Menu, %ld_SubMenu%, Check, %lng_ld_MenuNumPad%
   }
   Else
   {
      ld_onNumPad = no
      ld_NumPadPrefix =
      Menu, %ld_SubMenu%, UnCheck, %lng_ld_MenuNumPad%
   }

   Loop, 10
   {
      ld_Index :=  A_Index -1
      ld_current := ld_Folder[%ld_Index%] ; Pfad auslesen

      ld_KeyName = %ld_NumPadPrefix%%ld_Index%

      If ld_current <> ; Wenn nicht leer
      {
         Hotkey, ~^%ld_KeyName%, ld_main_LikeDirkey_call ; Strg+ Krzel zuweisen
         Hotkey, #%ld_KeyName% , ld_main_LikeDirkey_call ; Win+ Krzel zuweisen
         Hotkey, ~^%ld_KeyName%, On
         Hotkey, #%ld_KeyName% , On
      }

      Hotkey, ~^#%ld_KeyName% , ld_main_LikeDirkey_set ; Strg+Shift+ Krzel zuweisen
      Hotkey, ~^#%ld_KeyName% , On
   }

   IniWrite, %ld_onNumPad%, %ConfigFile%, %ld_ScriptName%, NumPad
Return

; --- Unterroutine fr das Explorer-Leisten-Men ------------------------------
ld_sub_MenuFolderTree:
   If ld_FolderTree = no
   {
      ld_FolderTree = yes
      Menu, %ld_SubMenu%, Check, %lng_ld_MenuFolderTree%
   }
   Else
   {
      ld_FolderTree = no
      Menu, %ld_SubMenu%, UnCheck, %lng_ld_MenuFolderTree%
   }
   IniWrite, %ld_FolderTree%, %ConfigFile%, %ld_ScriptName%, FolderTree
Return
;<---LikeDirkey---


;---CommandLine--->
; -----------------------------------------------------------------------------
; #####################################################################Begin###
; -----------------------------------------------------------------------------
; Name:               CommandLine
; -----------------------------------------------------------------------------
; Prefix:             cl_
; Version:            0.3
; Date:               2005-03-21
; Author:             Wolfgang Reszel fr c't
;                     Nach einem Skript von Rajat
; Copyright:          2005 Heise Zeitschriften Verlag GmbH & Co. KG
; Testplatform:       WinXP
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
; --- Description -------------------------------------------------------------
; -----------------------------------------------------------------------------

; *** Deutsch *****************************************************************

; Tippt man in die Adresszeile des Explorers ein < gefolgt von einem Dos-Befehl
; ein, wird dieser in der Commando-Ebene ausgefhrt. Setzt man dem Befehl zwei
; << voran, wird dieser versteckt ausgefhrt.
;
; <         - in der Adresszeile des Explorers: Startet Kommandozeile
; <<        - in der Adresszeile des Explorers: Startet Kommandozeile und
;             fhrt den Befehl versteckt aus

; *** Nederlands **************************************************************

; Als je in de adresbalk van de Verkenner een vishaakje (<) intypt, gevolgd door een DOS-
; commando, wordt dit via de Opdrachtprompt van Windows uitgevoerd. Als je er twee vishaakjes
; voorzet, wordt het commando verstopt uitgevoerd.
;
; <         - in de adresbalk van de Verkenner: start Opdrachtprompt

; #################################################################EndHeader###

;---CommandLine--------------------------------:;------------------------------

; -----------------------------------------------------------------------------
; === Initialisation ======================================================cl==
; -----------------------------------------------------------------------------

init_CommandLine:
   Prefix = cl
   %Prefix%_ScriptName   = CommandLine
   %Prefix%_ScriptVersion = 0.3

   if Lng = 07  ; = Deutsch (0407, 0807, 0c07 ...)
   {
      MenuName = %cl_ScriptName% - Explorer Adressleiste als Kommandozeile`t<
      lng_cl_FolderOptions = In den Ordneroptionen muss eingestellt werden, `ndass im Fenstertitel oder in der Adressleiste der vollstndige Pfad angezeigt wird.
   }
   else if Lng = 13  ; = Nederlands
   {
      MenuName = %cl_ScriptName% - Verkenner-adresbalk als opdrachtprompt`t<
      lng_cl_FolderOptions = In de mapopties moet je aangegeven`ndat in de venstertitel of de adresbalk het complete pad wordt weergegeven.
   }
   else        ; = other languages (english)
   {
      MenuName = %cl_ScriptName% - use Explorer addressbar for shell-commands`t<
      lng_cl_FolderOptions = Please activate full paths for title-bar or address-bar in the folder-options!
   }
Return

; -----------------------------------------------------------------------------
; === Subroutines =========================================================cl==
; -----------------------------------------------------------------------------

; -----------------------------------------------------------------------------
cl_main_CommandLine_invoke:
   ControlGetFocus, cl_Control, A
   WinGetClass, cl_winClass, A
   WinGet, cl_winID, ID, A

   If cl_winClass in CabinetWClass,ExploreWClass
   {
      If cl_Control = Edit1
      {
         ControlGetText, cl_Command, Edit1, A

         StringLeft, cl_CmdLeft, cl_Command, 1
         StringLeft, cl_CmdLeft2, cl_Command, 2

         If (cl_CmdLeft <> "<" AND cl_CmdLeft2 <> "<<")
            Return

         Send,{ESC}

         RegRead, cl_FullPath, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPath
         RegRead, cl_FullPathAddress, HKCU,Software\Microsoft\Windows\CurrentVersion\Explorer\CabinetState,FullPathAddress

         If cl_FullPath = 1
         {
            WinGetTitle, cl_path, ahk_id %cl_winID%
            cl_path = %cl_path%
         }
         Else If cl_FullPathAddress = 1
         {
            If cl_path =
            {
               Send,^z
               Sleep,100
               ControlGetText, cl_path, Edit1, ahk_id %cl_winID%
               cl_path = %cl_path%
               Send,^z{Right}
            }
         }

         If cl_path =
         {
            BalloonTip(%cl_ScriptName% %cl_ScriptVersion%, %lng_cl_FolderOptions%, Error)
            Return
         }

         StringLeft, cl_CmdLeft, cl_Command, 2

         If (cl_CmdLeft = "<<")
         {
            StringTrimLeft, cl_Command, cl_Command, 2
            run, %comspec% /c %cl_Command%, %cl_path%, hide
         }
         Else
         {
            StringLeft, cl_CmdLeft, cl_Command, 1

            If (cl_CmdLeft = "<")
            {
               StringTrimLeft, cl_Command, cl_Command, 1
               run, %comspec% /k %cl_Command%, %cl_path%
            }
         }
      }
   }

   cl_path =
Return
;<---CommandLine---

