import sys
import psjobBasic as psjob
import photoshopy as pspy
comc = pspy.constants

class KontaktPsEnv(psjob.PhotoshopEnv):
  JPG_QUALITY = 11 # 0..12
  ARCHIVE_NAME = '-kontakt'
  def handleDocument(self, doc):
    print "%s..." % doc.Name
    assert len(doc.Layers) == 1
    # Farb-Verbesserungen
    ly = doc.ActiveLayer # ist von der Klasse ArtLayer
    ly.AutoLevels()
    ly.SelectiveColor(SelectionMethod=comc.psRelative,
        Reds=(0,50,50), Yellows=(0,0,100), Greens=(50,0,50), # (c,m,y)
        Cyans=(100,0,0), Blues=(50,50,0), Magentas=(0,100,0) )
    # Groesse anpassen; "fill-in" Methode, fuer 3:2-formatige Bilder
    if doc.Width > doc.Height:
        w, h, ar = 1795, 1205, doc.Width/doc.Height
    else:
        w, h, ar = 1205, 1795, doc.Height/doc.Width
    assert w>1000, "Bild zu klein: %sx%s" % (w,h)
    assert 1.4 < ar < 1.6, "AspectRatio %s (%s:%s) nicht 3:2" % (
        ar, doc.Width, doc.Height)
    # Groese anpassen mit 2x Nachschaerfen
    doc.ResizeImage(Width=w*2, Height=h*2, Resolution=300,
                    ResampleMethod=comc.psBicubic)
    ly.ApplyUnSharpMask(Amount=140, Radius=4, Threshold=0)
    doc.ResizeImage(Width=w, Height=h, Resolution=300,
                    ResampleMethod=comc.psBicubic)
    ly.ApplyUnSharpMask(Amount=140, Radius=2, Threshold=0)


job = KontaktPsEnv( (sys.argv[1], sys.argv[1]) ) # gleicher Speicherort
job.run()
