/*
 * Copyright 1998-2004 VIA Technologies, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef VIA_ACE_H
#define VIA_ACE_H

#ifdef __cplusplus
extern "C" {
#endif

// The Maximum Size for padlock_ace_alloc_buf is 64kb 
#define MAX_CIPHER_BUFFER_SIZE            (64 * 1024)


#define XFUNC  __asm _emit 0x0F __asm _emit 0xA7
#define XCRYPT __asm _emit 0xF3 XFUNC

#define XCRYPT_ECB XCRYPT __asm _emit 0xC8
#define XCRYPT_CBC XCRYPT __asm _emit 0xD0
#define XCRYPT_CTR XCRYPT __asm _emit 0xD8
#define XCRYPT_CFB XCRYPT __asm _emit 0xE0
#define XCRYPT_OFB XCRYPT __asm _emit 0xE8	

#define XCRYPT_F0 XFUNC __asm _emit 0xF0
#define XCRYPT_F8 XFUNC __asm _emit 0xF8

#define NEW_KEYS   __asm pushfd  __asm popfd

#define XSTORE XFUNC __asm _emit 0xC0
#define REPXSTORE __asm _emit 0xF3 XSTORE

#define PUSHREG __asm push eax __asm push ebx __asm push ecx __asm push edx __asm push esi __asm push edi
#define POPREG __asm pop edi __asm pop esi __asm pop edx __asm pop ecx __asm pop ebx __asm pop eax

#define  ENPREPAREREG_ECB \
		{\
			__asm	mov ecx, count  \
			__asm	mov edx, ctrl  \
			__asm	mov ebx, key  \
			__asm	mov esi, src  \
			__asm	mov edi, dst  \
		}
#define  ENPREPAREREG_OTHER \
		{\
			__asm	mov ecx, count  \
			__asm	mov edx, ctrl  \
			__asm	mov ebx, key  \
			__asm	mov eax, iv  \
			__asm	mov esi, src  \
			__asm	mov edi, dst  \
		}

#define NEH_GEN_KEY 	0x00000000	// generate key schedule
#define NEH_LOAD_KEY 	0x00000080	// load key schedule from memory

#define NEH_ENCRYPT 	0x00000000	// encryption
#define NEH_DECRYPT 	0x00000200	// decryption

#define NEH_KEY128 	0x000 + 0x00a	// 128 bit key
#define NEH_KEY192 	0x400 + 0x00c	// 192 bit key
#define NEH_KEY256 	0x800 + 0x00e	// 256 bit key

struct ace_aes_context
{
	ACE_AES_MODE mode;
	KEY_LENGTH key_length;
	unsigned char *iv;
	unsigned char last_iv[16];
	unsigned int encrypt_extended_key[60];
	unsigned int decrypt_extended_key[60];
};

struct aligned_memory_context
{
	int size;
	int offset;                     // the length of buf used
	unsigned char *temp_buf;
	unsigned char *p_alignedbuf;
};

#define ALIGN16(x) (unsigned char *)((((unsigned long)x) + 15 )&(~15UL))
#define UNALIGNED(addr) ((unsigned int)(addr) & 0x0000000F)

static __inline volatile void ace_ecb_op5(
				const void *key, 
				const void *ctrl, 
				const void *src, 
				void *dst, 
				int count) 
{
	PUSHREG
	NEW_KEYS;
	ENPREPAREREG_ECB;
	XCRYPT_ECB;
	POPREG
}

static __inline volatile void ace_cbc_op6(
				const void *key, 
				const void *ctrl, 
				const void *src, 
				void *dst, 
				int count,
				void *iv) 
{
	PUSHREG
	NEW_KEYS;
	ENPREPAREREG_OTHER;
	XCRYPT_CBC;
	POPREG
}

static __inline volatile void ace_cfb_op6(
				const void *key, 
				const void *ctrl, 
				void *src, 
				void *dst, 
				int count,
				void *iv) 
{
	PUSHREG
	NEW_KEYS;
	ENPREPAREREG_OTHER;
	XCRYPT_CFB;
	POPREG
}

static __inline volatile void ace_ofb_op6(
				const void *key, 
				const void *ctrl, 
				void *src, 
				void *dst, 
				int count,
				void *iv) 
{
    PUSHREG
	NEW_KEYS;
	ENPREPAREREG_OTHER;
	XCRYPT_OFB;
	POPREG
}

AES_RESULT
ace_aes_atomic_crypt(struct ace_aes_context *ctx, 
                          int enc,
                          unsigned char *src, 
						  unsigned char *dst, 
						  int nbytes);

#if defined(__cplusplus)
}
#endif

#endif /* VIA_ACE_H */
