/* $Id: timer.h 23 2005-05-02 11:51:08Z olau $ */

#ifndef _TIMER_H_
#define _TIMER_H_

#define T_RESULT_RESOLUTION       1000LL    /* milliseconds */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32
#include <windows.h>
typedef LARGE_INTEGER TIMER;
extern LONGLONG tickFreq;

#define startTimer(t) QueryPerformanceCounter(t)

#else

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#ifdef __GNUC__
#include <sys/time.h>
#endif

typedef struct timeval TIMER;
typedef long long LONGLONG;
typedef unsigned long long ULONGLONG;

extern struct timezone tz;

extern LONGLONG tv2l(TIMER *);
extern void     startTimer(TIMER *t);

#endif /* WIN32 */

extern LONGLONG stopTimer(TIMER *);

#define START()           startTimer(&stopwatch)
#define STOP(result)      result = stopTimer(&stopwatch)

#ifdef __cplusplus
}
#endif

#endif /* _TIMER_H_ */
