(define (script-fu-select-edges image layer radius edge-amount)
        (let* ((new-layer 0))
	   (gimp-image-undo-group-start image)

	   (gimp-selection-none image)
           (set! new-layer (car (gimp-layer-copy layer TRUE)))
	   (gimp-image-add-layer image new-layer -1)
	   (gimp-desaturate new-layer)
	   (plug-in-edge RUN-NONINTERACTIVE image new-layer edge-amount 1 0)
	   (plug-in-gauss RUN-NONINTERACTIVE image new-layer radius radius 0)
	   (plug-in-colortoalpha RUN-NONINTERACTIVE image new-layer '(0 0 0))
	   (gimp-selection-layer-alpha new-layer)
	   (gimp-image-remove-layer image new-layer)

	   (gimp-image-undo-group-end image)
	   (gimp-displays-flush)
	)
)

(script-fu-register "script-fu-select-edges"
                    "Kanten auswählen..."
		    "Erzeugt eine Auswahl von den Kanten."
		    "Simon Budig"
		    "(c) 2005 c't Magazin"
		    "18. 6. 2005"
		    "RGB* GRAY*"
		    SF-IMAGE      "Eingabebild" 0
		    SF-DRAWABLE   "Aktive Ebene" 0
		    SF-ADJUSTMENT "Radius" '(5 0 200 1 10 0 1)
		    SF-ADJUSTMENT "Stärke" '(2.0 1.0 10.0 0.1 1.0 1 1)
)

(script-fu-menu-register "script-fu-select-edges"
                         "<Image>/Select")
