/*
 * Decompiled with CFR 0.152.
 */
package de.ct.wortschatz.oo;

import com.sun.star.beans.PropertyValue;
import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceDisplayName;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.linguistic2.XMeaning;
import com.sun.star.linguistic2.XThesaurus;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import de.ct.wortschatz.Wortschatz;
import de.ct.wortschatz.oo.OneInstanceFactory;
import de.ct.wortschatz.oo.XMeaning_impl;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class WortschatzOOExtension
extends ComponentBase
implements XThesaurus,
XInitialization,
XServiceInfo,
XServiceDisplayName {
    private final Logger logger = null;
    private final PatternLayout layout = new PatternLayout("%r <%t> %-5p %c %x - %m%n");
    private final String logFileName = "Wortschatz.log";
    private FileAppender appender = null;
    private final Locale[] supportedLocales = new Locale[]{new Locale("de", "DE", "")};
    public static String _aSvcImplName = "de.ct.wortschatz.oo.thesaurus";
    static /* synthetic */ Class class$0;

    public WortschatzOOExtension() {
        if (this.logger != null) {
            try {
                this.appender = new FileAppender((Layout)this.layout, "Wortschatz.log", false);
                this.appender.setName("Wortschatz-Logger");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (this.appender != null) {
                BasicConfigurator.configure((Appender)this.appender);
                this.logger.addAppender((Appender)this.appender);
            }
        }
    }

    private boolean isEqual(Locale loc1, Locale loc2) {
        return loc1.Language.equals(loc2.Language) && loc1.Country.equals(loc2.Country) && loc1.Variant.equals(loc2.Variant);
    }

    public Locale[] getLocales() throws RuntimeException {
        return this.supportedLocales;
    }

    public boolean hasLocale(Locale locale) throws RuntimeException {
        int i = 0;
        while (i < this.supportedLocales.length) {
            if (this.isEqual(locale, this.supportedLocales[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public XMeaning[] queryMeanings(String term, Locale locale, PropertyValue[] properties) throws IllegalArgumentException, RuntimeException {
        if (this.isEqual(locale, new Locale())) {
            if (this.logger != null) {
                this.logger.error((Object)"Locale-Angabe fehlt");
            }
            return null;
        }
        if (term.length() == 0) {
            if (this.logger != null) {
                this.logger.error((Object)"Suchbegriff fehlt");
            }
            return null;
        }
        if (!this.hasLocale(locale)) {
            if (this.logger != null) {
                this.logger.error((Object)("Nicht unterst\u00fctzte Locale-Angabe: " + locale.Language + "_" + locale.Country));
            }
            return null;
        }
        if (this.logger != null) {
            this.logger.info((Object)("Verwenden des Corpus '" + locale.Language + "'"));
        }
        XMeaning[] meanings = new XMeaning[1];
        Wortschatz ws = new Wortschatz(term, locale.Language);
        ws.setLogger(this.logger);
        String[] synonyms = ws.getSynonyms();
        if (this.logger != null) {
            if (synonyms != null) {
                this.logger.info((Object)(String.valueOf(synonyms.length) + " Synonyme f\u00fcr '" + term + "' gefunden"));
            } else {
                this.logger.info((Object)("Keine Synonyme f\u00fcr '" + term + "' gefunden"));
            }
        }
        meanings[0] = new XMeaning_impl(null, synonyms);
        return meanings;
    }

    public String getServiceDisplayName(Locale locale) throws RuntimeException {
        return "Thesaurus Wortschatz Uni Leipzig";
    }

    public void initialize(Object[] args) throws Exception, RuntimeException {
    }

    public boolean supportsService(String serviceName) throws RuntimeException {
        String[] services = WortschatzOOExtension.getSupportedServiceNames_Static();
        int i = 0;
        while (i < services.length) {
            if (serviceName.equals(services[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getImplementationName() throws RuntimeException {
        return _aSvcImplName;
    }

    public String[] getSupportedServiceNames() throws RuntimeException {
        return WortschatzOOExtension.getSupportedServiceNames_Static();
    }

    public static String[] getSupportedServiceNames_Static() {
        String[] result = new String[]{"com.sun.star.linguistic2.Thesaurus"};
        return result;
    }

    public static XSingleServiceFactory __getServiceFactory(String implName, XMultiServiceFactory xMultiFactory, XRegistryKey xRegKey) {
        OneInstanceFactory xSingleServiceFactory = null;
        if (implName.equals(_aSvcImplName)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.ct.wortschatz.oo.WortschatzOOExtension");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            xSingleServiceFactory = new OneInstanceFactory(clazz, _aSvcImplName, WortschatzOOExtension.getSupportedServiceNames_Static(), xMultiFactory);
        }
        return xSingleServiceFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey regKey) {
        boolean result = true;
        String[] services = WortschatzOOExtension.getSupportedServiceNames_Static();
        int length = services.length;
        int i = 0;
        while (i < length) {
            result = result && FactoryHelper.writeRegistryServiceInfo((String)_aSvcImplName, (String)services[i], (XRegistryKey)regKey);
            ++i;
        }
        return result;
    }
}

