/*
 * Decompiled with CFR 0.152.
 */
package de.ct.wortschatz;

import de.ct.wortschatz.thesaurus.DataMatrix;
import de.ct.wortschatz.thesaurus.DataVector;
import de.ct.wortschatz.thesaurus.RequestParameter;
import de.ct.wortschatz.thesaurus.ResponseParameter;
import de.ct.wortschatz.thesaurus.ThesaurusServiceLocator;
import de.ct.wortschatz.thesaurus.ThesaurusSoapBindingStub;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class Wortschatz {
    private final String userName = "ct-thesaur";
    private final String password = "ct-thesaurus";
    private final String wordParm = "Wort";
    private final String limitParm = "Limit";
    private String term = null;
    private int limit = 100;
    private String corpus = "de";
    private Logger logger = null;
    private ThesaurusSoapBindingStub thesBinding = null;
    private DataMatrix thesObjParameters = null;
    private RequestParameter thesRequestParm = null;
    private ResponseParameter thesResponseParm = null;
    private boolean connected = false;
    private String lastExecutionTime = null;

    public Wortschatz() {
    }

    public Wortschatz(String string) {
        this.term = string;
    }

    public Wortschatz(String string, int n) {
        this.term = string;
        this.limit = n;
    }

    public Wortschatz(String string, int n, String string2) {
        this.term = string;
        this.limit = n;
        this.corpus = string2;
    }

    public Wortschatz(String string, String string2) {
        this.term = string;
        this.corpus = string2;
    }

    protected void connect() {
        try {
            this.thesBinding = (ThesaurusSoapBindingStub)new ThesaurusServiceLocator().getThesaurus();
        }
        catch (ServiceException serviceException) {
            this.writeErrorLog(serviceException.getMessage());
        }
        this.thesBinding.setUsername("ct-thesaur");
        this.thesBinding.setPassword("ct-thesaurus");
        this.connected = true;
    }

    public String[] getSynonyms() {
        if (!this.connected) {
            this.connect();
        }
        this.thesObjParameters = new DataMatrix();
        DataVector[] dataVectorArray = new DataVector[]{new DataVector(new String[]{"Wort", this.term}), new DataVector(new String[]{"Limit", String.valueOf(this.limit)})};
        this.thesObjParameters.setDataVectors(dataVectorArray);
        this.thesRequestParm = new RequestParameter();
        this.thesRequestParm.setCorpus(this.corpus);
        this.thesRequestParm.setParameters(this.thesObjParameters);
        ResponseParameter responseParameter = null;
        DataVector[] dataVectorArray2 = null;
        String[] stringArray = null;
        try {
            responseParameter = this.thesBinding.execute(this.thesRequestParm);
        }
        catch (Exception exception) {
            this.writeErrorLog(exception.getMessage());
        }
        dataVectorArray2 = responseParameter.getResult().getDataVectors();
        this.lastExecutionTime = responseParameter.getExecutionTime();
        if (dataVectorArray2 != null) {
            int n;
            int n2 = n = dataVectorArray2.length < this.limit ? dataVectorArray2.length : this.limit;
            if (n > 0) {
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = dataVectorArray2[i].getDataRow(0);
                }
            }
        }
        return stringArray;
    }

    public String getStatus() {
        if (!this.connected) {
            this.connect();
        }
        String string = null;
        try {
            string = this.thesBinding.ping();
        }
        catch (Exception exception) {
            this.writeErrorLog(exception.getMessage());
        }
        return string;
    }

    public String getExecutionTime() {
        return this.lastExecutionTime != null ? this.lastExecutionTime : new String("");
    }

    public void setTerm(String string) {
        this.term = string;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private void writeLog(String string) {
        if (this.logger != null) {
            this.logger.info(string);
        } else {
            System.out.println(string);
        }
    }

    private void writeErrorLog(String string) {
        if (this.logger != null) {
            this.logger.error(string);
        } else {
            System.err.println(string);
        }
    }
}

