/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.classes;

import org.apache.commons.discovery.ResourceClass;
import org.apache.commons.discovery.ResourceClassDiscover;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.ResourceDiscoverImpl;

public abstract class ResourceClassDiscoverImpl
extends ResourceDiscoverImpl
implements ResourceClassDiscover {
    public ResourceClassDiscoverImpl() {
    }

    public ResourceClassDiscoverImpl(ClassLoaders classLoaders) {
        super(classLoaders);
    }

    public ResourceNameIterator findResourceNames(String resourceName) {
        return this.findResourceClasses(resourceName);
    }

    public ResourceNameIterator findResourceNames(ResourceNameIterator resourceNames) {
        return this.findResourceClasses(resourceNames);
    }

    public ResourceIterator findResources(String resourceName) {
        return this.findResourceClasses(resourceName);
    }

    public ResourceIterator findResources(ResourceNameIterator resourceNames) {
        return this.findResourceClasses(resourceNames);
    }

    public abstract ResourceClassIterator findResourceClasses(String var1);

    public ResourceClassIterator findResourceClasses(ResourceNameIterator inputNames) {
        return new ResourceClassIterator(){
            private ResourceClassIterator classes = null;
            private ResourceClass resource = null;

            public boolean hasNext() {
                if (this.resource == null) {
                    this.resource = this.getNextResource();
                }
                return this.resource != null;
            }

            public ResourceClass nextResourceClass() {
                ResourceClass rsrc = this.resource;
                this.resource = null;
                return rsrc;
            }

            private ResourceClass getNextResource() {
                while (inputNames.hasNext() && (this.classes == null || !this.classes.hasNext())) {
                    this.classes = ResourceClassDiscoverImpl.this.findResourceClasses(inputNames.nextResourceName());
                }
                return this.classes != null && this.classes.hasNext() ? this.classes.nextResourceClass() : null;
            }
        };
    }
}

