/* c't-Netz-Schalter Demo Source
 * Datei: rtc.h
 * Info: Realt Time Clock
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 07.10.05
*/
#include "timer.h"

#define JAN	1
#define FEB	2
#define	MRZ	3
#define APR	4
#define MAI	5
#define JUN	6
#define JUL	7
#define AUG	8
#define SEP	9
#define OKT	10
#define NOV	11
#define	DEZ	12

#define RTC_RESOLUTION 1000/TIMER_0_CLOCK

extern volatile int rtc_msecond;
extern volatile char rtc_second;
extern volatile char rtc_minute;
extern volatile char rtc_hour;
extern volatile char rtc_day;
extern volatile char rtc_month;
extern volatile int rtc_year;
extern volatile char rtc_weekday;	//1=Sonntag, 7= Samstag

extern volatile char rtc_new_second;	// Immer 1, wenn eine Sekunde um
					// um das rcksetzen muss sich wer anders
					// kmmern


/* Interrupt Service Routine RTC 
   call once every 1 ms */
void rtc_isr(void);

void rtc_set_time(char hour, char minute, char second, char weekday);
void rtc_set_date(char day, char month, int year);
/* Liest die Zeit von einem HTTP-Server
 * Damit das korrekt funktioniert, muss der XPORT bei eingehenden Daten eine 
 * "Active-Connection" zu einem HTTP-Server (Port 80) aufbauen
 * Da uart_read() blockierend ist, kann sich die Funktion unter Umstnden
 * aufhngen. 
 * Erreicht sie gar keinen HTTP-Server (timeout) liefert sie 0 zurck und lsst
 * die rtc-zeit unverndert
*/ 
char rtc_get_httptime(void);
