#include "ExchangeRateReader.h"
#include <QDomDocument>
#include <QDomElement>
#include <QDomNode>

ExchangeRateReader::ExchangeRateReader() : mFile( "ExchangeRatesXXXXXX" )
{
    if( mFile.open() ) {
        QObject::connect( &mHttp, SIGNAL( done( bool ) ), this, SLOT( slotDownloadDone( bool ) ) );
        mHttp.setHost( "www.ecb.int" );
        mHttp.get( "/stats/eurofxref/eurofxref-hist.xml", &mFile );
    }
}

void ExchangeRateReader::slotDownloadDone( bool error )
{
    if( !error ) {
        // Herunterladen der XML-Daten korrekt ausgeführt

        mFile.seek( 0 );

        QDomDocument document;
        document.setContent( &mFile );

        // Das Wurzelelement ist <gesmes:Envelope>
        QDomElement rootElement = document.documentElement();
        qDebug( "tagName = %s", qPrintable( rootElement.tagName() ) );
        Q_ASSERT( rootElement.tagName() == "gesmes:Envelope" );

        QDomNode node = rootElement.firstChild();
        // Schleife über alle Elemente unterhalb des Wurzelelements,
        // zunächst <gesmes:subject> und <gesmes:Sender> dann die
        // ganzen <Cube>-Elemente, an denen wir interessiert sind.
        while( !node.isNull() ) {
            QDomElement element = node.toElement();
            if( !element.isNull() ) { // war wirklich ein Element
                QString tagName = element.tagName();
                if( tagName == "Cube" ) {
                    // Ein <Cube>-Element, nur diese interessieren uns
                    QDomNode node = element.firstChild();
                    while( !node.isNull() ) {
                        QDomElement element = node.toElement();
                        if( !element.isNull() ) { // war wirklich ein Element
                            QString tagName = element.tagName();
                            // Hier sollte es eigentlich nur
                            // Cube-Elemente geben, aber wir
                            // überprüfen das, um sicher zu gehen.
                            if( tagName == "Cube" ) {
                                // Dieses Cube-Element hat folgendes
                                // Format: <Cube time="2005-11-22">
                                QString dateString = element.attribute( "time" );
                                QDate exchangeDate = QDate::fromString( dateString, "yyyy-MM-dd" );
                                if( !exchangeDate.isValid() )
                                    qDebug( "Unzulässiges Datum oder kein time-Attribut gefunden" );
                                else {
                                    // Die Kinder dieses Elements sind die
                                    // <Cube>-Elemente mit den Kursen
                                    QDomNode node = element.firstChild();
                                    while( !node.isNull() ) {
                                        QDomElement element = node.toElement();
                                        if( !element.isNull() ) { // wirklich ein Element
                                            QString tagName = element.tagName();
                                            // Hier sollte es eigentlich nur
                                            // Cube-Elemente geben, aber wir
                                            // überprüfen das, um sicher zu gehen.
                                            if( tagName == "Cube" ) {
                                                // Dieses Cube-Element hat
                                                // folgendes Format: <Cube currency="USD" rate="1.1701"/>
                                                QString currencyString = element.attribute( "currency" );
                                                if( currencyString.isEmpty() )
                                                    qDebug( "Keine Währung gefunden" );
                                                else {
                                                    QString rateString = element.attribute( "rate" );
                                                    bool convOK = true;
                                                    double rate = rateString.toDouble( &convOK );
                                                    if( !convOK )
                                                        qDebug( "Kein Umtauschkurs gefunden" );
                                                    else
                                                        // Wenn wir hierhin kommen,
                                                        // haben wir ein Tripel gefunden
                                                        mExchangeRates[qMakePair(exchangeDate,currencyString)] = rate;
                                                }
                                            }
                                        }

                                        node = node.nextSibling();
                                    }
                                }
                            }
                        }
                        node = node.nextSibling();
                    }
                }
            }
            node = node.nextSibling();
        }

        qDebug( "%d Tripel gelesen", mExchangeRates.count() );
    }
    mFile.close();
};

