#include <QApplication>
#include <QFile>
#include <QHttp>
#include <QMessageBox>
#include "receiver.h"

int main( int argc, char** argv ) {
    QApplication app( argc, argv );

    if( argc != 2 ) {
        QMessageBox::warning( 0, "Fehler", "Aufruf: httpdownload <dateiname>" );
        return -1;
    }

    QHttp http;
    Receiver receiver( &http );

    QFile targetFile( argv[1] );
    if( targetFile.open( QIODevice::WriteOnly ) ) {
        QObject::connect( &http, SIGNAL( done( bool ) ), &receiver, SLOT( slotDone( bool ) ) );
        http.setHost( "www.ecb.int" );
        http.get( "/stats/eurofxref/eurofxref-hist.xml", &targetFile );
    } else {
        QMessageBox::warning( 0, "Fehler", QString( "Konnte Ausgabedatei %1 nicht öffnen" ).arg( argv[1] ) );
        return -2;
    }

    int ret = app.exec();
    targetFile.close();
    return ret;
}
