#include "pdfdemo.h"
#include <QPrintDialog>

pdfdemo::pdfdemo(QWidget *parent, Qt::WFlags flags)
    : QMainWindow(parent, flags)
{
	ui.setupUi(this);
	pdfPrinter.setOutputFormat(QPrinter::PdfFormat);

	QObject::connect(ui.actionPrint_to_PDF, SIGNAL(triggered()), this, SLOT(printToPDF()));
}

pdfdemo::~pdfdemo()
{
}

void pdfdemo::printToPDF(void)
{
    QPrinter pdfPrinter(QPrinter::HighResolution);
    pdfPrinter.setOutputFormat(QPrinter::PdfFormat);
	pdfPrinter.setPageSize(QPrinter::A4);
	pdfPrinter.setOutputFileName("demo.pdf");
	pdfPrinter.setOrientation(QPrinter::Portrait);
	ui.textEdit->document()->print(&pdfPrinter);
}
