#ifndef EXPENSEMODEL_H
#define EXPENSEMODEL_H

#include <QAbstractItemModel>
#include "ExchangeRateReader.h"

class ExpenseModel :
	public QAbstractItemModel
{
    Q_OBJECT

public:
	ExpenseModel( const ExchangeRates* rates );
	~ExpenseModel();

	QModelIndex index( int row, int column, const QModelIndex & parent = QModelIndex() ) const;
	QModelIndex parent ( const QModelIndex & index ) const;

	int columnCount( const QModelIndex & parent = QModelIndex() ) const;
	int rowCount ( const QModelIndex & parent = QModelIndex() ) const;

	QVariant data( const QModelIndex & index, int role = Qt::DisplayRole ) const;
	Qt::ItemFlags flags ( const QModelIndex & index ) const;
	QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;

	bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
	bool setHeaderData ( int section, Qt::Orientation orientation, const QVariant & value, int role = Qt::EditRole );
	bool insertRows( int row, int count, const QModelIndex & parentIndex=QModelIndex() );
    bool removeRows( int row, int count, const QModelIndex & parentIndex=QModelIndex() );

private:
    const ExchangeRates* mExchangeRates;
};

#endif //EXPENSEMODEL_H
