'***************************************************************************************************************************
' ShowExistingUsbDevices.vbs (C) R. Hohmann 
' fr Windows 2000/XP - 02/2006
' Erzeugt die Datei ExistingUsbDevices.txt,
' eine Liste von allen installierten USB-Gerten
'***************************************************************************************************************************
 
TxtFileName = "ExistingUsbDevices.txt"
Set fs = CreateObject("Scripting.FileSystemObject")
Set TxtFile = fs.OpenTextFile(TxtFileName, 2, True)
Set Reg = GetObject("winmgmts:root\Default:StdRegProv")

Const HKEY_LOCAL_MACHINE = &H80000002

Dim UsbDevices(255)
Dim UsbDeviceTypes(255)
Dim UsbDeviceDescription(255)
Dim AllowedUsbDevices(255)

    Key = "SYSTEM\CurrentControlSet\Enum\USB"
    return = Reg.EnumKey(HKEY_LOCAL_MACHINE, Key, subkeys)
    
    DeviceTypeCounter = 0
    For Each subkey In subkeys
        UsbDeviceTypes(DeviceTypeCounter) = subkey
        DeviceTypeCounter = DeviceTypeCounter + 1
    Next

    For DeviceCounter = 0 To DeviceTypeCounter - 1
        Key = "SYSTEM\CurrentControlSet\Enum\USB" & "\" & UsbDeviceTypes(DeviceCounter)
        return = Reg.EnumKey(HKEY_LOCAL_MACHINE, Key, subkeys)
        i = 0
        For Each subkey In subkeys
           UsbDevices(i) = subkey
           i = i + 1
        Next
        Key = "SYSTEM\CurrentControlSet\Enum\USB" & "\" & UsbDeviceTypes(DeviceCounter) & "\" & UsbDevices(0)
        Name = "DeviceDesc"
        return = Reg.GetStringValue(HKEY_LOCAL_MACHINE, Key, Name, Description)
        UsbDeviceDescription(DeviceCounter) = Description
    Next

For j = 0 To DeviceTypeCounter - 1
    TxtFile.Writeline UsbDeviceDescription(j) & ": " & UsbDeviceTypes(j)
Next
TxtFile.Close
