'***************************************************************************************************************************
' Setup.vbs (C) R. Hohmann 
' fr Windows 2000/XP - 02/2006
' Installiert USBSecure Professional auf Client-Rechnern
'***************************************************************************************************************************

Set Reg = GetObject("winmgmts:root\Default:StdRegProv")
Set Shell = CreateObject("Wscript.Shell")
Set fs = CreateObject("Scripting.FileSystemObject")
Set Env = Shell.Environment("Process")
Set oDrives = fs.Drives
folder = fs.getabsolutepathname(".")
Set LogFile = fs.OpenTextFile(folder & "\installation.log", 8, true)

On Error Resume Next

Const HKEY_LOCAL_MACHINE = &H80000002


Call logging("===============================================")
Call logging("Starte USBSecure Professional Installation...")

'***************************************************************************************************************************
' Installationspfad abfragen
'***************************************************************************************************************************
path = inputbox("Zielpfad:","USBSecure Installation",Env("ProgramFiles") & "\USBSecure")
If path = "" Then wscript.quit
Call logging("Zielpfad: " & path)

if fs.FolderExists(path) then
    Call logging("Pfad bereits vorhanden")
else
    result = fs.CreateFolder(path)
    if err.number = 0 then
        Call logging("Erstellung des Ordners " & path & " erfolgreich")        	
    else
        Call logging("Erstellung des Ordners " & path & " fehlgeschlagen. Bitte melden Sie sich mit Administratorrechten an!")        	
        MsgBox "Erstellung des Ordners " & path & " fehlgeschlagen. Bitte melden Sie sich mit Administratorrechten an!"      	        
        call cleanup
        WScript.Quit
    end if
end if

'***************************************************************************************************************************
' USBSecure-Servername abfragen
'***************************************************************************************************************************
server = inputbox("Name des USBSecure Servers:" & Chr(13) & Chr(13) & "(Bitte geben Sie den Rechnernamen des USBSecure Servers an - nicht die IP-Adresse. Geben Sie den Namen ohne Domain Suffix an.)", "USBSecure Installation")
If server = "" Then wscript.quit
Call logging("USBSecure Server ist " & server)

'***************************************************************************************************************************
' USBSecure.ini schreiben
'***************************************************************************************************************************
Set IniFile = fs.OpenTextFile(path & "\USBSecure.ini", 2, true)
IniFile.writeline "Server=" & server
IniFile.writeline "LogLevel=normal"
IniFile.writeline "ViolationShutdown=yes"
IniFile.Close
if fs.FileExists(path & "\USBSecure.ini") then
    Call logging("Erstellung der Datei " & path & "\USBSecure.ini erfolgreich")
Else
    Call logging("Creation of USBSecure.ini failed.")        	
    MsgBox "Creation of USBSecure.ini failed."      	        
    Call cleanup
    WScript.Quit
End if


'***************************************************************************************************************************
' Dateien kopieren
'***************************************************************************************************************************
If not fs.FileExists("devcon.exe") Then 
    Call logging("devcon.exe fehlt! Bitte kopieren Sie devcon.exe ins Verzeichnis " & folder & " (Download von http://support.microsoft.com/default.aspx?scid=kb;en-us;311272)")
    MsgBox "devcon.exe fehlt! Bitte kopieren Sie devcon.exe ins Verzeichnis " & folder & Chr(13) & "(Download von http://support.microsoft.com/default.aspx?scid=kb;en-us;311272)" 
    abort = 1
End If
If not fs.FileExists("USBSecure.vbe") Then 
    Call logging("USBSecure.vbe fehlt!")
    MsgBox "USBSecure.vbe fehlt!"
    abort = 1
End If
If not fs.FileExists("shutdown.exe") Then 
    Call logging("shutdown.exe fehlt! Bitte kopieren Sie shutdown.exe ins Verzeichnis " & folder & " (shutdown.exe ist im Windows Resource Kit enthalten. Falls Sie" & Chr(13) & "Windows XP einsetzen, finden Sie die Datei unter C:\Windows\System32")
    MsgBox "shutdown.exe fehlt! Bitte kopieren Sie shutdown.exe ins Verzeichnis " & folder & Chr(13) & "(shutdown.exe ist im Windows Resource Kit enthalten. Falls Sie" & Chr(13) & "Windows XP einsetzen, finden Sie die Datei unter C:\Windows\System32" 
    abort = 1
End If
If not fs.FileExists("srvany.exe") Then 
    Call logging("srvany.exe fehlt! Bitte kopieren Sie shutdown.exe ins Verzeichnis " & folder & " (srvany.exe ist im Windows Resource Kit enthalten)")
    MsgBox "srvany.exe fehlt! Bitte kopieren Sie shutdown.exe ins Verzeichnis  " & folder & Chr(13) & "(srvany.exe ist im Windows Resource Kit enthalten)"
    abort = 1
End If
If not fs.FileExists("instsrv.exe") Then 
    Call logging("instsrv.exe fehlt! Bitte kopieren Sie shutdown.exe ins Verzeichnis " & folder & " (instsrv.exe ist im Windows Resource Kit enthalten)")
    MsgBox "instsrv.exe fehlt! Bitte kopieren Sie shutdown.exe ins Verzeichnis " & folder & Chr(13) & "(instsrv.exe ist im Windows Resource Kit enthalten)"
    abort = 1
End If

If abort = 1 Then 
    MsgBox "Installation abgebrochen!"
    Call cleanup
    WScript.Quit
End If

fs.CopyFile "devcon.exe", path & "\devcon.exe"
fs.CopyFile "USBSecure.vbe", path & "\USBSecure.vbe"
fs.CopyFile "shutdown.exe", path & "\shutdown.exe"
fs.CopyFile "srvany.exe", path & "\srvany.exe"
fs.CopyFile "ShowExistingUsbDevices.vbs", path & "\ShowExistingUsbDevices.vbs"
fs.CopyFile "ShowExistingUsbDevices.cmd", path & "\ShowExistingUsbDevices.cmd"
fs.CopyFile "floppy.cfg", path & "\floppy.cfg"
fs.CopyFile "cd.cfg", path & "\cd.cfg"
fs.CopyFile "usb.cfg", path & "\usb.cfg"

wscript.Sleep 1000


'***************************************************************************************************************************
' Dienst installieren
'***************************************************************************************************************************
Return = shell.Run("cmd.exe /c instsrv USBSecure " & Chr(34) & path & "\srvany.exe" & Chr(34), 0, True)

wscript.Sleep 1000


'***************************************************************************************************************************
' Registry-Eintrge machen
'***************************************************************************************************************************
result = Reg.CreateKey(HKEY_LOCAL_MACHINE, "SYSTEM\CurrentControlSet\Services\USBSecure\Parameters")
If result = 0 Then
    Call logging("Erstellung des Registry-Keys SYSTEM\CurrentControlSet\Services\USBSecure\Parameters erfolgreich")
Else
    Call logging("Installation abgebrochen. Bitte melden Sie sich mit Administratorrechten an!")
    MsgBox "Installation abgebrochen. Bitte melden Sie sich mit Administratorrechten an!"
    Call cleanup
    WScript.Quit
End If
result = Reg.SetStringValue(HKEY_LOCAL_MACHINE, "SYSTEM\CurrentControlSet\Services\USBSecure\Parameters", "Application", Chr(34) & Env("windir") & "\system32\wscript.exe" & Chr(34))
If result = 0 Then
    Call logging("Erstellung des Zeichenfolgenwertes Application erfolgreich: " & Chr(34) & Env("windir") & "\system32\wscript.exe" & Chr(34))
Else
    Call logging("Installation abgebrochen. Bitte melden Sie sich mit Administratorrechten an!")
    MsgBox "Installation abgebrochen. Bitte melden Sie sich mit Administratorrechten an!"
    Call cleanup
    WScript.Quit
End If
result = Reg.SetStringValue(HKEY_LOCAL_MACHINE, "SYSTEM\CurrentControlSet\Services\USBSecure\Parameters", "AppParameters", Chr(34) & path & "\USBSecure.vbe" & Chr(34))
If result = 0 Then
    Call logging("Erstellung des Zeichenfolgenwertes AppParameters erfolgreich: " & Chr(34) & path & "\USBSecure.vbe" & Chr(34))
Else
    Call logging("Installation abgebrochen. Bitte melden Sie sich mit Administratorrechten an!")
    MsgBox "Installation abgebrochen. Bitte melden Sie sich mit Administratorrechten an!"
    Call cleanup
    WScript.Quit
End If


'***************************************************************************************************************************
' Installation abschlieen
'***************************************************************************************************************************
Call logging("USBSecure Professional Installation erfolgreich abgeschlossen.")
MsgBox "USBSecure Professional Installation erfolgreich abgeschlossen."  





result = shell.Run("cmd.exe /c notepad.exe " & folder & "\NextSteps.txt", 0, False)



Sub logging(logtext)
    LogFile.writeline Date & " " & Time & "   " & logtext
End Sub

Sub cleanup
    LogFile.Close
    Set fs = CreateObject("Scripting.FileSystemObject")
    result = fs.DeleteFolder(path)
    result = shell.Run("cmd.exe /c notepad.exe " & folder & "\installation.log", 0, False)
End Sub

