using System;
using System.Collections.Generic;
using System.Text;

namespace ConsoleApplication1
{
    class Program
    {
        static void Main(string[] args)
        {
            string Racket = " ===== ";  // Schlger
            Console.Title = "Abbruch mit ESC, Steuerung mit Cursortasten";
            Console.SetWindowSize(80, 20);
            Console.BufferHeight = 20;
            ConsoleKeyInfo cki;
            int posX = Console.BufferWidth / 2;  // 39  // Schlgerposition
            int posY = Console.BufferHeight - 2;
            Console.SetCursorPosition(posX, posY);
            Console.Write(Racket); // Schlger
            int x0, y0;            // alte Ballposition
            int x1 = posX, y1 = 1; // neue Ballposition
            int vx = 1, vy = 1;    // Ballgeschwindigkeit
            DateTime t1, t0 = DateTime.Now;

            while (true)
            {
                x0 = x1; y0 = y1;
                t1 = DateTime.Now;
                int ms = (t1.Millisecond - t0.Millisecond + 1000) % 1000;  // Zeitmessung
                if (ms > 100)
                {
                    t0 = t1;    // Zeitwert fr nchste Intervallmessung speichern
                    // Richtungsumkehr links, rechts
                    if (x1 == 0 || x1 == Console.BufferWidth - 1)
                        vx = -vx;
                    x1 += vx;
                    // Richtungsumkehr oben, Schlger 
                    if (y1 == 0 || (y1 == posY - 1 && x1 > posX && x1 < posX + Racket.Length))
                        vy = -vy;
                    y1 += vy;
                    // Spielende?
                    if (y1 > posY)
                    {
                        string mess = "Game over (Enter)";
                        Console.SetCursorPosition(Console.BufferWidth / 2 - mess.Length / 2, Console.BufferHeight / 2);
                        Console.WriteLine(mess);
                        Console.Beep(280, 500);        // Piepen
                        Console.ReadLine();            // Auf Enter warten
                        return;                        // Fertig
                    }
                    Console.SetCursorPosition(x0, y0);
                    Console.Write(" ");
                    Console.SetCursorPosition(x1, y1);
                    Console.Write("O");
                }
                if (Console.KeyAvailable)
                {
                    cki = Console.ReadKey(); // Zeichen lesen
                    switch (cki.Key)         // Zeichen analysieren
                    {
                        case ConsoleKey.Escape:  // Abbruchkriterium
                            return; break;
                        case ConsoleKey.LeftArrow:
                            if (posX > 0)
                                posX--;
                            break;
                        case ConsoleKey.RightArrow:
                            if (posX < Console.BufferWidth - Racket.Length - 2)
                                posX++;
                            break;
                    }
                    Console.SetCursorPosition(posX, posY);
                    Console.Write(Racket); // Schlger
                }
            }
        }
    }
}