/*
 * PDFDialog.java
 *
 * Created on 3. Januar 2006, 13:09
 */

package pdf;

import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XContainerQuery;
import com.sun.star.container.XEnumeration;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModuleManager;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.task.PasswordRequestMode;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;

/**
 *
 * @author  Administrator
 */


public class PDFDialog extends javax.swing.JDialog {
    public XFileIdentifierConverter mxFileIdentifierConverter;
    XMultiComponentFactory mxMultiComponentFactory = null;
    XComponentContext mxComponentContext = null;
    XSimpleFileAccess xSimpleFileAccess = null;
    XComponentLoader mxComponentLoader = null;
    PropertyValue[] aPDFFilterProperties = null;
    String[] sDocumentTypes = new String[]{"Textdokumente", "Tabellendokumente", "Prsentationen", "Zeichnungen", "Globaldokumente", "Formeln"};
    String[] sbla = new String[]{"odt", "ott", "sxw", "stw", "doc", "dot"};
    String[][] sDocumentExtensions = new String[][]
                    {{"odt", "ott", "sxw", "stw", "doc", "dot"},
                    {"ods", "ots", "xls", "xlt", "sxc", "stc"},
                    {"otp", "odp", "ppd", "ppt", "pot", "sxi", "sti"},
                    {"odg" ,"otg", "sxd", "std"},
                    {"sxm", "odf"},
                    {"sxg", "odm"}};     
    String[] sExtensions = new String[]{"odt", "ott", "sxw", "stw", "doc", "dot"};    
    String msWorkPath = "";
    Utilities moUtilities = null;
    private String sReady = "Fertig";
    private int nCurrentStep = 0;
    
    private javax.swing.JPanel LeftCornerPanel;
    private javax.swing.JPanel ButtonPanel;
    private javax.swing.JPanel DataPanel;
    private javax.swing.JPanel FilterPanel;
    private javax.swing.JPanel FirstStepPanel;
    private javax.swing.JPanel HeaderPanel;
    private javax.swing.JButton JExportPath;
    public javax.swing.JButton JImportPath;
    private javax.swing.JPanel MainPanel;
    private javax.swing.JPanel OptionPanel;
    private javax.swing.JPanel ProgressPanel;
    private javax.swing.JPanel RoadmapPanel;
    private javax.swing.JPanel SelectPanel;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.JButton jBackButton;
    private javax.swing.JButton jBtnMoveSingleLeft;
    private javax.swing.JButton jBtnMoveSingleRight;
    private javax.swing.JSeparator jButtonSeparator;
    private javax.swing.JButton jCancelButton;
    private javax.swing.JCheckBox jChkExportNotes;
    private javax.swing.JCheckBox jChkReduceImageResolution;
    private javax.swing.JCheckBox jChkTaggedPDF;
    private javax.swing.JCheckBox jChkUseTransitionEffects;
    protected javax.swing.JButton jConvertButton;
    private javax.swing.JInternalFrame jInternalFrame1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLblConvert;
    private javax.swing.JLabel jLblConvertProgress;
    private javax.swing.JLabel jLblGetDocuments;
    private javax.swing.JLabel jLblHeaderText;
    private javax.swing.JLabel jLblSteps;
    private javax.swing.JLabel jLblCurrentDocument;
    private javax.swing.JList jList1;
    private javax.swing.JList jList3;
    private javax.swing.JList jLstAllDocumentTypes;
    private javax.swing.JList jLstSelectedDocumentTypes;
    private javax.swing.JComboBox jLstMaxResolution;
    private javax.swing.JComboBox jLstFormsFormat;
    private javax.swing.JProgressBar jPrgConvert;
    private javax.swing.JRadioButton jRBMaxImageResolution;
    private javax.swing.JRadioButton jRB_UseLossLessCompression;
    private javax.swing.JSpinner jSPQuality;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane5;
    private javax.swing.JTextField jtxtSourceFolder;
    private javax.swing.JTextField jtxtTargetFolder;
    private javax.swing.JSeparator jLeftCornerSeparator;    
    
    private javax.swing.JLabel[] oRoadmapJLabels = new javax.swing.JLabel[3];
    private final int NSIZE_X_HEADERPANEL = 450;
    private final int NSIZE_Y_HEADERPANEL = 22;
    private final int NSIZE_X_DATAPANEL = 450;
    private final int NSIZE_Y_DATAPANEL = 300;
    private final int NSIZE_X_MAINPANEL = NSIZE_X_DATAPANEL;
    private final int NSIZE_Y_MAINPANEL = NSIZE_Y_DATAPANEL + NSIZE_Y_HEADERPANEL;
    private final int NSIZE_X_ROADMAPPANEL = 150;
    private final int NSIZE_Y_ROADMAPPANEL = NSIZE_Y_HEADERPANEL + NSIZE_Y_DATAPANEL;
    private final int NSIZE_X_BUTTONPANEL = NSIZE_X_DATAPANEL + NSIZE_X_ROADMAPPANEL;
    private final int NSIZE_Y_BUTTONPANEL = 60;
    private final int NSIZE_X_DIALOG = NSIZE_X_BUTTONPANEL;
    private final int NSIZE_Y_DIALOG = NSIZE_Y_ROADMAPPANEL + NSIZE_Y_BUTTONPANEL;
    private boolean bterminateOffice = false;
    private XDesktop mxDesktop = null;

     /**
     * Creates new form PDFDialog
     */
    public PDFDialog(java.awt.Frame parent, boolean modal, XComponentContext _xComponentContext, boolean _bispipeconnected) {
    super(parent, modal);
    try{
        mxComponentContext = _xComponentContext;
        mxMultiComponentFactory = mxComponentContext.getServiceManager();        
        moUtilities = new Utilities(mxComponentContext, mxMultiComponentFactory);
        Object oSimpleFileAccess = mxMultiComponentFactory.createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", mxComponentContext);
        xSimpleFileAccess = (XSimpleFileAccess) UnoRuntime.queryInterface(XSimpleFileAccess.class, oSimpleFileAccess);      
        Object oDesktop = mxMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", mxComponentContext);
        mxComponentLoader = (XComponentLoader) UnoRuntime.queryInterface(XComponentLoader.class, oDesktop);
        mxDesktop = (XDesktop) UnoRuntime.queryInterface(XDesktop.class, oDesktop);
        /** Wenn der Office-Server durch eine PipeConnection im Hintergrund gestartet wurde, muss dieser Prozess am Ende
            auch wieder beendet werden, da sich das Office ansonsten nicht mehr starten lsst
         */
        if (_bispipeconnected){
           bterminateOffice = (mxDesktop.getComponents().createEnumeration().hasMoreElements() == false);
        }
        initComponents();
        setSize(NSIZE_X_DIALOG, NSIZE_Y_DIALOG );
        jLstAllDocumentTypes.setListData(this.sDocumentTypes);
        String msWorkPath = Utilities.convertfromURLNotation(moUtilities.getOfficePath("Work"));
        this.jtxtSourceFolder.setText(msWorkPath);
        this.jtxtTargetFolder.setText(msWorkPath);
        Object fcv = mxMultiComponentFactory.createInstanceWithContext("com.sun.star.ucb.FileContentProvider", mxComponentContext);
        mxFileIdentifierConverter = (XFileIdentifierConverter) UnoRuntime.queryInterface(XFileIdentifierConverter.class, fcv);
        FirstStepPanelComponentShown(null);
        jSPQuality.setEditor(new JSpinner.NumberEditor(jSPQuality, "#%"));
        jSPQuality.setValue(new Double(0.9));        
        jRB_UseLossLessCompression.setSelected(false);
        this.jChkReduceImageResolution.setSelected(false);
        this.buttonGroup1.add(this.jRBMaxImageResolution);
        this.buttonGroup1.add(this.jRB_UseLossLessCompression);
        jLstMaxResolution.setSelectedItem("300 DPI");
        jLblCurrentDocument.setFont(new java.awt.Font("Tahoma", 0, 11));
        jLeftCornerSeparator.setMinimumSize(new Dimension(NSIZE_X_ROADMAPPANEL, 30));
        this.jLstAllDocumentTypes.setSelectedIndex(0);
    } catch (Exception e) {
        e.printStackTrace(System.out);
    }}
    
    
    private void setSize(JComponent _oComponent, int _nXSize, int _nYSize){
        Dimension oDimension = new Dimension(_nXSize, _nYSize);
        _oComponent.setMinimumSize(oDimension);
        _oComponent.setMaximumSize(oDimension);
        _oComponent.setPreferredSize(oDimension);
    }
    
    public boolean verifyPaths(){
        boolean bSourcePathExists = Utilities.isPathValid(this, this.jtxtSourceFolder.getText());
        boolean bTargetPathExists = Utilities.isPathValid(this, this.jtxtTargetFolder.getText());
        return bSourcePathExists && bTargetPathExists;
    }
    
    
    private void addButtonToButtonPanel(String _sLabel, int _ngridx, java.awt.Insets _aInsets, int _nanchor, JButton _oButton){
        _oButton.setText(_sLabel);
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = _ngridx;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;//3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = _aInsets;     
        gridBagConstraints.anchor = _nanchor;
        ButtonPanel.add(_oButton, gridBagConstraints);
    }
    

    private void addLeftCornerPanel(){
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        LeftCornerPanel = new javax.swing.JPanel();
        LeftCornerPanel.setLayout(new java.awt.GridBagLayout());
        jLeftCornerSeparator = new javax.swing.JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0;
        gridBagConstraints.weighty = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        LeftCornerPanel.add(jLeftCornerSeparator, gridBagConstraints);
        GridBagConstraints jConstraints = new GridBagConstraints();
        jConstraints.gridx = 0;
        jConstraints.gridy = 1;
        jConstraints.weightx = 0;
        jConstraints.weighty = 0;
        jConstraints.anchor = GridBagConstraints.WEST;
        getContentPane().add(LeftCornerPanel, jConstraints);
    }    
    
    private void addButtonPanel(){
        java.awt.GridBagConstraints gridBagConstraints;        
        ButtonPanel = new javax.swing.JPanel();
        jButtonSeparator = new javax.swing.JSeparator();
        jBackButton = new javax.swing.JButton();
        jConvertButton = new javax.swing.JButton();
        jCancelButton = new javax.swing.JButton();

        ButtonPanel.setLayout(new java.awt.GridBagLayout());
        jButtonSeparator.setMinimumSize(new Dimension(NSIZE_X_BUTTONPANEL, 1));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        ButtonPanel.add(jButtonSeparator, gridBagConstraints);
        jBackButton.setEnabled(false);
        jBackButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveToPreviousStep(evt);
            }
        });
        addButtonToButtonPanel("Zur\u00fcck", 0, new Insets(10, 10, 10, 0), GridBagConstraints.WEST, jBackButton);
        jConvertButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveToNextStep(evt);
            }
        });
        addButtonToButtonPanel("Weiter", 1, new Insets(10, 10, 10, 0), GridBagConstraints.WEST, jConvertButton);
        
        jCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCancelButtonActionPerformed(evt);
            }
        });
        addButtonToButtonPanel("Abbrechen", 2, new java.awt.Insets(10, 0, 10, 10), GridBagConstraints.EAST, jCancelButton);

        GridBagConstraints jConstraints = new GridBagConstraints();
        jConstraints.gridx = 1;
        jConstraints.gridy = 1;
        jConstraints.weightx = 1;
        jConstraints.weighty = 0;
        jConstraints.fill = GridBagConstraints.HORIZONTAL;
        jConstraints.anchor = GridBagConstraints.WEST;
        getContentPane().add(ButtonPanel, jConstraints);
    }    

    private void AddIputPathControlGroup(int _ngridy, JLabel _oLabel, String _slabeltext, JButton _oButton, JTextField _oTextField){
        _oLabel.setText(_slabeltext);
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = _ngridy;
        gridBagConstraints.weightx = 0;
        gridBagConstraints.weighty = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 0);
        SelectPanel.add(_oLabel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = _ngridy;
        gridBagConstraints.ipadx = 270; //.gridwidth = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        SelectPanel.add(_oTextField, gridBagConstraints);        
        
        _oButton.setText("...");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = _ngridy;
        gridBagConstraints.weightx = 0;
        gridBagConstraints.weighty = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 10);
        SelectPanel.add(_oButton, gridBagConstraints);        
    }
    
    
    private void AddSelectPanel(){
        SelectPanel.setLayout(new java.awt.GridBagLayout());
        SelectPanel.setMinimumSize(new Dimension(NSIZE_X_DATAPANEL, 120));
        SelectPanel.setPreferredSize(new Dimension(NSIZE_X_DATAPANEL, 120));
        AddIputPathControlGroup(0, jLabel1, "Importieren von", JImportPath, jtxtSourceFolder);
        AddIputPathControlGroup(1, jLabel2, "Exportieren nach", JExportPath, jtxtTargetFolder);
        
        JExportPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JExportPathActionPerformed(evt);
            }
        });
        JImportPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JImportPathActionPerformed(evt);
            }
        });
        java.awt.GridBagConstraints jConstraints = new GridBagConstraints();
        jConstraints.gridy = 0;
        jConstraints.weightx = 1;
        jConstraints.weighty = 1;
        jConstraints.fill = GridBagConstraints.BOTH;
        FirstStepPanel.add(SelectPanel, jConstraints);
    }    
    
    
    private void AddFilterPanel(){
        java.awt.GridBagConstraints gridBagConstraints;        
        FilterPanel.setLayout(new java.awt.GridBagLayout());
        FilterPanel.setMaximumSize(new Dimension(this.NSIZE_X_DATAPANEL, this.NSIZE_Y_DATAPANEL));
        FilterPanel.setMinimumSize(new Dimension(this.NSIZE_X_DATAPANEL, this.NSIZE_Y_DATAPANEL));
        FilterPanel.setOpaque(false);
        FilterPanel.setPreferredSize(new Dimension(this.NSIZE_X_DATAPANEL, this.NSIZE_Y_DATAPANEL));
        jLstAllDocumentTypes.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jLstAllDocumentTypes.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jLstAllDocumentTypesValueChanged(evt);
            }
        });
        JLabel jLblAllDocumentTypes = new javax.swing.JLabel();
        jLblAllDocumentTypes.setText("Untersttzte Dokumenttypen");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0;
        gridBagConstraints.weighty = 0;
        gridBagConstraints.ipadx = 140;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(20, 10, 0, 0);
        FilterPanel.add(jLblAllDocumentTypes, gridBagConstraints);

        
        jScrollPane1.setViewportView(jLstAllDocumentTypes);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1;
        gridBagConstraints.weighty = 1;        
        gridBagConstraints.ipadx = 140;
        gridBagConstraints.ipady = 130;
        gridBagConstraints.fill = GridBagConstraints.BOTH;        
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 20, 10);
        FilterPanel.add(jScrollPane1, gridBagConstraints);
        
        jBtnMoveSingleRight.setText(">");
        jBtnMoveSingleRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnMoveSingleRightActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0;
        gridBagConstraints.weighty = 0;        
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(40, 0, 0, 5);
        FilterPanel.add(jBtnMoveSingleRight, gridBagConstraints);
        jBtnMoveSingleLeft.setText("<");
        jBtnMoveSingleLeft.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnMoveSingleLeftActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0;
        gridBagConstraints.weighty = 0;        
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(20, 0, 0, 5);
        FilterPanel.add(jBtnMoveSingleLeft, gridBagConstraints);
        
        
        JLabel jLblSelectedDocumentTypes = new javax.swing.JLabel();
        jLblSelectedDocumentTypes.setMaximumSize(new Dimension(150, 15));
        jLblSelectedDocumentTypes.setMinimumSize(new Dimension(150, 15));        
        jLblSelectedDocumentTypes.setText("Gewhlte Dokumenttypen");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1;
        gridBagConstraints.weighty = 1;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;        
        gridBagConstraints.insets = new java.awt.Insets(20, 10, 0, 0);
        FilterPanel.add(jLblSelectedDocumentTypes, gridBagConstraints);        
        
        jLstSelectedDocumentTypes.setModel(new javax.swing.AbstractListModel() {
            String[] strings = new String[]{};
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jLstSelectedDocumentTypes.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jLstSelectedDocumentTypes.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jLstSelectedDocumentTypesValueChanged(evt);
            }
        });
        jScrollPane2.setViewportView(jLstSelectedDocumentTypes);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;        
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.ipady = 130;
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 20, 10);
        FilterPanel.add(jScrollPane2, gridBagConstraints);
        
        GridBagConstraints jConstraints = new GridBagConstraints();
        jConstraints.gridy = 1;
        jConstraints.weightx = 1;
        jConstraints.weighty = 2;
        jConstraints.fill = GridBagConstraints.BOTH;
        FirstStepPanel.add(FilterPanel, jConstraints);
        DataPanel.add(FirstStepPanel, "card1");
    }
    
    private void addFirstPagePanel(){
        FirstStepPanel.setMinimumSize(new Dimension(NSIZE_X_DATAPANEL, NSIZE_Y_DATAPANEL));
        FirstStepPanel.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentHidden(java.awt.event.ComponentEvent evt) {
                FirstStepPanelComponentHidden(evt);
            }
            public void componentShown(java.awt.event.ComponentEvent evt) {
                FirstStepPanelComponentShown(evt);
            }
        });
        AddSelectPanel();
        AddFilterPanel();
    }    
    
    private void addOptionPanel(){
        java.awt.GridBagConstraints gridBagConstraints;
        OptionPanel.setLayout(new java.awt.GridBagLayout());
        OptionPanel.setMinimumSize(new Dimension(NSIZE_X_DATAPANEL, NSIZE_Y_DATAPANEL));
        OptionPanel.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                OptionPanelComponentShown(evt);
            }
        });
        jRB_UseLossLessCompression.setText("Verlustfreie Komprimierung");
        jRB_UseLossLessCompression.setName("JUseLossLessCompression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0; //1.0;        
        gridBagConstraints.weighty = 0;//1.0;                
        gridBagConstraints.gridwidth = 7;
        
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        OptionPanel.add(jRB_UseLossLessCompression, gridBagConstraints);

        jRBMaxImageResolution.setSelected(true);
        jRBMaxImageResolution.setText("Optimiert f\u00fcr JPEG Komprimierung");
        jRBMaxImageResolution.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jRBMaxImageResolutionStateChanged(evt);
            }
        });        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 14;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0;//1.0;                        
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(30, 10, 0, 0);
        OptionPanel.add(jRBMaxImageResolution, gridBagConstraints);

        jLabel3.setText("Qualit\u00e4t");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.weighty = 0; //1.0;                        
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 40, 0, 0);
        OptionPanel.add(jLabel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0; //1.0;                        
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        OptionPanel.add(jSPQuality, gridBagConstraints);
        jChkReduceImageResolution.setText("Grafikaufl\u00f6sung verringern");
        jChkReduceImageResolution.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jChkReduceImageResolutionStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0;                        
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 0);
        OptionPanel.add(jChkReduceImageResolution, gridBagConstraints);
        
        
        jLstMaxResolution = new javax.swing.JComboBox(new String[] {"75 DPI", "150 DPI", "300 DPI", "600 DPI", "1200 DPI"});
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0;	//1.0;
        gridBagConstraints.weighty = 0;	//1.0;        
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 10, 0, 0);
        OptionPanel.add(jLstMaxResolution, gridBagConstraints);
                
        javax.swing.JSeparator jOptionCommon = new javax.swing.JSeparator();
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 16;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0; //1.0;                        
        gridBagConstraints.ipadx = (int) (0.8 * this.NSIZE_X_DATAPANEL);
        gridBagConstraints.insets = new java.awt.Insets(12, 10, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        OptionPanel.add(jOptionCommon, gridBagConstraints);
        
        
        jChkTaggedPDF.setText("Tagged PDF");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        OptionPanel.add(jChkTaggedPDF, gridBagConstraints);

        jChkExportNotes.setSelected(true);
        jChkExportNotes.setText("Notizen exportieren");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        OptionPanel.add(jChkExportNotes, gridBagConstraints);

        jChkUseTransitionEffects.setSelected(true);
        jChkUseTransitionEffects.setText("\u00dcbergangseffekte benutzen");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        OptionPanel.add(jChkUseTransitionEffects, gridBagConstraints);

        jLabel4.setText("Format f\u00fcr Formular\u00fcbermittlung");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        OptionPanel.add(jLabel4, gridBagConstraints);
        
        
        jLstFormsFormat = new javax.swing.JComboBox(new String[] {"FDF", "PDF", "HTML", "XML"});
        javax.swing.JScrollPane jScrollPaneFormsFormat = new javax.swing.JScrollPane();
        jLstMaxResolution.setSelectedIndex(0);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0;	//1.0;
        gridBagConstraints.weighty = 0;	//1.0;        
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        OptionPanel.add(jLstFormsFormat, gridBagConstraints);        
        DataPanel.add(OptionPanel, "card2");
    }
    
    
    private void jRBMaxImageResolutionStateChanged(javax.swing.event.ChangeEvent evt) {
        boolean bdoenable = this.jRBMaxImageResolution.isSelected();
        jLstMaxResolution.setEnabled(bdoenable && jChkReduceImageResolution.isSelected());
        jLabel3.setEnabled(bdoenable);
        jSPQuality.setEnabled(bdoenable);
    }
    
    
    private void addProgressPanel(){
        java.awt.GridBagConstraints gridBagConstraints;
        ProgressPanel.setLayout(new java.awt.GridBagLayout());
        ProgressPanel.setMinimumSize(new Dimension(NSIZE_X_DATAPANEL, NSIZE_Y_DATAPANEL));
        ProgressPanel.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                ProgressPanelComponentShown(evt);
            }
        });

        jLblGetDocuments.setText("Die Dokumente werden erfasst...");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 20, 0);
        ProgressPanel.add(jLblGetDocuments, gridBagConstraints);

        jLblConvert.setText("Exportierung...");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        ProgressPanel.add(jLblConvert, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;                
        gridBagConstraints.weightx = 0;
        gridBagConstraints.ipadx = NSIZE_X_DATAPANEL-20;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        ProgressPanel.add(jPrgConvert, gridBagConstraints);
        
        jLblCurrentDocument.setText("Aktuelles Dokument: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 20, 10);
        ProgressPanel.add(jLblCurrentDocument, gridBagConstraints);
        DataPanel.add(ProgressPanel, "card3");        
    }    

    
    private void addRoadmapPanel(){
        RoadmapPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 5, 13));
        RoadmapPanel.setBackground(new java.awt.Color(255, 255, 255));
        setSize(RoadmapPanel, NSIZE_X_ROADMAPPANEL, NSIZE_Y_ROADMAPPANEL);
        jLblSteps.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLblSteps.setText(" Schritte");
        jLblSteps.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        RoadmapPanel.add(jLblSteps);        
        
        oRoadmapJLabels[0].setBackground(new java.awt.Color(0, 102, 204));
        oRoadmapJLabels[0].setForeground(new java.awt.Color(255, 255, 255));
        oRoadmapJLabels[0].setText(" Dokumente w\u00e4hlen");
        oRoadmapJLabels[0].setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        oRoadmapJLabels[0].setMaximumSize(new Dimension(140, 14));
        oRoadmapJLabels[0].setMinimumSize(new Dimension(140, 14));
        oRoadmapJLabels[0].setOpaque(true);
        oRoadmapJLabels[0].setPreferredSize(new Dimension(140, 14));
        RoadmapPanel.add(oRoadmapJLabels[0]);

        oRoadmapJLabels[1].setBackground(new java.awt.Color(255, 255, 255));
        oRoadmapJLabels[1].setText(" Optionen");
        oRoadmapJLabels[1].setMaximumSize(new Dimension(140, 14));
        oRoadmapJLabels[1].setMinimumSize(new Dimension(140, 14));
        oRoadmapJLabels[1].setOpaque(true);
        oRoadmapJLabels[1].setPreferredSize(new Dimension(140, 14));
        RoadmapPanel.add(oRoadmapJLabels[1]);

        oRoadmapJLabels[2].setBackground(new java.awt.Color(255, 255, 255));
        oRoadmapJLabels[2].setText(" Export");
        oRoadmapJLabels[2].setMaximumSize(new Dimension(140, 14));
        oRoadmapJLabels[2].setMinimumSize(new Dimension(140, 14));
        oRoadmapJLabels[2].setOpaque(true);
        oRoadmapJLabels[2].setPreferredSize(new Dimension(140, 14));
        RoadmapPanel.add(oRoadmapJLabels[2]);

        getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints jConstraint = new GridBagConstraints();
        jConstraint.gridx = 0;
        jConstraint.gridy = 0;
        jConstraint.fill = GridBagConstraints.VERTICAL;
        jConstraint.weighty = 1;
        getContentPane().add(RoadmapPanel, jConstraint);
    }    
    
    private void addHeaderPanel(){            
        HeaderPanel.setMinimumSize(new Dimension(NSIZE_X_HEADERPANEL, NSIZE_Y_HEADERPANEL));
        HeaderPanel.setPreferredSize(new Dimension(NSIZE_X_HEADERPANEL, NSIZE_Y_HEADERPANEL));
        HeaderPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 10, 10));
        jLblHeaderText.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLblHeaderText.setText("Whlen Sie die zu exportierenden Dokumente aus");
        jLblHeaderText.setMaximumSize(new Dimension(NSIZE_X_HEADERPANEL-40, 14));
        jLblHeaderText.setMinimumSize(new Dimension(NSIZE_X_HEADERPANEL-40, 14));
        HeaderPanel.add(jLblHeaderText);        
        MainPanel.setLayout(new GridBagLayout());
        GridBagConstraints jConstraint = new GridBagConstraints();
        jConstraint.gridx = 0;
        jConstraint.gridy = 0;
        jConstraint.fill = GridBagConstraints.HORIZONTAL;
        jConstraint.weightx = 1;
        MainPanel.add(HeaderPanel, jConstraint);
        }        
    
    
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        jInternalFrame1 = new javax.swing.JInternalFrame();
        jScrollPane3 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jScrollPane5 = new javax.swing.JScrollPane();
        jList3 = new javax.swing.JList();
        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        RoadmapPanel = new javax.swing.JPanel();
        jLblSteps = new javax.swing.JLabel();
        oRoadmapJLabels[0] = new javax.swing.JLabel();
        oRoadmapJLabels[1] = new javax.swing.JLabel();
        oRoadmapJLabels[2] = new javax.swing.JLabel();
        MainPanel = new javax.swing.JPanel();
        HeaderPanel = new javax.swing.JPanel();
        jLblHeaderText = new javax.swing.JLabel();
        DataPanel = new javax.swing.JPanel();
        FirstStepPanel = new javax.swing.JPanel();
        SelectPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        JImportPath = new javax.swing.JButton();
        jtxtSourceFolder = new javax.swing.JTextField();
        jtxtTargetFolder = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        JExportPath = new javax.swing.JButton();
        FilterPanel = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jLstSelectedDocumentTypes = new javax.swing.JList();
        jScrollPane1 = new javax.swing.JScrollPane();
        jLstAllDocumentTypes = new javax.swing.JList();
        jBtnMoveSingleLeft = new javax.swing.JButton();
        jBtnMoveSingleRight = new javax.swing.JButton();
        OptionPanel = new javax.swing.JPanel();
        jRB_UseLossLessCompression = new javax.swing.JRadioButton();
        jRBMaxImageResolution = new javax.swing.JRadioButton();
        jLabel3 = new javax.swing.JLabel();
        jSPQuality = new javax.swing.JSpinner(new SpinnerNumberModel(0.9, 0, 1, 0.01));
        jChkReduceImageResolution = new javax.swing.JCheckBox();
        jChkTaggedPDF = new javax.swing.JCheckBox();
        jChkExportNotes = new javax.swing.JCheckBox();
        jChkUseTransitionEffects = new javax.swing.JCheckBox();
        jLabel4 = new javax.swing.JLabel();
        ProgressPanel = new javax.swing.JPanel();
        jLblGetDocuments = new javax.swing.JLabel();
        jLblConvert = new javax.swing.JLabel();
        jPrgConvert = new javax.swing.JProgressBar();
        jLblConvertProgress = new javax.swing.JLabel();
        jLblCurrentDocument = new javax.swing.JLabel();

        jInternalFrame1.setVisible(true);
        jList1.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane3.setViewportView(jList1);

        jList3.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane5.setViewportView(jList3);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("PDF-Konverter");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                exitConverter(evt);
            }
        });        
        addRoadmapPanel();
        addButtonPanel();
        addLeftCornerPanel();
        MainPanel.setMinimumSize(new Dimension(NSIZE_X_MAINPANEL, NSIZE_Y_MAINPANEL));
        addHeaderPanel();
        DataPanel.setLayout(new java.awt.CardLayout());
        FirstStepPanel.setLayout(new GridBagLayout());
        addFirstPagePanel();
        addOptionPanel();
        addProgressPanel();
        GridBagConstraints jConstraint = new GridBagConstraints();
        jConstraint.gridx = 0;
        jConstraint.gridy = 1;
        jConstraint.fill = GridBagConstraints.BOTH;
        jConstraint.weightx = 1;
        jConstraint.weighty = 1;
        MainPanel.add(DataPanel, jConstraint);

        jConstraint = new GridBagConstraints();
        jConstraint.gridx = 1;
        jConstraint.gridy = 0;
        jConstraint.gridwidth = 1;
        jConstraint.gridheight = 1;
        jConstraint.fill = GridBagConstraints.BOTH;
        jConstraint.weightx = 1;
        jConstraint.weighty = 1;
        getContentPane().add(MainPanel, jConstraint);
        this.setResizable(true);
        pack();
    }

    private void jChkReduceImageResolutionStateChanged(javax.swing.event.ChangeEvent evt) {                                                       
        this.jLstMaxResolution.setEnabled(this.jChkReduceImageResolution.isSelected());
    }                                                      

    private void jLstAllDocumentTypesValueChanged(javax.swing.event.ListSelectionEvent evt) {                                                  
        toggleMoveSelectionButtons();
    }                                                 

    private void jLstSelectedDocumentTypesValueChanged(javax.swing.event.ListSelectionEvent evt) {                                                       
        toggleMoveSelectionButtons();
    }                                                      

    private void FirstStepPanelComponentShown(java.awt.event.ComponentEvent evt) {                                              
        this.jBackButton.setEnabled(false);
        this.jLblHeaderText.setText("Whlen Sie die zu exportierenden Dokumente");
        boolean bgoon = (jLstSelectedDocumentTypes.getModel().getSize() > 0);
        this.jConvertButton.setEnabled(bgoon); 
        toggleMoveSelectionButtons();
        switchStep(1,0);
    }                                             

    private void toggleMoveSelectionButtons(){
        this.jBtnMoveSingleLeft.setEnabled(jLstSelectedDocumentTypes.getSelectedValue() != null);
        this.jBtnMoveSingleRight.setEnabled(jLstAllDocumentTypes.getSelectedValue() != null);                
    }
    
    private void FirstStepPanelComponentHidden(java.awt.event.ComponentEvent evt) {                                               
        if ( !verifyPaths()){
            CardLayout oCardLayout = ((CardLayout) DataPanel.getLayout());
            oCardLayout.first(DataPanel);            
        }
        this.jBackButton.setEnabled(true);
    }                                              

    private void OptionPanelComponentShown(java.awt.event.ComponentEvent evt) {                                           
        this.jLblHeaderText.setText("Whlen sie die Exportierungsoptionen");
    }                                          



    private void jBtnMoveSingleLeftActionPerformed(java.awt.event.ActionEvent evt) {                                                   
        shiftfromSourceListBoxToTargetListBox(jLstSelectedDocumentTypes, jLstAllDocumentTypes);
        this.jConvertButton.setEnabled(jLstSelectedDocumentTypes.getModel().getSize() > 0);    
        toggleMoveSelectionButtons();
    }                                                  

    private void jBtnMoveSingleRightActionPerformed(java.awt.event.ActionEvent evt) {                                                    
        shiftfromSourceListBoxToTargetListBox(jLstAllDocumentTypes, jLstSelectedDocumentTypes);
        this.jConvertButton.setEnabled(true);
        toggleMoveSelectionButtons();
    }                                                   

    private void shiftfromSourceListBoxToTargetListBox(JList _oSourceListBox, JList _oTargetListBox){
        String sDocumentType = (String) _oSourceListBox.getSelectedValue();
        ListModel oSourceListModel = _oSourceListBox.getModel();
        ListModel oTargetListModel = _oTargetListBox.getModel();
        int nselected = _oSourceListBox.getSelectedIndex();
        String[] snewlist = new String[oSourceListModel.getSize()-1];
        int a = 0;
        for (int i = 0; i < oSourceListModel.getSize(); i++){
            if (i != nselected){
                snewlist[a] = (String) oSourceListModel.getElementAt(i);
                a++;
            }
        }
        _oSourceListBox.setListData(snewlist);
        int nselectedcount = oSourceListModel.getSize();
        if (nselectedcount > 0){
            if (nselected < nselectedcount-1){
                _oSourceListBox.setSelectedIndex(nselected);
            }
            else{
                _oSourceListBox.setSelectedIndex(nselected-1);                
            }
        }
        snewlist = new String[oTargetListModel.getSize()+1];
        for (int i = 0; i < oTargetListModel.getSize(); i++){
            snewlist[i] = (String) oTargetListModel.getElementAt(i);
        }
        snewlist[oTargetListModel.getSize()] = sDocumentType;
        _oTargetListBox.setListData(snewlist);        
    }
    
    
    private void moveToPreviousStep(java.awt.event.ActionEvent evt) {                                    
        this.switchStep(nCurrentStep, nCurrentStep - 1);        
        CardLayout oCardLayout = ((CardLayout) DataPanel.getLayout());
        oCardLayout.previous(DataPanel);
    }                                   

    private void moveToNextStep(java.awt.event.ActionEvent evt) {                                
        if (jConvertButton.getText().equals(sReady)){
            exitConverter(null);
            return;
        }
        this.switchStep(nCurrentStep, nCurrentStep + 1);
        CardLayout oCardLayout = ((CardLayout) DataPanel.getLayout());
        oCardLayout.next(DataPanel);
    }                               

    private void jCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {                                              
        exitConverter(null);
    }                                             

    private void ProgressPanelComponentShown(java.awt.event.ComponentEvent evt) {                                             
    try{
        this.jLblHeaderText.setText("Die Dokumente werden erfasst und exportiert");
        String sSourceFolder = jtxtSourceFolder.getText();
        String sTargetFolder = jtxtTargetFolder.getText();
        sSourceFolder = mxFileIdentifierConverter.getFileURLFromSystemPath(sSourceFolder, sSourceFolder);
        sTargetFolder = mxFileIdentifierConverter.getFileURLFromSystemPath(sTargetFolder,sTargetFolder);
        if (xSimpleFileAccess.isFolder(sSourceFolder)){

            jLblGetDocuments.setFont(new java.awt.Font("Tahoma", 1, 11));
            jLblGetDocuments.paintImmediately(jLblGetDocuments.getBounds());
        	String[] sFolderContentList = xSimpleFileAccess.getFolderContents(sSourceFolder, true);

            jLblGetDocuments.setFont(new java.awt.Font("Tahoma", 0, 11));
            jLblGetDocuments.paintImmediately(jLblGetDocuments.getBounds());

            jLblConvert.setFont(new java.awt.Font("Tahoma", 1, 11));
            jLblConvert.paintImmediately(jLblConvert.getBounds());            
            
            String[] sDocumentList = gatherAllrelevantDocuments(sFolderContentList);
            
            jPrgConvert.setMaximum(sDocumentList.length);
            this.jBackButton.setEnabled(false);
            this.jConvertButton.setEnabled(false);
        	
            Thread aThread = new ConversionThread( this, jPrgConvert, sDocumentList, sTargetFolder);
            aThread.start();
        }
    } catch (Exception e) {
        e.printStackTrace(System.out);
        JOptionPane.showMessageDialog(this, "Beim Export ist ein Fehler aufgetreten!", "PDF-Konverter", JOptionPane.ERROR_MESSAGE);        
    }}                                            

    private void exitConverter(java.awt.event.WindowEvent evt) {    
        if (bterminateOffice){
            if (mxDesktop != null){
               System.out.println("Sitzung des Office-Servers wird beendet");
               /* Das Schlieen des Offices kann in diesem Programm zu Problemen fhren und wurde daher auskommentiert.
                * OpenOffice 2.0 ist nicht threadsicher und da die Konveriertung in einem anderen Thread
                * luft (damit der Fortschritt auch richtig angezeigt werden kann), 
                * kann es beim Aufruf von "terminate()" zu Deadlocks kommen. 
                * Man msste sicherstellen, dass die Konvertierungsroutinen und das Beenden des Offices im selben Thread abluft.
                */
               mxDesktop.terminate();
            }
        }
        System.exit(0); 
    }                              

    private void jtxtTargetFolderKeyReleased(java.awt.event.KeyEvent evt) {                                             
        toggleConvertButton();
    }                                            

    private void JExportPathActionPerformed(java.awt.event.ActionEvent evt) {                                            
        chooseDirectory(jtxtTargetFolder);
        toggleConvertButton();
    }                                           
        
    private String[] getListBoxElements(JList _oListBox){
        ListModel oListBoxModel = _oListBox.getModel();
        String[] sList = new String[_oListBox.getModel().getSize()];
        for (int i = 0; i < sList.length; i++){
            sList[i] = (String) oListBoxModel.getElementAt(i);
        }
        return sList;
    }
    
    private String[] gatherAllrelevantDocuments(String[] sFolderContentList){
        Vector aDocumentVector = new Vector();
        String[] sExtensions = getFileExtensions(getListBoxElements(this.jLstSelectedDocumentTypes));
        for (int i = 0; i < sFolderContentList.length; i++){
            String sCurExtension = Utilities.getFileExtension(sFolderContentList[i]);
            if (Utilities.FieldInList(sExtensions, sCurExtension) > -1){
                aDocumentVector.add(sFolderContentList[i]);
            }
        }
        String[] sDocumentList = new String[aDocumentVector.size()];
        aDocumentVector.toArray(sDocumentList);
        return sDocumentList;
    }
    
    
    private void JImportPathActionPerformed(java.awt.event.ActionEvent evt) {                                            
        chooseDirectory(jtxtSourceFolder);
        toggleConvertButton();
    }                                               
    
    public void chooseDirectory(javax.swing.JTextField sDirField){
    try{
    	String sLocation = sDirField.getText();
    	if ((sLocation == null) || (sLocation.length() == 0)) {
            sLocation = msWorkPath;
    	}
        final javax.swing.JFileChooser fc = new javax.swing.JFileChooser(sLocation);
        fc.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);
        fc.setDialogTitle( "PDF-Konverter");
        int returnVal = fc.showOpenDialog(getContentPane());
        if (returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
            java.io.File sDir = fc.getSelectedFile();
            if ((sDir.exists()) && (sDir.isDirectory())){
                sDirField.setText(sDir.getCanonicalPath());
            }            
        }
    }catch(Exception exception){
        exception.printStackTrace(System.out);
    }}
    
    
    private void toggleConvertButton(){
        java.io.File sSourceDirPath = new java.io.File(jtxtSourceFolder.getText());
        boolean bTargetDirEnabled = (sSourceDirPath.exists() && sSourceDirPath.isDirectory());
        java.io.File sTargetDirPath = new java.io.File(jtxtTargetFolder.getText());
        boolean bSourceDirEnabled = (sTargetDirPath.exists() && sTargetDirPath.isDirectory());
        jConvertButton.setEnabled(bSourceDirEnabled && bTargetDirEnabled);
    }
    
    public String[] getFileExtensions(String[] _sDocumentTypes){
        Vector aExtensionVector = new Vector();
        for (int n = 0; n < _sDocumentTypes.length; n++){
           int nIndex = Utilities.getFieldInList(sDocumentTypes, _sDocumentTypes[n]);
           for (int m = 0; m < sDocumentExtensions[nIndex].length; m++){
               aExtensionVector.add(sDocumentExtensions[nIndex][m]);
           }
        }
        String[] sRetExtensions = new String[aExtensionVector.size()];
        aExtensionVector.toArray(sRetExtensions);
        return sRetExtensions;
    }    
    
    private void switchStep(int _nOldStep, int _nNewStep){
        this.nCurrentStep = _nNewStep;
        oRoadmapJLabels[_nOldStep].setBackground(new java.awt.Color(255, 255, 255));
        oRoadmapJLabels[_nOldStep].setForeground(new java.awt.Color(0,0,0));
        oRoadmapJLabels[_nNewStep].setBackground(new java.awt.Color(0, 102, 204));
        oRoadmapJLabels[_nNewStep].setForeground(new java.awt.Color(255, 255, 255));
    }
    
    
    //TODO implement FormsType, configure spinner controls, check UI of ExportNotesPages
    protected PropertyValue[] getPDFFilterData(){
        boolean bUseLosslessCompression = jRB_UseLossLessCompression.isSelected();      // default: false (boolean)
        Double fQuality = (Double) jSPQuality.getValue();
        Integer NQuality = new Integer((int) (fQuality.doubleValue() * 100));		// default 90 (int (1-100))
        boolean bReduceImageResolution = jChkReduceImageResolution.isSelected();        // boolean
        String sResolution = ((String) jLstMaxResolution.getSelectedItem()).replaceFirst(" DPI", "");
        Integer NMaxImageResolution  = new Integer(sResolution); 			// default: 300;  // 75/150/300/600/1200     If the property ReduceImageResolution is set to true all images will be reduced to the given value. in DPI.</desc> 
        boolean bUseTaggedPDF = jChkTaggedPDF.isSelected();                             // default: false (boolean)
        boolean bExportNotes = jChkExportNotes.isSelected();                            // default: true    (boolean)
        boolean bExportNotesPages = bExportNotes;                                       // boolean
        boolean bUseTransitionEffects = jChkUseTransitionEffects.isSelected();          // default: true (boolean)
        int nFormsType = jLstFormsFormat.getSelectedIndex();                            // 0->FDF; 1->PDF; 2->HTML; 3->XML
        aPDFFilterProperties = new PropertyValue[9];
        aPDFFilterProperties[0] = Utilities.createPropertyValue("UseLosslessCompression", new Boolean(bUseLosslessCompression));
        aPDFFilterProperties[1] = Utilities.createPropertyValue("Quality", NQuality);
        aPDFFilterProperties[2] = Utilities.createPropertyValue("ReduceImageResolution", new Boolean(bReduceImageResolution));
        aPDFFilterProperties[3] = Utilities.createPropertyValue("MaxImageResolution", NMaxImageResolution);
        aPDFFilterProperties[4] = Utilities.createPropertyValue("UseTaggedPDF", new Boolean(bUseTaggedPDF));
        aPDFFilterProperties[5] = Utilities.createPropertyValue("ExportNotes", new Boolean(bExportNotes));
        aPDFFilterProperties[6] = Utilities.createPropertyValue("ExportNotesPages", new Boolean(bExportNotesPages));
        aPDFFilterProperties[7] = Utilities.createPropertyValue("UseTransitionEffects", new Boolean(bUseTransitionEffects));
        aPDFFilterProperties[8] = Utilities.createPropertyValue("FormsType", new Integer(nFormsType));
        return aPDFFilterProperties;
    }
    
    
    protected String getTargetFolder(){
        return jtxtTargetFolder.getText();
    }

    protected javax.swing.JLabel getCurrentDocumentLabel(){
        return jLblCurrentDocument;
    }

    protected javax.swing.JButton getConvertButton(){
        return jConvertButton;
    }
}

