using System;
using System.Collections.Generic;
using System.Text;

namespace BildschirmTennis2
{
    class Program1
    {
        static void Main(string[] args)
        {
            Console.Title = "Abbruch mit ESC, Steuerung mit Cursortasten";
            Console.SetWindowSize(80, 20);
            Console.BufferHeight = 20;

            Point spos = new Point(Console.WindowWidth / 2 - 2, Console.WindowHeight - 2);
            Point feld = new Point(Console.WindowWidth, Console.WindowHeight);
            Schlger schlger = new Schlger("====", spos, feld);

            Point bpos = new Point(Console.WindowWidth / 2, 0);
            Ball ball = new Ball('O', bpos, new Speed(1, 1), feld);

            DateTime t1, t0 = DateTime.Now;
            while (true)
            {
                t1 = DateTime.Now;
                int ms = (t1.Millisecond - t0.Millisecond + 1000) % 1000;  // Zeitmessung
                if (ms > 100)
                {
                    t0 = t1;    // Zeitwert fr nchste Intervallmessung speichern
                    if (ball.Animate(schlger))
                    {
                        string mess = "Game over (Enter)";
                        Console.SetCursorPosition(Console.BufferWidth / 2 - mess.Length / 2, Console.BufferHeight / 2);
                        Console.WriteLine(mess);
                        Console.Beep(280, 500);        // Piepen
                        Console.ReadLine();            // Auf Enter warten
                        return;                        // Fertig
                    }
                }
                if (Console.KeyAvailable)
                    switch (Console.ReadKey().Key)
                    {
                        case ConsoleKey.LeftArrow:
                            schlger.Links(); break;
                        case ConsoleKey.RightArrow:
                            schlger.Rechts(); break;
                        case ConsoleKey.Escape:
                            return; break;
                    }
            }
        }
        public class Ball
        {
            Point Pos, Feld;
            Speed v;
            char ball;
            public Ball(char b, Point p0, Speed v0, Point feld)
            {
                ball = b;
                Pos = p0;
                v = v0;
                Feld = feld;
                // TODO: testen ob Ball in Feld?
            }
            public bool Animate(Schlger sl)
            {
                if (Pos.x + v.x < 0 || Pos.x + v.x >= Feld.x)
                    v.x = -v.x;
                if (Pos.y + v.y < 0 || sl.Treffer(Pos))
                    v.y = -v.y;
                Console.SetCursorPosition(Pos.x, Pos.y);
                Console.Write(" ");
                Pos = Pos + v;
                if (Pos.y == Feld.y)
                    return true;  // verloren
                Console.SetCursorPosition(Pos.x, Pos.y);
                Console.Write(ball);
                return false;
            }
        }
        public class Schlger
        {
            string Schlger0; // Schlger
            string Schlger1; // Maske, zum berzeichnen des Schlgers
            Point Pos0, Pos1;
            Point Feld;
            public Schlger(string s, Point start, Point feld)
            {
                Schlger1 = s;
                Schlger0 = new string(' ', s.Length);
                Pos0 = Pos1 = start;
                Feld = feld;
                Console.SetCursorPosition(Pos1.x, Pos1.y);
                Console.Write(Schlger1);
            }
            public void Links()
            {
                if (Pos1.x > 0)
                {
                    Pos1.x--;
                    Zeichne();
                }
            }
            public void Rechts()
            {
                if (Pos1.x + Schlger0.Length + 1 < Feld.x)
                {
                    Pos1.x++;
                    Zeichne();
                }
            }
            private void Zeichne()
            {
                Console.SetCursorPosition(Pos0.x, Pos0.y);
                Console.Write(Schlger0);
                Console.SetCursorPosition(Pos1.x, Pos1.y);
                Console.Write(Schlger1);
                Pos0 = Pos1;
            }
            public bool Treffer(Point p)
            {
                if (p.y == Pos0.y &&
                    Pos0.x <= p.x &&
                    Pos0.x + Schlger0.Length > p.x)
                    return true;
                Zeichne();
                return false;
            }
        }
        public struct Point
        {
            public int x, y;
            public Point(int px, int py)
            {
                x = px;
                y = py;
            }
            static public Point operator +(Point p, Speed g)
            {
                return new Point(p.x + g.x, p.y + g.y);
            }
        }
        public class Speed
        {
            public int x, y;
            public Speed(int vx, int vy)
            {
                x = vx;
                y = vy;
            }
        }

    }
}
