VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmAnhngeElementWhlen 
   Caption         =   "frmAnhngeElementWhlen"
   ClientHeight    =   5280
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   7230
   OleObjectBlob   =   "frmAnhngeElementWhlen.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "frmAnhngeElementWhlen"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' 2006, Ralf Nebelo

'bergabe des gewhlten Ordners
Public objOLOrdner As MAPIFolder
'Rckgabe des gewhlten Elements
Public objGewhltesElement As Object
'Item-Array fr Aufnahme der Ordnerelemente
Private objSortItems As Items

'**************************************************************
'Ereignisprozeduren
'**************************************************************

Private Sub UserForm_Activate()
    Dim lngI As Long
    Dim strBetreff As String
    
    'Wenn Verweis auf Ordner bergeben, dann...
    If Not objOLOrdner Is Nothing Then
        '... Elemente des Ordners in benutzerdefiniertes Item-Array kopieren
        Set objSortItems = objOLOrdner.Items
        
        'Wenn Ordner "Kontakte" heit, dann...
        If objOLOrdner.Name = "Kontakte" Then
            '... Item-Array aufsteigend nach 'Subject'-Eigenschaft sortieren
            objSortItems.Sort "[Subject]", False
        
        'Bei jedem anderen Ordner...
        Else
            '... Item-Array absteigend nach 'CreationTime'-Eigenschaft sortieren
            objSortItems.Sort "[CreationTime]", True
        End If
    
        'Listenfeld lstElemente konfigurieren
        With lstElemente
            '2 Spalten
            .ColumnCount = 2
            '2. Spalte unsichtbar
            .ColumnWidths = "-1;0"
        
            'Alle Elemente des Item-Arrays durchlaufen
            For lngI = 1 To objSortItems.Count
                'Betreff des aktuellen Elements holen
                strBetreff = objSortItems(lngI).Subject
                'Wenn Betreff vorhanden, dann...
                If strBetreff > "" Then
                    '... diesen in Listenfeld einfgen
                    .AddItem strBetreff
                    'Indexnummer des Elements in Spalte 2 einfgen
                    .List(.ListCount - 1, 1) = lngI
                End If
            Next
        
            'Wenn Listenfeld Elemente enthlt, dann...
            If .ListCount > 0 Then
                '... erstes Element markieren
                .ListIndex = 0
            End If
            
            'Ordnernamen und Anzahl der Elemente in Userform-Beschriftung bernehmen
            Me.Caption = "Ordner " & objOLOrdner.Name & " - " & CStr(.ListCount) & " Elemente"
        End With
    End If
    
    'ButtonStatus-Prozedur aufrufen
    Call ButtonStatus
End Sub

Private Sub lstElemente_DblClick(ByVal Cancel As MSForms.ReturnBoolean)
    'Bei Doppelklick auf Listenelement cmdOK_Click-Prozedur aufrufen
    Call cmdOK_Click
End Sub

Private Sub cmdOK_Click()
    Dim lngIndex As Integer
    
    'Wenn Listenfeld Elemente enthlt, dann...
    If lstElemente.ListCount > 0 Then
        '... Index des ausgewhlten Elements aus Listenfeldspalte 2 lesen
        lngIndex = lstElemente.List(lstElemente.ListIndex, 1)
        'Verweis auf entsprechendes Element des Item-Arrays in
        'ffentliche objGewhltesElement-Variable kopieren
        Set objGewhltesElement = objSortItems(lngIndex)
    
        'Userform verbergen
        Me.Hide
    End If
End Sub

Private Sub cmdCancel_Click()
    'Userform verbergen
    Me.Hide
End Sub

'**************************************************************
'Routinen
'**************************************************************

Private Sub ButtonStatus()
    'cmdOK-Schaltflche nur aktivieren, wenn Listenfeld Elemente enthlt
    cmdOK.Enabled = lstElemente.ListCount > 0
End Sub

