#include <QtTest/QtTest>
#include "xmlreader.h"

Q_DECLARE_METATYPE( QDate );

class TestXMLParser : public QObject
{
    Q_OBJECT

private slots:
    void initializeTestCase()
        {
            xmlReader();
        }

    void testValue_data()
        {
            QTest::addColumn<QDate>( "date" );
            QTest::addColumn<QString>( "currency" );
            QTest::addColumn<double>( "rate" );

            QTest::newRow( "USD" ) << QDate( 2006, 02, 23 ) << "USD" << 1.1957;
            QTest::newRow( "SEK" ) << QDate( 2006, 02, 23 ) << "SEK" << 8.4103;
            QTest::newRow( "CYP" ) << QDate( 2006, 02, 23 ) << "CYP" << 0.5747;
            QTest::newRow( "PLN" ) << QDate( 2006, 02, 23 ) << "PLN" << 3.7928;
        }

    void testValue()
        {
            QFETCH( QDate, date );
            QFETCH( QString, currency );
            QFETCH( double, rate );
            QCOMPARE( exchangeRates[qMakePair(date, currency)], rate );
        }
};

QTEST_MAIN(TestXMLParser)

#include "main.moc"

