#include "exchangewidget.h"
#include "xmlreader.h"
#include <QGridLayout>
#include <QDateEdit>
#include <QLabel>
#include <QLineEdit>

ExchangeWidget::ExchangeWidget( QWidget* parent ) :
    QWidget( parent )
{
    xmlReader();

    setObjectName( "ExchangeWidget" );
    setWindowTitle( tr( "Exchange Widget" ) );

    QGridLayout* layout = new QGridLayout();
    setLayout( layout );

    layout->addWidget( new QLabel( tr( "Date" ), this ), 0, 0 );
    layout->addWidget( new QLabel( tr( "Currency" ), this ), 0, 1 );
    layout->addWidget( new QLabel( tr( "Rate" ), this ), 0, 2 );

    mDateEdit = new QDateEdit( this );
    layout->addWidget( mDateEdit, 1, 0 );
    connect( mDateEdit, SIGNAL( dateChanged( const QDate& ) ),
             this, SLOT( slotRecompute() ) );

    mCurrencyEdit = new QLineEdit( this );
    layout->addWidget( mCurrencyEdit, 1, 1 );
    connect( mCurrencyEdit, SIGNAL( textChanged( const QString& ) ),
             this, SLOT( slotRecompute() ) );

    mRateField = new QLabel( tr( "N/A" ), this );
    mRateField->setFrameStyle( QFrame::WinPanel|QFrame::Sunken );
    mRateField->setFixedWidth( 80 );
    layout->addWidget( mRateField, 1, 2 );
}

void ExchangeWidget::reset()
{
    mDateEdit->setDate( QDate( 2000, 1, 1 ) );
    mDateEdit->setCurrentSection( QDateTimeEdit::DaySection );
    mCurrencyEdit->setText( "" );

}

void ExchangeWidget::slotRecompute()
{
    QMap<QPair<QDate,QString>, double>::iterator rateIt = exchangeRates.find(qMakePair(mDateEdit->date(), mCurrencyEdit->text()));
    if( rateIt != exchangeRates.end() ) {
        mRateField->setText( QString::number( *rateIt ) );
        emit rateChanged( *rateIt );
    } else
        mRateField->setText( tr( "N/A" ) );
}

