using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing; 

namespace GummibandAlsKlasse
{
  class Gummiband
  {
    Control parent; 
    private bool enabled;
    Rectangle rectGummi;
    public event InvalidateEventHandler Selected;
    protected void OnSelected(InvalidateEventArgs e)
    {
      if (Selected != null)
        Selected(this, e); 
    }
    public bool Enabled
    {
      get { return enabled; }
      set 
      { 
        enabled = value;
        if (value)
        {
          parent.MouseDown += MouseDown;
          parent.MouseMove += MouseMove;
          parent.MouseUp += MouseUp;
        }
        else
        {
          parent.MouseDown -= MouseDown;
          parent.MouseMove -= MouseMove;
          parent.MouseUp -= MouseUp;
        }
      }
    } 
    public Gummiband(Control c)
    {
      parent = c; 
    }
    private void MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
    {
      if ((e.Button & MouseButtons.Left) > 0)  // linke Maustaste?      
      {
        rectGummi.Location = Control.MousePosition;
      }
    }

    private void MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
    {
      if ((e.Button & MouseButtons.Left) > 0)  // linke Maustaste?
      {
        if (parent.ClientRectangle.Contains(new Point(e.X, e.Y)))
        {
          ControlPaint.DrawReversibleFrame(rectGummi, parent.BackColor, FrameStyle.Dashed);
          rectGummi.Size = (Size)Control.MousePosition - (Size)rectGummi.Location;
          ControlPaint.DrawReversibleFrame(rectGummi, parent.BackColor, FrameStyle.Dashed);
        }
      }
    }

    private void MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
    {
      if ((e.Button & MouseButtons.Left) > 0)  // linke Maustaste?      
      {
        ControlPaint.DrawReversibleFrame(rectGummi, parent.BackColor, FrameStyle.Dashed);
        InvalidateEventArgs iva = new InvalidateEventArgs(rectGummi);
        OnSelected(iva); 
        rectGummi.Size = new Size(0, 0);
      }
    }
  }
}
