using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Messwertschreiber
{
  public partial class MesswertschreiberRescaling : Messwertschreiber
  {
    public MesswertschreiberRescaling()
    {
      InitializeComponent();
    }
    // Hausaufgabe
    public class MesswertRescaleEventArgs : EventArgs
    {
      public float min;
      public float max;
    }
    public delegate void MesswertRescaleEventHandler(object sender, MesswertRescaleEventArgs e);
    public event MesswertRescaleEventHandler Rescale;
    protected virtual void OnRescale(MesswertRescaleEventArgs e)
    {
      if (Rescale != null)
        Rescale(this, e);
    }
    void RescaleTest()
    {
      MesswertRescaleEventArgs mrea = new MesswertRescaleEventArgs();
      mrea.max = mrea.min = valArr[0];
      for (int i = 1; i < valArr.Length; i++)
      {
        if (mrea.max < valArr[i]) mrea.max = valArr[i];
        if (mrea.min > valArr[i]) mrea.min = valArr[i];
      }
      if ((mrea.max - mrea.min) < (Max - Min) / 2)
      {
        OnRescale(mrea);
      }
    }
    // Hausaufgabe ende

    [Description("Nchster auszugebender Wert. Lst Overflow und Rescale-Ereignisse aus")]
    public override float Value
    {
      get
      { return valArr[showindex]; }
      set
      {
        base.Value = value; 
        if (showindex == 0 && ArrFull)
          RescaleTest();  // Hausaufgabe
      }
    }
  }
}

