using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace Messwertschreiber
{
  [DefaultEvent("Overflow")]
  public partial class Messwertschreiber : UserControl
  {
    float m_max;
    float m_min;
    protected float[] valArr = new float[1];
    protected bool ArrFull = false;
    protected int showindex;
    public class MesswertEventArgs : EventArgs
    {
      public float criticalValue;
    }

    public delegate void MesswertEventHandler(object sender, MesswertEventArgs e);
    public event MesswertEventHandler Overflow;
    protected virtual void OnOverflow(MesswertEventArgs e)
    {
      if (Overflow != null)
        Overflow(this, e);
    }

    [Browsable(false)]
    public virtual float Value
    {
      get
      { return valArr[showindex];}
      set 
      {
        if (value > Max || value < Min)
        {
          MesswertEventArgs mea = new MesswertEventArgs();
          mea.criticalValue = value; 
          OnOverflow(mea);  // Ereignis auslsen
          value = mea.criticalValue; 
        }
        valArr[showindex] = value;
        showindex++;
        if (showindex == NValues)
        {
          showindex = 0;
          ArrFull = true;
        }
        Invalidate(); 
      }
    }

    [Description("Obere Grenze des Anzeigeintervalls, berschreitung lst Overflow-Ereignis aus")]
    public float Max
    {
      get { return m_max; }
      set 
      {
        if (value > Min)
        {
          m_max = value;
          Invalidate();
        }
      }
    }

    [Description("Untere Grenze des Anzeigeintervalls, Unterschreitung lst Overflow-Ereignis aus")]
    public float Min
    {
      get { return m_min; }
      set 
      {
        if (value < Max)
        {
          m_min = value;
          Invalidate();
        }
      }
    }

    [Description("Anzahl der im Fenster dargestellten Messwerte")]
    public int NValues
    {
      get 
      { return valArr.Length; }
      set  // Arrayabmessungen ndern
      {
        valArr = new float[value];
        showindex = 0;
        ArrFull = false; 
        if (DesignMode)
          initSinus();
        Invalidate(); 
      }
    }
    public Messwertschreiber()
    {
      InitializeComponent();
      if (DesignMode)
      {
        Max = 1;
        Min = -1;
        NValues = 5;
      }
    }

    // initialisiert Steuerelement mit Sinuskurve
    void initSinus()
    {
      showindex = 0;
      int n = NValues; 
      for (int i = 0; i < n; i++)
      {
        Value = (float)Math.Sin(2 * Math.PI / (n-1) *i); 
      }
    }

    private void Messwertschreiber_Paint(object sender, PaintEventArgs e)
    {
      Pen pen = new Pen(base.ForeColor); 
      // Skalierung der Ausgabe
      float vscale = (float)Height / (Max - Min);
      float hscale = (float)Width / (valArr.Length-1);
      // Nulloffset
      e.Graphics.TranslateTransform(0, Max*vscale);
      e.Graphics.ScaleTransform(1, -1); // Orientierung
      // Liniensegmente ausgeben: neuester Wert am linker Rand
      for (int i = 0; i < NValues - 1 && ArrFull || i < showindex - 1; i++)
      {
        int idx = (showindex -1 + NValues - i) % NValues;
        float w0 = valArr[idx] * vscale;
        if (idx == 0)
          idx = NValues; 
        float w1 = valArr[idx - 1] * vscale;
        PointF p0 = new PointF(i * hscale, w0);
        PointF p1 = new PointF((i + 1) * hscale, w1);
        e.Graphics.DrawLine(pen, p0, p1);
      }
    }

    private void Messwertschreiber_Load(object sender, EventArgs e)
    {
      if(DesignMode)
        initSinus();
   }
  }
}