package hibernate.ct.beispiele;

import hibernate.ct.Angestellter;
import hibernate.ct.FreierMitarbeiter;
import hibernate.ct.Mitarbeiter;

import java.util.Iterator;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.expression.Expression;

public class Beispiel_Criteria {

	public static void main(String[] args) throws Exception {
		Configuration configuration = new net.sf.hibernate.cfg.Configuration();
		configuration.addFile("Mapping.hbm.xml");
		SessionFactory factory = configuration.buildSessionFactory();
		Session session = factory.openSession();
		try {
			// Speichern von 2 Beispielmitarbeitern 
			session.save(new FreierMitarbeiter("Mller", "Manfred"));
			session.save(new Angestellter("Meier", "Michael"));

			// Der Nachname soll mit "Me" beginnen
			Criteria criteria = session.createCriteria(Mitarbeiter.class);
			criteria.add(Expression.like("nachname", "Me%"));

			// Abfrage und Ausgabe
			for (Iterator iter = criteria.list().iterator(); iter.hasNext();) {
				Mitarbeiter m = (Mitarbeiter) iter.next();
				System.out.println("Mitarbeiter: " + m.getNachname() + ", "
						+ m.getVorname());
			}

		} finally {
			session.close();
			factory.close();
		}
	}
}
