' Kontodaten.vbs 1.0        c't 13/06 	        Autor: Karsten Violka, kav@ctmagazin.de
' Listet die Benutzerkonten und -Gruppen des lokalen Systems auf
' Inspiration: http://www.activexperts.com/activmonitor/windowsmanagement/adminscripts/usersgroups/localusers/
' -------------------------------------------------------------------------------------
Option Explicit

Dim fso, wsh
set fso = CreateObject("Scripting.FileSystemObject")
set wsh = CreateObject("WScript.Shell")

Dim objWMIService
Dim strComputer, objAccount, colItems, objItem, i

Dim objLogFile, logFilename
set objLogFile = Nothing

logFilename=wsh.CurrentDirectory & "\ausgabe.txt"

logAppend("----- Benutzerkonten -----------------------------------------------------------")

strComputer = "."
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")

Set colItems = objWMIService.ExecQuery _
   ("Select * from Win32_UserAccount Where LocalAccount = True")
   
i=1
For Each objItem in colItems
	logAppend("--- " & i & " ---------------------------------------------")
	logAppend("Name: " & objItem.Name)
	logAppend("Beschreibung: " & objItem.Description)
	logAppend("Abgeschaltet: " & objItem.Disabled)
	logAppend("Domne: " & objItem.Domain)
	logAppend("Voller Name: " & objItem.FullName)
	logAppend("Lokales Konto: " & objItem.LocalAccount)
	logAppend("Lockout: " & objItem.Lockout)
	logAppend("Passwort nderbar: " & objItem.PasswordChangeable)
	logAppend("Password luft ab: " & objItem.PasswordExpires)
	logAppend("Password bentigt: " & objItem.PasswordRequired)
	logAppend("SID: " & objItem.SID)
	i=i+1
Next

logAppend(vbCrLf & "----- Gruppen ----------------------------------------------------------")

Set colItems = objWMIService.ExecQuery _
    ("Select * from Win32_Group Where LocalAccount = True")

i=1
For Each objItem in colItems
	logAppend("--- " & i & " ----------------------------------------")
	logAppend("Name: " & objItem.Name)
    	logAppend("Beschreibung: " & objItem.Description)
    	logAppend("Domne: " & objItem.Domain)
	logAppend("SID: " & objItem.SID)
	i=i+1
Next

objLogFile.Close()
wsh.Run("notepad.exe " & logFileName)

' --- Funktionen --------------------------------------------------------------------------


'--- logAppend(String) --------------------------------------------------------------------
' hngt den bergebenen Text an die Log-Datei an
Function logAppend(string)
	const forWriting = 2
	dim errnum
	' Loddatei nur ffnen, wenn das noch nicht geschehen ist
	If objLogFile Is Nothing Then
		On Error Resume Next
		Set objLogFile = fso.OpenTextFile(logFilename, forWriting, true)
		errnum = Err.Number
		On Error Goto 0
		If errnum <> 0 Then
			Err.Raise 1, "logAppend", "Konnte Logdatei nicht ffnen"
		End If
	End If
	
	On Error Resume Next
	objLogFile.WriteLine(string)
	errnum = Err.Number
	On Error Goto 0
	If errnum <> 0 Then
		Err.Raise 1, "logAppend", "konnte nicht in Logdatei schreiben"
	End If
End Function
