<?php
if($_REQUEST['suche']){
	// Load Wortschatz Class
	include_once('WortschatzClient.php');
	 
	$wortschatz = new WortschatzClient();
	try {
		$wortschatzResult = $wortschatz->getSynonyme('de', utf8_encode($_REQUEST['suche']));
	} catch (SOAPFault $f) {
		$error = "***" . $f->faultstring . "***";
	}
	
	// Load general helper classes for eBay SOAP API
	require_once 'eBaySOAP/eBaySOAP.php';
	
	// Load developer-specific configuration data from ini file
	include_once('eBaySOAP/ebay.ini.php');
	$site = $config['settings']['site'];
	
	// Create and configure session
	$session = new eBaySession($config[$site]['devId'], $config[$site]['appId'], $config[$site]['cert']);
	$session->token = $config[$site]['authToken'];
	$session->site = 77; // 100 = eBay Motors
	$session->location = $config[$site]['gatewaySOAP'];

	try {
		$client = new eBaySOAP($session);
	
		$params = array('Version' => 425, 
						'Query' => utf8_encode($_REQUEST['suche']),
					    );
	
		$results = $client->GetSearchResults($params);
	} catch (SOAPFault $f) {
		$error = $f;
	}
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>EBay - Wortschatz - Mashup</title>
<style type="text/css">
<!--
form {
	background-color: #ffcc00;
	padding:10px;
	text-align: center;
}
#synonymeResult ul {
	list-style-type: none;
}
#synonymeResult li {
	list-style-type: none;
	display:inline;
	margin-right:10px;
	padding-right:10px;
	border-right:1px solid #666666;
}
label {
	margin-right: 20px;
}
body {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
}
-->
</style>
</head>

<body>
<form id="ebaySearch" name="ebaySearch" method="post" action="mashup.php">
	<label for="textfield">eBay Suche</label>
	<input type="text" name="suche" id="suche" value="<?= $_REQUEST['suche'] ?>" />
	<input type="submit" name="Submit" value="Finden" />
</form>

<? 
if($_REQUEST['suche']){
	if($error){ 
		echo $error; 
	} else {
		if(!empty($wortschatzResult)) {
			echo '<div id="synonymeResult">hnliche Wrter: <ul>';
			foreach($wortschatzResult as $row){
				echo '<li><a href="mashup.php?suche='.utf8_decode($row).'">'.utf8_decode($row).'</a></li>';
			}
			echo '</ul></div>';
		}
		else {
			echo "<p>Leider keine passenden Synonyme...</p>";
		}
		if(!empty($results->SearchResultItemArray)) {
			echo '<div id="ebayResult">Ergebnis: <ul>';
			foreach ($results->SearchResultItemArray as $item) {
				echo '<li><a href="'.$item->Item->ListingDetails->ViewItemURL.'">'.utf8_decode($item->Item->Title).'</a></li>';
			}
			echo '</ul></div>';
		}
		else {
			echo "<p>Leider keine passenden Suchergebnisse zu dem Beriff...</p>";
		}	
	}
}
?>

</body>
</html>
