/* $Id: pi-openmp-critical2.c 844 2006-06-20 09:56:54Z olau $ */

#include <stdio.h>
#include <math.h>
#ifdef _OPENMP
#include <omp.h>
#include "ompdefs.h"
#endif
#include "globaldefs.h"

int main(int argc, char *argv[]) {
  int i;
  double w, x, sum, pi;
  double t;

  printf("Anzahl Prozessoren: %d\n", omp_get_num_procs());
  t = omp_get_wtime();
  w = 1.0 / DEFAULT_ITERATIONS;
#pragma omp parallel shared(sum, w) private(x)
  {
# ifdef DEBUG
    printf("Dies ist Thread %3d von %3d\n",
      omp_get_thread_num(),
      omp_get_num_threads());
# endif
#pragma omp for 
    for (i = 1; i <= DEFAULT_ITERATIONS; i++) {
      x = w * ((double)i - 0.5);
#pragma omp critical
      sum += f(x);
    }
  }
  pi = w * sum;
  printf("pi = %.13lf (Fehler = %.13lf)\n", pi, pi - PI);
  printf("Ausfuehrungsdauer: %.2lf ms\n\n", 1000 * (omp_get_wtime() - t));
  return 0;
}
