/* $Id: pi-openmp-illegal.c 846 2006-06-20 20:25:22Z olau $ */

#include <stdio.h>
#include <math.h>
#include "globaldefs.h"
#ifdef _OPENMP
#include <omp.h>
#include "ompdefs.h"
#endif
#include "timer/timer.h"

int main(int argc, char *argv[]) {
  int i;
  double w, x, sum, pi;
  LONGLONG duration;

  START();
  w = 1.0 / DEFAULT_ITERATIONS;
  sum = 0;
#pragma omp parallel for shared(w) private(x) reduction(+:sum)
  for (i = 1; i <= DEFAULT_ITERATIONS; i++) {
    x = w * ((double) i - 0.5);
    sum += f(x); /* f(x) = 4/(1+x^2) */
    if (fabs(pi - PI) < 1e-12)
      goto ILLEGAL;
  }
 ILLEGAL:
  pi = w * sum;
  STOP(duration);
  printf("pi = %.13lf (Fehler: %.13lf)\n", pi, pi - PI);
  printf("Ausfuehrungsdauer: %lld ms\n\n", duration / 1000LL);
  return 0;
}
