<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
 <head>
  <title>Office-Dokumente bearbeiten</title>
  <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
 </head>

 <body>
  <h1>Office-Dokumente im ODF- und OpenXML-Format bearbeiten</h1>
  <h2>Herbert Braun, Bürodynamik, ODF- und OpenXML-Dokumente mit PHP bearbeiten, c't 18/06, S. 206</h2>
  <p>
   Dieses Skript hat eher Demo-Charakter, als dass es sich für Produktionseinsatz eignet. Es soll die Möglichkeiten veranschaulichen, ODF- und OpenXML-Dateien mit PHP und anderen Skriptsprachen zu bearbeiten. Nicht auf öffentlich zugänglichen Webseiten einsetzen!
  </p>

<?php
error_reporting(E_ALL);

$felder = array(
 'Dokument', // Auswahlliste
 'Anrede', // Auswahlliste
 'Vorname',
 'Name',
 'Straße',
 'Plz',
 'Ort',
 'Betreff',
 'Begrüßung',
 'Datum', // mit Vorgabewert für heutiges Datum
 'Text' // Textarea
);
$vorlagenverzeichnis = '.';

function label_konvertieren($_label) {
 $_umlaute = array('ä', 'ö', 'ü', 'Ä', 'Ö', 'Ü', 'ß');
 $_ersetzungen = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss');
 return(strtolower(str_replace($_umlaute, $_ersetzungen, $_label)));
}

// Kein Dokument ausgewählt -> Eingabefelder zeigen
if (!isset($_POST['dokument'])) {
 print('  <form method="post" action="">' . "\n");
 foreach ($felder as $label) {
  $feldname = label_konvertieren($label);
  $werteliste = array();
  $defaultwert = '';
  $textarea = false;
  print("   <p>\n    <label for=\"" . $feldname . '">' . $label . "</label><br/>\n");

  // besondere Eingabefelder vorbereiten
  if ($feldname == "dokument") {
   // holt alle Office-Vorlagen aus $vorlagenverzeichnis
   if (!is_dir($vorlagenverzeichnis)) die("$vorlagenverzeichnis lässt sich nicht öffnen!");
   if ($_vh = opendir($vorlagenverzeichnis)) {
    while (($_datei = readdir($_vh)) !== false) {
     // ermittelt mit einem regulären Ausdruck Office-Dateiendungen
     if (preg_match('/\.((o[td][a-z])|((do|xl|pp|po)[ctsa][xm]))$/', $_datei)) $werteliste[] = $_datei;
    }
    closedir($_vh);
    if (!count($werteliste)) die("Keine Vorlagen in Verzeichnis $vorlagenverzeichnis gefunden!");
   }

  } else if ($feldname == "anrede") {
   $werteliste = array('Herr', 'Frau', 'Firma');

  } else if ($feldname == 'datum') {
   $_h = getDate();
   $defaultwert = sprintf("%02d.%02d.%4d", $_h['mday'], $_h['mon'], $_h['year']);
  } else if ($feldname == 'text') {
   $textarea = true;
  }

  // Ausgabe als Eingabefeld oder Select-Liste
  if ($werteliste) {
   print('    <select name="' . $feldname . '" id="' . $feldname . "\">\n");
   foreach ($werteliste as $wert) print("     <option>$wert</option>\n");
   print("    </select>\n");

  } else if ($textarea) {
   print('    <textarea name="' . $feldname . '" id="' . $feldname . '" rows="5" cols="40"></textarea>' . "\n");

  } else {
   print('    <input type="text" name="' . $feldname . '" id="' . $feldname . '" value="' . $defaultwert . '"/>' . "\n");
  }
  if ($feldname == "dokument") print ("<br/>\n    <label for='serienbrief'>ODF-Serienbrief</label>\n    <input type='checkbox' name='serienbrief' id='serienbrief'/>\n");
  print("   </p>\n");
 }
?>

   <p>
    <input type="submit" name="ok" value="Abschicken"/>
   </p>
  </form>

<?php
// Dokumentname wurde übergeben -> Dokument bearbeiten
} else {
 require_once('odf.class.php');
 $odf = new Odf;
 $odf->setNames($_POST['dokument'], '');
 $odf->setTmpDir('_tmp/');
 $odf->setOutputDir('doc/');
 $bild = $odf->writeThumbnail();
 if ($bild) print('  <p><img src="' . $bild . '" alt="Vorschau" border="1"/></p>' . "\n");
 $dokument = $odf->getXmlContent();
 if (isset($_POST['serienbrief'])) {
  print("   <p>Ersetze Serienbrieffelder ...</p>\n");
  $odf->isSerial(true);
 } else {
  print("   <p>Ersetze Platzhalter ...</p>\n");
  $odf->setSeparators('__', '__');
 }
 $felder_werte = array();
 foreach ($felder as $label) {
  $feldname = label_konvertieren($label);
  $felder_werte[$feldname] = $_POST[$feldname];
 }
 $odf->replaceFields($felder_werte);
 $datei = $odf->saveFile();
 print('  <p><a href="' . $datei . '">' . $_POST['dokument'] . ' (aktualisiert)</a></p>' . "\n");
}
?>

  <p>&copy; Herbert Braun, c't, August 2006 | heb at ct Punkt heise Punkt de</p>

 </body>
</html>
