unit apfelimage;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls,apfelcommon, StdCtrls, ComCtrls;

type
  TForm2 = class(TForm)
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    StatusBar1: TStatusBar;
    procedure showscreen; 
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Yw: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Setimage (xmax,ymax:integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Yw: Integer);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }

  end;

var
  Form2: TForm2;
 
implementation

{$R *.dfm}


Procedure TForm2.Showscreen;
var x,y,yw,w:integer;
var rgb:longword;
var pl:pLongint;
var dp:longword;
begin
 for y:=0 to ymax-1 do
  begin
  yw:=ymax-1-y;
  pl:=Image1.Picture.Bitmap.ScanLine[yw];
  for x:=0 to xmax-1 do
  begin
   w:=ascreen[y*xmax+x];
   if w > maxiter then w:=0 else w:=rgbtab[w];

   pl^:=w;
   inc (pl);
  end;

 end;
 image1.refresh;
end;

procedure TForm2.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Yw: Integer);
var msg:Tmessage;
begin
msg.WParam:=0;
case Button of
 mbleft: msg.WParamlo:=2;
 mbright:msg.WParamhi:=2;
end;

msg.LParamLo:=x;
msg.LParamHi:=ymax-1-yw;

sendMessage (Form1handle,WM_User+0,msg.WParam,msg.LParam);



end;


Procedure TForm2.Setimage (xmax,ymax:integer);
begin
image1.width:=xmax;
image1.height:=ymax;

With image1.Picture.Bitmap do
 begin
 Width:=xmax;
 Height:=ymax;
 PixelFormat:=pf32Bit;
 Canvas.FillRect(Rect(0,0,xmax-1,ymax-1));
 end;

end;

procedure TForm2.FormCreate(Sender: TObject);
begin
image1.Picture.Bitmap:=TBitmap.Create;
Setimage (xmax,ymax);
end;

procedure TForm2.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Yw: Integer);
var y,w:integer;
begin
statusbar1.Panels[0].Text:=inttostr(x);
statusbar1.Panels[1].Text:=inttostr(yw);
y:=ymax-1-yw;
statusbar1.panels[2].text:=Floattostr(r0+x*del);
statusbar1.panels[3].text:=Floattostr(i0+y*del);
w:=ascreen[y*xmax+x];
statusbar1.panels[4].Text:=inttostr(w);
if w<= high(rgbtab) then statusbar1.Panels[5].Text:=inttohex(rgbtab[w],8)
else statusbar1.Panels[5].Text:='????';
end;

end.
