namespace Sudoku
{
    public enum SudokuStatus
    {
        NoSolution, OneSolution, MoreSolutions, Timeout
    }

    public partial class SudokuField
    {
        public int Iterations;
        private int MaxIterations;
        private SudokuField Solution, SecondSolution;

        /// <summary>
        /// Solves actual SudokuField using simple backtracking only.
        /// </summary>
        /// <returns>NoSolution, OneSolution, MoreSolutions, Timeout</returns>
        public SudokuStatus Solve()
        {
            SudokuStatus Status = GetStatus(int.MaxValue);
            if (Status == SudokuStatus.OneSolution || Status == SudokuStatus.MoreSolutions)
                Copy(Solution);
            return Status;
        }

        /// <summary>
        /// Calculates the status of the actual SudokuField without changing its Digits and Lists.
        /// </summary>
        /// <param name="MaxNumberOfIterations">Max. number of Iterations</param>
        /// <returns>NoSolution, OneSolution, MoreSolutions, Timeout (result is in Solution)</returns>
        private SudokuStatus GetStatus(int MaxNumberOfIterations)
        {
            SudokuField Backup = new SudokuField(this);
            Iterations = 0;
            MaxIterations = MaxNumberOfIterations;
            SudokuStatus Status = Search(SudokuStatus.NoSolution, 0, 0);
            Copy(Backup);
            return Status;
        }

        private SudokuStatus Search(SudokuStatus Status, int i, int j)
        {
            if (i >= nn)                  // solved, if all Digits set
            {
                SecondSolution = Solution;
                Solution = new SudokuField(this);
                return Status + 1;
            }
            if (Digits[i, j] != 0)        // cell is given, take next cell
                return Search(Status, i + (j + 1) / nn - j / nn, (j + 1) % nn);
            if (++Iterations >= MaxIterations)
                return SudokuStatus.Timeout;
            for (int Digit = 1; Digit <= nn; Digit++)
                if (TestRules(i, j, Digit))
                {
                    Digits[i, j] = Digit; // put Digit into Sudoku
                    Status = Search(Status, i + (j + 1) / nn - j / nn, (j + 1) % nn);
                    if (Status >= SudokuStatus.MoreSolutions)
                        return Status;    // don't search further
                    Digits[i, j] = 0;     // restore old Digit
                }
            return Status;
        }
    }
}
